/*
 * Decompiled with CFR 0.152.
 */
package fxterm.core;

import fxterm.app.id.LoggerId;
import fxterm.core.reboot.SafeReboot;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;
import ru.softlogic.reference.References;
import ru.softlogic.reference.point.Point;
import ru.softlogic.reference.point.PowerSchedule;

public class PowerScheduler
implements Runnable {
    private final ScheduledExecutorService service;
    private final Logger log = LoggerId.APP;

    public PowerScheduler(ScheduledExecutorService service) {
        if (service == null) {
            throw new NullPointerException("ScheduledExecutorService is null");
        }
        this.service = service;
    }

    @Override
    public void run() {
        Date pOff = this.getHour();
        Date curr = new Date();
        this.log.info((Object)("Power off hour: " + pOff));
        if (pOff != null && pOff.after(curr)) {
            long diff = pOff.getTime() - curr.getTime();
            this.log.info((Object)("Diff: " + diff / 1000L / 60L + "min"));
            if (diff < 1860000L) {
                this.service.schedule(new Shutdowner(), diff, TimeUnit.MILLISECONDS);
            } else {
                this.service.schedule(this, 30L, TimeUnit.MINUTES);
            }
        } else {
            this.service.schedule(this, 30L, TimeUnit.MINUTES);
        }
    }

    private PowerSchedule getPowerOff(int day) {
        Point p = References.getPoint();
        if (p != null && p.getPowerSchedules() != null) {
            List pses = p.getPowerSchedules();
            for (PowerSchedule ps : pses) {
                if (ps.getType() != 1 || (ps.getDays() & day) == 0) continue;
                return ps;
            }
        }
        return null;
    }

    private Date getHour() {
        PowerSchedule ps;
        GregorianCalendar cal = new GregorianCalendar();
        int day = cal.get(7);
        if (day == 1) {
            day = 8;
        }
        if ((ps = this.getPowerOff(1 << (day -= 2))) == null) {
            return null;
        }
        cal.set(11, ps.getHour());
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        return cal.getTime();
    }

    private class Shutdowner
    implements Runnable {
        private Shutdowner() {
        }

        @Override
        public void run() {
            PowerScheduler.this.log.info((Object)"Poweroff");
            SafeReboot.shutdown(7);
        }
    }
}

