/*
 * Decompiled with CFR 0.152.
 */
package fxterm.core;

import fxterm.app.id.LoggerId;
import fxterm.core.reboot.SafeReboot;
import fxterm.session.Session;
import java.lang.management.ManagementFactory;
import java.util.Date;
import java.util.GregorianCalendar;
import org.apache.log4j.Logger;
import ru.softlogic.reference.References;

public class NoPaymentsRebooter
implements Runnable {
    private final Logger log = LoggerId.APP;

    @Override
    public void run() {
        try {
            GregorianCalendar cal = new GregorianCalendar();
            int hour = cal.get(11);
            boolean useNightMode = References.getPointOptions().isUseNightMode();
            if ((hour < 8 || hour >= 22) && useNightMode) {
                return;
            }
            int timeOut = References.getPointOptions().getNotPaymentRebootTimeout();
            if (timeOut <= 0) {
                return;
            }
            Date pd = Session.getLastPaymentDate();
            long paymentTimeout = 0L;
            paymentTimeout = pd == null ? ManagementFactory.getRuntimeMXBean().getUptime() / 1000L : Math.min(ManagementFactory.getRuntimeMXBean().getUptime(), System.currentTimeMillis() - pd.getTime()) / 1000L;
            if (paymentTimeout > (long)(timeOut * 60)) {
                this.log.info((Object)("\u041f\u0435\u0440\u0435\u0437\u0430\u0433\u0440\u0443\u0437\u043a\u0430 \u0442\u0435\u0440\u043c\u0438\u043d\u0430\u043b\u0430 \u0438\u0437-\u0437\u0430 \u043e\u0442\u0441\u0443\u0442\u0441\u0432\u0438\u044f \u043f\u043b\u0430\u0442\u0435\u0436\u0435\u0439 \u0431\u043e\u043b\u044c\u0448\u0435 " + timeOut + " \u043c\u0438\u043d\u0443\u0442.(" + paymentTimeout + " \u0441\u0435\u043a)"));
                SafeReboot.exit(0, 13);
            }
        }
        catch (Throwable ex) {
            this.log.error((Object)ex, ex);
        }
    }
}

