/*
 * Decompiled with CFR 0.152.
 */
package fxterm.core;

import fxterm.core.activity.UserAction;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.log4j.Logger;
import plfx.Options;
import plfx.shell2.timer.Timer;
import plfx.shell2.timer.TimerEntity;

public class BaseTimer
implements Timer {
    private final List<TimerEntity> entitys;
    private final Logger log = Options.GUI;
    private final UserAction userAction;

    public BaseTimer(UserAction userAction) {
        this.userAction = userAction;
        this.entitys = new LinkedList<TimerEntity>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            while (!Thread.currentThread().isInterrupted()) {
                BaseTimer baseTimer = this;
                synchronized (baseTimer) {
                    if (!this.entitys.isEmpty()) {
                        Iterator<TimerEntity> iterator = this.entitys.iterator();
                        while (iterator.hasNext()) {
                            TimerEntity te = iterator.next();
                            this.log.info((Object)("### " + te));
                            if (!te.process(this.userAction.getPassed())) continue;
                            this.log.info((Object)"     entity complete");
                            iterator.remove();
                        }
                    }
                }
                Thread.sleep(1000L);
            }
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addEntity(TimerEntity entity) {
        if (entity == null) {
            throw new NullPointerException("TimerEntity");
        }
        BaseTimer baseTimer = this;
        synchronized (baseTimer) {
            this.entitys.add(entity);
        }
    }
}

