/*
 * Decompiled with CFR 0.152.
 */
package fxterm.core;

import fxterm.app.FxEnv;
import fxterm.session.Session;
import plfx.GuiNotifier;
import plfx.screen.CommonScreen;
import plfx.screen.ScreenCreateException;
import plfx.screen.ScreenInit;
import plfx.screen.ScreenListener;
import plfx.screen.ScreenStore;
import ru.softlogic.input.model.field.InitException;
import ru.softlogic.input.model.screen.description.ScreenDescription;

public abstract class BaseScreenListener
implements ScreenListener {
    public void onSelectLang(String lang) {
        Session.setLanguage(lang);
    }

    public void onNextLang() {
        Session.setNextLanguage();
    }

    public void onSelectField(int index) {
        Session.setActiveField(index);
    }

    public void setFieldPage(int index, int pageSize) {
        Session.setFieldPage(index, pageSize);
    }

    public void showPopup(ScreenDescription sd, ScreenInit si, ScreenListener listener) {
        try {
            CommonScreen cs = ScreenStore.getCommonScreen((String)sd.getType());
            if (cs != null) {
                cs.init(sd, si);
                FxEnv.getPopupModule().show(cs, listener, 60);
            } else {
                GuiNotifier.notifyError((String)("Can't get screen for type: " + sd.getType()));
            }
        }
        catch (ScreenCreateException | InitException ex) {
            GuiNotifier.notifyError((Throwable)ex);
        }
    }

    public void notifyUpdate() {
        Session.notifyUpdate();
    }
}

