/*
 * Decompiled with CFR 0.152.
 */
package fxterm.core;

import fxterm.module.PackUtility;
import fxterm.session.Session;
import fxterm.utils.FinUtils;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import ru.softlogic.cash.Sum;
import ru.softlogic.cash.unit.CashUnit;
import ru.softlogic.reference.service.Service;
import ru.softlogic.service.comission.Commission;
import ru.softlogic.service.comission.CommissionStep;
import ru.softlogic.service.comission.CommissionType;
import ru.softlogic.service.comission.CommissionUnit;
import ru.softlogic.service.comission.FeeSum;
import ru.softlogic.service.comission.SumResult;

public class BaseCommissionCalculator {
    public static SumResult calculate(Sum cash, Sum cashlees, Map<CashUnit, Integer> denominations, Commission commission, Service service, boolean ignoreMinMaxComm, Sum trade, Sum maxPaymentSum, FeeSum providerFee) {
        return BaseCommissionCalculator.calculate(cash, cashlees, denominations, commission, service.getMinComm(), service.getMaxComm(), ignoreMinMaxComm, trade, maxPaymentSum, providerFee);
    }

    private static SumResult calculate(Sum cash, Sum cashlees, Map<CashUnit, Integer> denominations, Commission commission, Commission minCommission, Commission maxCommission, boolean ignoreMinMaxComm, Sum trade, Sum maxPaymentSum, FeeSum providerFee) {
        SumResult serviceResult;
        if (providerFee != null) {
            return BaseCommissionCalculator.calculate(cash, cashlees, trade, maxPaymentSum, providerFee);
        }
        SumResult dealerResult = BaseCommissionCalculator.calculate(cash, cashlees, denominations, commission, trade, maxPaymentSum);
        Session.setCommission(commission);
        if (!(ignoreMinMaxComm || dealerResult.getOut().isEmpty() || minCommission == null || !(serviceResult = BaseCommissionCalculator.calculate(cash, cashlees, denominations, minCommission, trade, maxPaymentSum)).getOut().isEmpty() && serviceResult.getCommission().compareTo(dealerResult.getCommission()) <= 0)) {
            dealerResult = serviceResult;
            Session.setCommission(minCommission);
        }
        if (!ignoreMinMaxComm && maxCommission != null && (serviceResult = BaseCommissionCalculator.calculate(cash, cashlees, denominations, maxCommission, trade, maxPaymentSum)).getCommission().compareTo(dealerResult.getCommission()) < 0) {
            Session.setCommission(maxCommission);
            return serviceResult;
        }
        return dealerResult;
    }

    public static SumResult calculate(Sum cash, Sum cashless, Map<CashUnit, Integer> denominations, Commission commission, Sum trade, Sum maxPaymentSum) {
        Sum rest;
        Sum baseSum;
        Sum sum0;
        if (cash == null) {
            throw new IllegalArgumentException("Cash sum in must be equals or great zero");
        }
        if (cashless == null) {
            throw new IllegalArgumentException("Cashless sum in must be equals or great zero");
        }
        if (commission == null) {
            throw new IllegalArgumentException("Comission is null");
        }
        Sum in = cash.add(cashless);
        String curr = cash.getCurrency();
        Sum nomSum = sum0 = new Sum(0, curr);
        Sum nomComm = sum0;
        if (denominations != null && !denominations.isEmpty() && commission.getUnits() != null && !commission.getUnits().isEmpty()) {
            for (CommissionUnit cu : commission.getUnits()) {
                for (CashUnit cashUnit : denominations.keySet()) {
                    if (cu.getCashUnit() != cashUnit.getId() || cu.getFixedValue() == null) continue;
                    int count = denominations.get(cashUnit);
                    nomSum = nomSum.add(cashUnit.getNominal().mul((double)count));
                    nomComm = nomComm.add(cu.getFixedValue().mul((double)count));
                }
            }
        }
        if (trade != null && !trade.isEmpty()) {
            baseSum = trade;
        } else if (maxPaymentSum != null && !maxPaymentSum.isEmpty() && maxPaymentSum.compareTo(in) < 0) {
            baseSum = maxPaymentSum;
        } else {
            baseSum = in;
            if (Boolean.TRUE.equals(commission.getSeparateUnitTypesCalc())) {
                baseSum = baseSum.sub(nomSum);
            }
        }
        double percentValue = commission.getPercentValue();
        Sum fixedValue = commission.getFixedValue();
        CommissionStep cs = null;
        if (commission.getSteps() != null && commission.getSteps().size() > 0) {
            for (CommissionStep step : commission.getSteps().descendingSet()) {
                if (step.getSum().compareTo(baseSum) > 0) continue;
                cs = step;
                percentValue = step.getPercentValue();
                fixedValue = step.getFixedValue();
                break;
            }
        }
        Sum sumCommission = commission.getType() == CommissionType.Inverce ? baseSum.mul(percentValue / (100.0 + percentValue)) : baseSum.mul(percentValue / 100.0);
        if (fixedValue != null) {
            sumCommission = sumCommission.add(fixedValue);
        }
        if (!(denominations == null || denominations.isEmpty() || commission.getUnits() == null || commission.getUnits().isEmpty() || nomComm.isEmpty())) {
            sumCommission = sumCommission.add(nomComm);
        }
        if (cs != null && cs.getMin() != null && !cs.getMin().isEmpty() && sumCommission.compareTo(cs.getMin()) < 0) {
            sumCommission = cs.getMin();
        } else if (commission.getMin() != null && !commission.getMin().isEmpty() && sumCommission.compareTo(commission.getMin()) < 0) {
            sumCommission = commission.getMin();
        }
        if (cs != null && cs.getMax() != null && !cs.getMax().isEmpty() && sumCommission.compareTo(cs.getMax()) > 0) {
            sumCommission = cs.getMax();
        } else if (commission.getMax() != null && !commission.getMax().isEmpty() && sumCommission.compareTo(commission.getMax()) > 0) {
            sumCommission = commission.getMax();
        }
        if (commission.getRoundOrder() != null && !commission.getRoundOrder().isEmpty() && !(rest = sumCommission.divRest(commission.getRoundOrder())).isEmpty()) {
            sumCommission = sumCommission.add(commission.getRoundOrder().sub(rest));
        }
        if (sumCommission.compareTo(in) >= 0) {
            return new SumResult(cash, cashless, sum0, sum0, sumCommission, in, null);
        }
        Sum sumOut = in.sub(sumCommission);
        if (trade != null && !trade.isEmpty()) {
            if (sumOut.compareTo(trade) < 0) {
                return new SumResult(cash, cashless, sum0, sum0, sumCommission, in, null);
            }
            return new SumResult(cash, cashless, trade, trade, sumCommission, sumOut.sub(trade), null);
        }
        if (maxPaymentSum != null && !maxPaymentSum.isEmpty() && sumOut.compareTo(maxPaymentSum) > 0) {
            sumOut = maxPaymentSum;
            Sum change = in.sub(sumOut).sub(sumCommission);
            if (change.compareTo(sum0) >= 0) {
                return new SumResult(cash, cashless, sumOut, sumOut, sumCommission, change, null);
            }
            return new SumResult(cash, cashless, sum0, sum0, sum0, in, null);
        }
        return new SumResult(cash, cashless, sumOut, sumOut, sumCommission, sum0, null);
    }

    public static Sum calculate(Sum trade, Commission commission) {
        if (trade == null) {
            throw new NullPointerException("Trade is null");
        }
        String curr = trade.getCurrency();
        Sum sum0 = new Sum(0, curr);
        if (commission.getSteps() != null && commission.getSteps().size() > 0) {
            for (CommissionStep step : commission.getSteps().descendingSet()) {
                if (step.getSum().compareTo(trade) != 0 || step.getPercentValue() != 0.0) continue;
                return trade.add(step.getFixedValue());
            }
        }
        Sum step = trade.div(2.0);
        Sum in = trade;
        while (true) {
            Sum res;
            if ((res = BaseCommissionCalculator.calculate(in, sum0, null, commission, trade, null).getOut()).compareTo(trade) >= 0) {
                if (step.getValue() == 1) break;
                in = in.sub(step);
                step = step.div(2.0);
                continue;
            }
            in = in.add(step);
        }
        return in;
    }

    public static Sum calculate(Sum trade, Commission commission, Service service, boolean ignoreMinMaxComm, FeeSum providerFee) {
        return BaseCommissionCalculator.calculate(trade, commission, service.getMinComm(), service.getMaxComm(), ignoreMinMaxComm, providerFee);
    }

    public static Sum calculate(Sum trade, Commission commission, Commission minComm, Commission maxComm, boolean ignoreMinMaxComm, FeeSum providerFee) {
        Sum maxRes;
        Sum minRes;
        if (providerFee != null) {
            return BaseCommissionCalculator.calculate(trade, providerFee);
        }
        Sum dealerResult = BaseCommissionCalculator.calculate(trade, commission);
        Session.setCommission(commission);
        if (!ignoreMinMaxComm && minComm != null && (minRes = BaseCommissionCalculator.calculate(trade, minComm)).compareTo(dealerResult) > 0) {
            dealerResult = minRes;
            Session.setCommission(minComm);
        }
        if (!ignoreMinMaxComm && maxComm != null && (maxRes = BaseCommissionCalculator.calculate(trade, maxComm)).compareTo(dealerResult) < 0) {
            dealerResult = maxRes;
            Session.setCommission(maxComm);
        }
        return dealerResult;
    }

    public static Sum calculateMaxPurchase(Sum limitSum, Commission commission) {
        if (commission != null && commission.getSteps() == null) {
            Sum comm;
            Sum result = limitSum;
            double percentValue = commission.getPercentValue();
            result = commission.getType() == CommissionType.Inverce ? limitSum.mul((100.0 + percentValue) / (100.0 + 2.0 * percentValue)) : limitSum.mul(1.0 - percentValue / (100.0 + percentValue));
            if (commission.getFixedValue() != null) {
                result = result.sub(commission.getFixedValue());
            }
            if ((comm = limitSum.sub(result)).compareTo(commission.getMin()) < 0) {
                result = limitSum.sub(commission.getMin());
            }
            if (!commission.getMax().isEmpty() && comm.compareTo(commission.getMax()) > 0) {
                result = limitSum.sub(commission.getMax());
            }
            return result;
        }
        Sum sum0 = new Sum(0, limitSum.getCurrency());
        Sum step = limitSum.div(2.0);
        Sum in = limitSum;
        int dif = 0;
        while (true) {
            Sum tmp = in;
            in = in.sub(step);
            SumResult res = BaseCommissionCalculator.calculate(in, sum0, null, commission, in, null);
            if (dif < step.getValue()) {
                step = step.div(2.0);
                in = tmp.add(step);
            }
            if (dif <= 0 && step.getValue() == 1) break;
            dif = res.getCommission().add(in).getValue() - limitSum.getValue();
        }
        in = in.sub(step);
        return in;
    }

    public static Sum calculate(List<Sum> trade, Commission commission, Service service, boolean ignoreMinMaxComm, FeeSum providerFee) {
        Sum sr = FinUtils.createVoidSum();
        for (Sum st : trade) {
            Sum s = BaseCommissionCalculator.calculate(st, commission, service, ignoreMinMaxComm, providerFee);
            sr = sr.add(s);
        }
        return sr;
    }

    public static SumResult calculateGroupResult(List<SumResult> sums, Sum cash, Sum cashlees) {
        Sum sCash = cash;
        Sum sCashLess = cashlees;
        Sum sChange = FinUtils.createVoidSum();
        Sum sCommission = FinUtils.createVoidSum();
        Sum sOut = FinUtils.createVoidSum();
        Sum sOutProv = FinUtils.createVoidSum();
        for (SumResult s : sums) {
            sChange = sChange.add(s.getChange());
            sCommission = sCommission.add(s.getCommission());
            sOut = sOut.add(s.getOut());
            sOutProv = sOutProv.add(s.getOutProv());
        }
        return new SumResult(sCash, sCashLess, sOut, sOutProv, sCommission, sChange, null);
    }

    public static List<SumResult> calculateGroupResults(Sum in, Commission commission, Map<CashUnit, Integer> denominations, Service service, boolean ignoreMinMaxComm, List<Sum> trades, Sum opr, Sum maxPaymentSum) {
        Sum input = new Sum(in);
        Sum s0 = FinUtils.createVoidSum();
        LinkedList<SumResult> results = new LinkedList<SumResult>();
        boolean breaking = false;
        boolean first = true;
        if (trades != null && !trades.isEmpty()) {
            for (Sum trade : trades) {
                if (opr != null && !opr.isEmpty() && opr.compareTo(in) > 0 || breaking) {
                    results.add(new SumResult(s0, s0, s0, s0, s0, s0, null));
                    continue;
                }
                if (first) {
                    first = false;
                } else {
                    denominations = null;
                }
                SumResult result = BaseCommissionCalculator.calculate(input, s0, denominations, commission, service, ignoreMinMaxComm, trade, maxPaymentSum, null);
                if (result.getOut().isEmpty()) {
                    results.add(new SumResult(s0, s0, s0, s0, s0, s0, null));
                    breaking = true;
                    continue;
                }
                input = new Sum(result.getChange());
                result = new SumResult(result.getCash(), result.getCashLess(), result.getOut(), result.getOutProv(), result.getCommission(), s0, null);
                results.add(result);
            }
            if (!input.isEmpty()) {
                SumResult sr = (SumResult)results.get(0);
                sr = new SumResult(sr.getCash(), sr.getCashLess(), sr.getOut(), sr.getOutProv(), sr.getCommission(), new Sum(input), null);
                results.set(0, sr);
            }
        }
        return results;
    }

    public static SumResult calculateGroupDonate(SumResult result, Sum donate, Service donateSrv, Sum req) {
        if (donateSrv != null && donate != null && !donate.isEmpty() && !result.getChange().isEmpty() && req != null && result.getCash().add(result.getCashLess()).compareTo(req) >= 0) {
            if (!result.getCash().getCurrency().equals(donateSrv.getInCurrency())) {
                return result;
            }
            Sum min = donateSrv.getMinSum();
            if (min != null && !min.isEmpty()) {
                min = new Sum(1, donateSrv.getInCurrency());
            }
            if (result.getChange().compareTo(donate) >= 0) {
                return new SumResult(result, donate);
            }
            if (result.getChange().compareTo(min) >= 0) {
                return new SumResult(result, result.getChange());
            }
        }
        return result;
    }

    public static List<SumResult> calculateDivideResults(Sum in, Map<CashUnit, Integer> denominations, Commission comm, Commission minComm, Commission maxComm, boolean ignoreMinMaxComm, Sum divide) {
        Sum input;
        Sum s0 = FinUtils.createVoidSum();
        LinkedList<SumResult> results = new LinkedList<SumResult>();
        boolean first = true;
        int i = 0;
        while (true) {
            if (first) {
                first = false;
            } else {
                denominations = null;
            }
            if (divide != null && divide.compareTo(in) < 0) {
                input = divide;
                in = in.sub(divide);
            } else {
                input = in;
                in = FinUtils.createVoidSum();
            }
            SumResult result = BaseCommissionCalculator.calculate(input, s0, denominations, comm, minComm, maxComm, ignoreMinMaxComm, null, divide, null);
            if (result.getOut().isEmpty() && i != 0) break;
            results.add(new SumResult(result.getCash(), result.getCashLess(), result.getOut(), result.getOutProv(), result.getCommission(), s0, null));
            ++i;
        }
        if (!input.isEmpty()) {
            SumResult sr = (SumResult)results.get(0);
            sr = new SumResult(sr.getCash(), sr.getCashLess(), sr.getOut(), sr.getOutProv(), sr.getCommission(), new Sum(input), null);
            results.set(0, sr);
        }
        return results;
    }

    public static List<SumResult> calculateDivideResults(Sum in, Map<CashUnit, Integer> denominations, Commission comm, Commission minComm, Commission maxComm, Sum maxSum, boolean ignoreMinMaxComm, List<Sum> oprs, Sum trade, Sum divide) {
        Sum input = new Sum(in);
        Sum s0 = FinUtils.createVoidSum();
        LinkedList<SumResult> results = new LinkedList<SumResult>();
        SumResult first = BaseCommissionCalculator.calculate(input, s0, denominations, comm, minComm, maxComm, ignoreMinMaxComm, trade, maxSum, null);
        if (first.getOut().isEmpty()) {
            results.add(first);
        } else {
            boolean firstB = true;
            for (int i = 0; i < oprs.size(); ++i) {
                if (firstB) {
                    firstB = false;
                } else {
                    denominations = null;
                }
                SumResult result = BaseCommissionCalculator.calculate(input, s0, denominations, comm, minComm, maxComm, ignoreMinMaxComm, oprs.get(i), divide, null);
                if (result.getOut().isEmpty() && i != 0) break;
                input = new Sum(result.getChange());
                results.add(new SumResult(result.getCash(), result.getCashLess(), result.getOut(), result.getOutProv(), result.getCommission(), s0, null));
            }
            if (!input.isEmpty()) {
                SumResult sr = (SumResult)results.get(0);
                sr = new SumResult(sr.getCash(), sr.getCashLess(), sr.getOut(), sr.getOutProv(), sr.getCommission(), new Sum(input), null);
                results.set(0, sr);
            }
        }
        return results;
    }

    public static List<SumResult> calculateRandomDivideResults(Sum in, Map<CashUnit, Integer> denominations, Commission comm, Commission minComm, Commission maxComm, Service s, boolean ignoreMinMaxComm) {
        Sum divide;
        Sum s0 = FinUtils.createVoidSum();
        LinkedList<SumResult> results = new LinkedList<SumResult>();
        int i = 0;
        boolean first = true;
        while (true) {
            if (first) {
                first = false;
            } else {
                denominations = null;
            }
            if (in.compareTo(s.getDivideSumTo()) > 0) {
                divide = PackUtility.getRandom(s.getDivideSumFrom().getValue(), s.getDivideSumTo().getValue(), s.getDivideSumRound(), in.getCurrency());
                in = in.sub(divide);
            } else {
                divide = new Sum(in);
                in = FinUtils.createVoidSum();
            }
            SumResult result = BaseCommissionCalculator.calculate(divide, s0, denominations, comm, minComm, maxComm, ignoreMinMaxComm, null, divide, null);
            if (result.getOut().isEmpty() && i != 0) break;
            results.add(new SumResult(result.getCash(), result.getCashLess(), result.getOut(), result.getOutProv(), result.getCommission(), s0, null));
            ++i;
        }
        if (!divide.isEmpty()) {
            SumResult sr = (SumResult)results.get(0);
            sr = new SumResult(sr.getCash(), sr.getCashLess(), sr.getOut(), sr.getOutProv(), sr.getCommission(), new Sum(divide), null);
            results.set(0, sr);
        }
        return results;
    }

    public static Sum calculateSumIn(Sum sumOut, Commission commission) {
        int fixCom;
        int comm;
        int commFixValue;
        TreeSet steps = commission.getSteps();
        if (steps != null && steps.size() > 0) {
            Sum step = sumOut.div(2.0);
            Sum sum0 = new Sum(0, sumOut.getCurrency());
            Sum in = sumOut;
            while (true) {
                Sum res;
                if ((res = BaseCommissionCalculator.calculate(in, sum0, null, commission, in, null).getOut()).compareTo(sumOut) >= 0) {
                    if (step.getValue() == 1) break;
                    in = in.sub(step);
                    step = step.div(2.0);
                    continue;
                }
                in = in.add(step);
            }
            return in;
        }
        int sumOutValue = sumOut.getValue();
        float maxPercent = (float)commission.getPercentValue();
        Sum fixedValue = commission.getFixedValue();
        int n = commFixValue = fixedValue == null ? 0 : fixedValue.getValue();
        if (commission.getType() == CommissionType.Inverce) {
            comm = Math.round((float)sumOutValue * maxPercent / 100.0f);
            fixCom = Math.round((float)commFixValue * maxPercent / 100.0f);
        } else {
            comm = Math.round((float)sumOut.getValue() * maxPercent / (100.0f - maxPercent));
            fixCom = Math.round((float)commFixValue * maxPercent / (100.0f - maxPercent));
        }
        comm += commFixValue + fixCom;
        int minValue = commission.getMin() == null ? 0 : commission.getMin().getValue();
        comm = Math.max(comm, minValue);
        Sum max = commission.getMax();
        if (max != null && max.getValue() != 0) {
            comm = Math.min(comm, max.getValue());
        }
        return new Sum(sumOutValue + comm, sumOut.getCurrency());
    }

    public static SumResult calculate(Sum cash, Sum cashless, Sum trade, Sum maxPaymentSum, FeeSum providerFee) {
        if (cash == null) {
            throw new IllegalArgumentException("Cash sum in must be equals or great zero");
        }
        if (cashless == null) {
            throw new IllegalArgumentException("Cashless sum in must be equals or great zero");
        }
        if (providerFee == null) {
            throw new IllegalArgumentException("Provider fee is null");
        }
        Sum in = cash.add(cashless);
        String curr = cash.getCurrency();
        Sum sum0 = new Sum(0, curr);
        Sum sumCommission = new Sum(providerFee.getFee(), curr);
        if (sumCommission.compareTo(in) >= 0) {
            return new SumResult(cash, cashless, sum0, sum0, sumCommission, in, providerFee);
        }
        Sum sumOut = in.sub(sumCommission);
        if (trade != null && !trade.isEmpty()) {
            if (sumOut.compareTo(trade) < 0) {
                return new SumResult(cash, cashless, sum0, sum0, sumCommission, in, providerFee);
            }
            return new SumResult(cash, cashless, trade, trade, sumCommission, sumOut.sub(trade), providerFee);
        }
        if (maxPaymentSum != null && !maxPaymentSum.isEmpty() && sumOut.compareTo(maxPaymentSum) > 0) {
            sumOut = maxPaymentSum;
            Sum change = in.sub(sumOut).sub(sumCommission);
            if (change.compareTo(sum0) >= 0) {
                return new SumResult(cash, cashless, sumOut, sumOut, sumCommission, change, providerFee);
            }
            return new SumResult(cash, cashless, sum0, sum0, sum0, in, providerFee);
        }
        return new SumResult(cash, cashless, sumOut, sumOut, sumCommission, sum0, providerFee);
    }

    private static Sum calculate(Sum trade, FeeSum providerFee) {
        if (providerFee == null) {
            throw new IllegalArgumentException("\u0421\u0442\u0430\u0432\u043a\u0430 \u043a\u043e\u043c\u0438\u0441\u0441\u0438\u0438 \u043f\u0440\u043e\u0432\u0430\u0439\u0434\u0435\u0440\u0430 \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c null");
        }
        return new Sum(trade.getValue() + providerFee.getFee(), trade.getCurrency());
    }
}

