/*
 * Decompiled with CFR 0.152.
 */
package fxterm.app.plt2;

import fxterm.app.SystemProp;
import fxterm.app.id.LoggerId;
import fxterm.app.plt2.EntryPoint;
import fxterm.core.activity.UserAction;
import fxterm.module.ExitIntent;
import fxterm.module.Module;
import fxterm.module.ModuleStore;
import fxterm.msg.Messages;
import fxterm.session.Session;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import plfx.element.CompositeSProgressIndicator;
import plfx.element.DateSLabel;
import plfx.element.SLabel;
import plfx.element.SProgressIndicator;
import plfx.screen.FxScreenTemplate;
import plfx.shell.BannerProcessor;
import plfx.shell.TemplateListener;
import plfx.util.TerminalPlatform;

public class ReturnService
implements Runnable,
TemplateListener {
    private final EntryPoint entryPoint;
    private final UserAction userAction;
    private final Logger log = LoggerId.GUI;
    private final Map<FxScreenTemplate, BannerProcessor> templates = new HashMap<FxScreenTemplate, BannerProcessor>();

    public ReturnService(EntryPoint entryPoint, UserAction userAction) {
        this.entryPoint = entryPoint;
        this.userAction = userAction;
    }

    @Override
    public void run() {
        Module module = ModuleStore.getModule();
        if (module != null) {
            int timeout = module.getInactivityTimeout();
            int timer = this.userAction.getRest(timeout);
            TerminalPlatform.runLater((Runnable)new LocalTimerUpdateRuner(timeout, timer));
            if (timeout > 0 && this.userAction.isElapsed(timeout)) {
                TerminalPlatform.runLater((Runnable)new LocalReturnRunner(module, timeout));
            }
        }
    }

    public synchronized void onAdd(FxScreenTemplate template, BannerProcessor bannerProcessor) {
        this.templates.put(template, bannerProcessor);
        Module module = ModuleStore.getModule();
        if (module != null) {
            int timeout = module.getInactivityTimeout();
            int timer = this.userAction.getRest(timeout);
            TerminalPlatform.runLater((Runnable)new LocalTimerUpdateRuner(timeout, timer));
        }
    }

    public synchronized void onRemove(FxScreenTemplate template) {
        this.templates.remove(template);
    }

    public UserAction getUserAction() {
        return this.userAction;
    }

    private class LocalTimerUpdateRuner
    implements Runnable {
        private final int timeout;
        private final int time;

        public LocalTimerUpdateRuner(int timeout, int time) {
            this.timeout = timeout;
            this.time = time;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            ReturnService returnService = ReturnService.this;
            synchronized (returnService) {
                for (Map.Entry e : ReturnService.this.templates.entrySet()) {
                    for (SLabel timer : ((FxScreenTemplate)e.getKey()).getTimers()) {
                        timer.setText(String.format("%02d:%02d", this.time / 60, this.time % 60));
                    }
                    for (DateSLabel date : ((FxScreenTemplate)e.getKey()).getDates()) {
                        date.setText(new SimpleDateFormat(date.getFormat()).format(Calendar.getInstance(Session.getLocale()).getTime()));
                    }
                    if (SystemProp.getDateTimeFormat() != null && !((FxScreenTemplate)e.getKey()).getDates().isEmpty()) {
                        String format = SystemProp.getDateTimeFormat().replaceAll("_", " ");
                        ((DateSLabel)((FxScreenTemplate)e.getKey()).getDates().get(0)).setText(new SimpleDateFormat(format).format(Calendar.getInstance(Session.getLocale()).getTime()));
                    }
                    ((BannerProcessor)e.getValue()).update((FxScreenTemplate)e.getKey());
                    this.setProgress(((FxScreenTemplate)e.getKey()).getProgressIndicator(), (double)(this.timeout - this.time) * 1.0 / (double)this.timeout);
                }
            }
        }

        private void setProgress(SProgressIndicator indicator, double progress) {
            if (indicator instanceof CompositeSProgressIndicator) {
                CompositeSProgressIndicator cspi = (CompositeSProgressIndicator)indicator;
                boolean setProgress = false;
                if (cspi.getIndicator() != null) {
                    setProgress = "true".equals(cspi.getIndicator().getProperties().get((Object)"setProgress"));
                }
                if (cspi.getBar() != null) {
                    setProgress = "true".equals(cspi.getBar().getProperties().get((Object)"setProgress"));
                }
                if (setProgress) {
                    cspi.setProgress(progress);
                }
            }
        }
    }

    private class LocalReturnRunner
    implements Runnable {
        private final Module module;
        private final int timeout;

        public LocalReturnRunner(Module module, int timeout) {
            this.module = module;
            this.timeout = timeout;
        }

        @Override
        public void run() {
            if (ReturnService.this.userAction.isElapsed(this.timeout)) {
                ReturnService.this.log.debug((Object)("Inactivity timeout was detected, module: " + Messages.getModuleType(this.module.getType()) + ", timeout: " + this.timeout));
                ReturnService.this.userAction.update();
                this.module.cancel(new ExitIntent(ReturnService.this.entryPoint, 0));
            }
        }
    }
}

