/*
 * Decompiled with CFR 0.152.
 */
package fxterm.app.plt2;

import fxterm.app.id.LoggerId;
import fxterm.core.task.Task;
import org.apache.log4j.Logger;
import plfx.element.FxInitException;
import plfx.screen.ScreenCreateException;
import plfx.screen.ScreenStore;
import plfx.screen.TemplateCreateException;
import plfx.skin.SkinProperties;
import plfx.util.LoadTemplateException;
import plfx.util.TerminalPlatform;
import ru.softlogic.parser.ParserFactory;
import ru.softlogic.parser.XMLPreloader;

public class PreloadTask
extends Task {
    private final SkinProperties sp;
    private final Runnable finishListener;
    private final Logger log = LoggerId.START;
    private final Object sync = new Object();
    private boolean done;

    public PreloadTask(SkinProperties sp, Runnable finishListener) {
        this.sp = sp;
        this.finishListener = finishListener;
    }

    @Override
    protected String getWaitId() {
        return "screens.preload";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object execute() throws Exception {
        try {
            Object object;
            Thread.sleep(250L);
            this.log.info((Object)"    Preload menu layers:");
            for (String l : this.sp.getPreloadingMenuLayers()) {
                this.log.info((Object)("    Layer: " + l));
                Thread.sleep(50L);
                this.done = false;
                TerminalPlatform.runLater((Runnable)new LocalMenuCreator(l));
                object = this.sync;
                synchronized (object) {
                    while (!this.done) {
                        this.sync.wait();
                    }
                }
            }
            this.log.info((Object)"    Preload common layers:");
            for (String l : this.sp.getPreloadingCommonLayers()) {
                this.log.info((Object)("    Layer: " + l));
                Thread.sleep(50L);
                this.done = false;
                TerminalPlatform.runLater((Runnable)new LocalCommonCreator(l));
                object = this.sync;
                synchronized (object) {
                    while (!this.done) {
                        this.sync.wait();
                    }
                }
            }
            this.log.info((Object)"    Preload dialog layers:");
            for (String l : this.sp.getPreloadingDialogLayers()) {
                this.log.info((Object)("    Layer: " + l));
                Thread.sleep(50L);
                this.done = false;
                TerminalPlatform.runLater((Runnable)new LocalDialogCreator(l));
                object = this.sync;
                synchronized (object) {
                    while (!this.done) {
                        this.sync.wait();
                    }
                }
            }
            if (this.sp.isPreloadSearch()) {
                this.log.info((Object)"    Preload search dialog.");
                Thread.sleep(50L);
                this.done = false;
                TerminalPlatform.runLater((Runnable)new SearchScreenCreator());
                Object object2 = this.sync;
                synchronized (object2) {
                    while (!this.done) {
                        this.sync.wait();
                    }
                }
            }
            this.log.info((Object)"    Preload XML engine:");
            XMLPreloader xp = ParserFactory.createPreloader();
            xp.preload();
            this.log.info((Object)"    Done!");
            return null;
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
            throw new Exception(ex);
        }
    }

    protected void onResult(Object object) {
        this.finishListener.run();
    }

    @Override
    protected void onError(Exception ex) {
        this.finishListener.run();
    }

    public String toString() {
        return "PreloadTask{}";
    }

    private class LocalCommonCreator
    implements Runnable {
        private final String l;

        public LocalCommonCreator(String l) {
            this.l = l;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                ScreenStore.getCommonScreen((String)this.l);
            }
            catch (ScreenCreateException ex) {
                PreloadTask.this.log.info((Object)("        " + this.l + " - Error: " + ex.getMessage()));
            }
            catch (Throwable ex) {
                PreloadTask.this.log.error((Object)"Unknown exception", ex);
            }
            finally {
                Object ex = PreloadTask.this.sync;
                synchronized (ex) {
                    PreloadTask.this.done = true;
                    PreloadTask.this.sync.notifyAll();
                }
            }
        }
    }

    private class SearchScreenCreator
    implements Runnable {
        private SearchScreenCreator() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                ScreenStore.getSearchScreen();
            }
            catch (ScreenCreateException ex) {
                PreloadTask.this.log.info((Object)("        search - Error: " + ex.getMessage()));
            }
            catch (Throwable ex) {
                PreloadTask.this.log.error((Object)"Unknown exception", ex);
            }
            finally {
                Object ex = PreloadTask.this.sync;
                synchronized (ex) {
                    PreloadTask.this.done = true;
                    PreloadTask.this.sync.notifyAll();
                }
            }
        }
    }

    private class LocalMenuCreator
    implements Runnable {
        private final String l;

        public LocalMenuCreator(String l) {
            this.l = l;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                ScreenStore.getMenuTemplate((String)this.l);
            }
            catch (TemplateCreateException ex) {
                PreloadTask.this.log.info((Object)("        " + this.l + " - Error: " + ex.getMessage()));
            }
            catch (Throwable ex) {
                PreloadTask.this.log.error((Object)"Unknown exception", ex);
            }
            finally {
                Object ex = PreloadTask.this.sync;
                synchronized (ex) {
                    PreloadTask.this.done = true;
                    PreloadTask.this.sync.notifyAll();
                }
            }
        }
    }

    private class LocalDialogCreator
    implements Runnable {
        private final String l;

        public LocalDialogCreator(String l) {
            this.l = l;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                ScreenStore.getDialogTemplate((String)this.l);
            }
            catch (FxInitException | LoadTemplateException ex) {
                PreloadTask.this.log.info((Object)("        " + this.l + " - Error: " + ex.getMessage()));
            }
            catch (Throwable ex) {
                PreloadTask.this.log.error((Object)"Unknown exception", ex);
            }
            finally {
                Object ex = PreloadTask.this.sync;
                synchronized (ex) {
                    PreloadTask.this.done = true;
                    PreloadTask.this.sync.notifyAll();
                }
            }
        }
    }
}

