/*
 * Decompiled with CFR 0.152.
 */
package fxterm.app.plt2;

import fxterm.app.FxEnv;
import fxterm.app.FxEnvInit;
import fxterm.app.ResolutionReader;
import fxterm.app.SystemProp;
import fxterm.app.context.Context;
import fxterm.app.context.ContextException;
import fxterm.app.context.StartupData;
import fxterm.app.id.LoggerId;
import fxterm.app.plt2.DialogErrorHandler;
import fxterm.app.plt2.EntryPoint;
import fxterm.app.plt2.PreloadTask;
import fxterm.app.plt2.ReturnService;
import fxterm.core.BaseTimer;
import fxterm.core.activity.ActivityMonitor;
import fxterm.core.activity.TaskStateMonitor;
import fxterm.core.activity.UserAction;
import fxterm.core.adv.AdvBannerProcessor;
import fxterm.core.adv.AdvBannerRotator;
import fxterm.core.cash.CompatCashFactory;
import fxterm.core.hdw.bvr.oper.NewKeeper2;
import fxterm.core.launcher.Launcher;
import fxterm.core.menu.VisitMenuCounter;
import fxterm.core.save.Result;
import fxterm.core.save.SaveObjectException;
import fxterm.core.save.SavingHandler;
import fxterm.core.save.SavingObjectType;
import fxterm.core.save.SavingTask;
import fxterm.core.save.SecureSaveUtils;
import fxterm.core.state.StateFacade;
import fxterm.core.state.StateListener;
import fxterm.core.state.StateMsg;
import fxterm.core.state.TerminalState;
import fxterm.core.task.FxTaskExecutor;
import fxterm.core.task.Task;
import fxterm.module.ModuleStore;
import fxterm.module.Pack;
import fxterm.module.PackUtility;
import fxterm.module.PayEnv;
import fxterm.module.entry.lock.DefaultLockModule;
import fxterm.module.entry.menu.MenuEngine;
import fxterm.module.entry.menu.MenuListener;
import fxterm.module.input.BaseModule;
import fxterm.session.Session;
import fxterm.session.SessionListener;
import java.net.URL;
import java.security.KeyStore;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import javafx.event.EventHandler;
import javafx.scene.Cursor;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.input.MouseEvent;
import javafx.stage.Stage;
import javafx.stage.StageStyle;
import javafx.util.Pair;
import org.apache.log4j.Logger;
import plfx.GuiNotifier;
import plfx.msg.screen.ScreenProcessor;
import plfx.screen.FxScreenTemplate;
import plfx.screen.ScreenFactory;
import plfx.screen.ShellCreateException;
import plfx.shell.BannerProcessor;
import plfx.shell.BaseShellLayer;
import plfx.shell.DefaultScreenModule;
import plfx.shell.LayerType;
import plfx.shell.ScreenModule;
import plfx.shell.Shell;
import plfx.shell.TemplateListener;
import plfx.shell.custom.CustomModule;
import plfx.shell.custom.DefaultCustomModule;
import plfx.shell.popup.DefaultPopupModule;
import plfx.shell.popup.PopupModule;
import plfx.shell2.dialog.BaseDialogCore;
import plfx.shell2.dialog.BaseDialogModule;
import plfx.shell2.dialog.Dialog;
import plfx.shell2.dialog.DialogCore;
import plfx.shell2.dialog.DialogErrorListener;
import plfx.shell2.dialog.DialogModule;
import plfx.shell2.timer.Timer;
import plfx.shell2.wait.BaseWaitModule;
import plfx.shell2.wait.WaitModule;
import plfx.skin.Resolution;
import plfx.skin.Skin;
import plfx.skin.SkinException;
import plfx.skin.SkinProperties;
import plfx.util.Locator;
import plfx.util.TerminalPlatform;
import ru.softlogic.cash.Sum;
import ru.softlogic.hdw.dev.barcode.BarcodeListener;
import ru.softlogic.hdw.dev.cashacc.EventListener;
import ru.softlogic.hdw.dev.crd.CardReader;
import ru.softlogic.hdw.dev.crd.CardReaderException;
import ru.softlogic.operation.Operation;
import ru.softlogic.reference.References;
import ru.softlogic.reference.menu.Menu;
import ru.softlogic.reference.menu.MenuItem;
import ru.softlogic.reference.point.PointOptions;
import ru.softlogic.reference.service.ProcessingType;
import ru.softlogic.system.util.PathUtils;
import ru.softlogic.system.util.TimeUtil;

public class DefaultTerminalContext
implements Context {
    private MenuEngine menuEngine;
    private DefaultLockModule lockModule;
    private final Logger log = LoggerId.START;
    private final Logger log2 = LoggerId.PAY;

    @Override
    public void run(StartupData sd) throws ContextException {
        try {
            SkinProperties sp;
            Stage stage = FxEnv.getPrimaryStage();
            this.log.info((Object)"-------------------------------------------------------------------------------");
            this.log.info((Object)"Create activity monitor");
            UserAction userAction = new UserAction();
            UserAction paymentAction = new UserAction();
            Session.setPaymentAction(paymentAction);
            ActivityMonitor activityMonitor = new ActivityMonitor(userAction);
            FxEnv.getBillValidator().addEventListener((EventListener)activityMonitor);
            stage.addEventFilter(MouseEvent.MOUSE_PRESSED, (EventHandler)activityMonitor);
            if (FxEnv.getCoinValidator() != null) {
                FxEnv.getCoinValidator().addEventListener((EventListener)activityMonitor);
            }
            if (FxEnv.getBarcodeScanner() != null) {
                FxEnv.getBarcodeScanner().addBarcodeListener((BarcodeListener)activityMonitor);
            }
            if (FxEnv.getCardModuleHandler() != null) {
                FxEnv.getCardModuleHandler().addActivityMonitor(activityMonitor);
            }
            if (FxEnv.getCardModuleHandler() != null) {
                sd.getScheduler().scheduleAtFixedRate(() -> FxEnv.getCardModuleHandler().closeDay(), TimeUtil.until((int)22) / 1000L + 1L, 86400L, TimeUnit.SECONDS);
            }
            this.log.info((Object)"Check activity every 2 seconds");
            ReturnService returnService = new ReturnService(new LocalEntryPoint(), userAction);
            sd.getScheduler().scheduleAtFixedRate(returnService, 5L, 1L, TimeUnit.SECONDS);
            Session.setReturnService(returnService);
            String defName = Skin.getSkinSet().getPrimary();
            String name = Optional.ofNullable(References.getMenu()).map(Menu::getIface).filter(Predicate.isEqual("").negate()).orElse(defName);
            this.log.info((Object)("   Skin name: " + name));
            try {
                sp = Skin.readProperties((String)name);
            }
            catch (Exception e) {
                this.log.error((Object)("Could not load skin properties for name: " + name + ". Try load default skin: " + defName));
                name = defName;
                sp = Skin.readProperties((String)name);
            }
            Skin.setWorkSkin((String)name);
            Resolution rs = ResolutionReader.process(stage, sd.getGuiConfiguration().getSize());
            String baseCss = sp.getBaseStyleSheet(rs);
            Skin.setWorkScreenSizeName((String)rs.toString());
            if (baseCss == null) {
                GuiNotifier.notifyProblem((String)("Base css is not found for resolution: " + rs));
                baseCss = sp.getDefaultStyleSheet();
                Skin.setWorkScreenSizeName((String)"default");
                if (baseCss == null) {
                    GuiNotifier.notifyProblem((String)"Default base css is not found");
                }
            }
            this.log.info((Object)"-------------------------------------------------------------------------------");
            this.log.info((Object)"Create shell");
            Shell sh = ScreenFactory.createShell();
            ScreenProcessor.process((FxScreenTemplate)sh, (String)sh.getDefaultBundle());
            List places = sh.getAdPlaces();
            if (places != null && !places.isEmpty()) {
                this.log.info((Object)"Create banner rotator");
                this.createDaemon(new AdvBannerRotator(places), "AdvBannerRotator");
            } else {
                this.log.info((Object)"Shell banners is not found");
            }
            if (baseCss != null) {
                this.log.info((Object)("Set stylesheet for base pane: " + baseCss));
                sh.addBaseCss(baseCss);
            } else {
                this.log.error((Object)"Stylesheet is not found");
            }
            this.log.info((Object)"Add color scheme");
            URL dcs = Locator.getFileUrl((String)"/gui/skin/{name}//system/colorscheme.css");
            if (dcs != null) {
                this.log.info((Object)("Default color scheme path: " + dcs.toString()));
                sh.addBaseCss(dcs.toExternalForm());
            }
            Optional.ofNullable(References.getMenu()).map(Menu::getMenuDesign).filter(Predicate.isEqual("").negate()).map(n -> {
                Skin.setWorkColorScheme((String)n);
                return n.endsWith(".css") ? n : n + ".css";
            }).ifPresent(n -> {
                URL cs = Locator.getUrl((String)("/gui/skin/{name}/css/" + n));
                if (cs != null) {
                    this.log.info((Object)("Color scheme path: " + cs.toString()));
                    sh.addBaseCss(cs.toExternalForm());
                }
            });
            URL url = Locator.getUrl((String)"/gui/skin/{name}/css/menu.css", (boolean)false);
            if (url != null) {
                this.log.info((Object)("Add external stylesheet: " + url));
                sh.addBaseCss(url.toExternalForm());
            }
            this.log.info((Object)"-------------------------------------------------------------------------------");
            this.log.info((Object)("Apply on-top property: " + sd.getGuiConfiguration().isOnTop()));
            if (sd.getGuiConfiguration().isOnTop()) {
                stage.focusedProperty().addListener((observable, oldValue, newValue) -> {
                    if (!newValue.booleanValue()) {
                        this.log.info((Object)"Process on top");
                        stage.toFront();
                    }
                });
            }
            this.log.info((Object)"Create scene");
            Scene scene = new Scene((Parent)sh.getPane(), (double)rs.getWidth(), (double)rs.getHeight());
            stage.setScene(scene);
            scene.setCursor(Boolean.FALSE.equals(sd.getGuiConfiguration().isShowCursor()) ? Cursor.NONE : Cursor.DEFAULT);
            stage.initStyle(SystemProp.isWindowDecorated() ? StageStyle.DECORATED : StageStyle.UNDECORATED);
            this.log.info((Object)"Show stage");
            stage.show();
            this.log.info((Object)"Stage showing is completed");
            this.log.info((Object)"-------------------------------------------------------------------------------");
            this.log.info((Object)"Create dialog timer");
            BaseTimer timer = new BaseTimer(userAction);
            this.createDaemon((Runnable)((Object)timer), "DialogTimerThread");
            LocalEntryPoint entryPoint = new LocalEntryPoint();
            this.log.info((Object)"Create dialog engine");
            BaseDialogCore dialogCore = new BaseDialogCore((Timer)timer, (DialogErrorListener)new DialogErrorHandler(entryPoint), (BannerProcessor)new AdvBannerProcessor());
            BaseDialogModule dialogModule = new BaseDialogModule((DialogCore)dialogCore, new BaseShellLayer(sh, LayerType.Dialog, "** dlg **"));
            BaseWaitModule waitModule = new BaseWaitModule(sh, (BannerProcessor)new AdvBannerProcessor());
            DefaultScreenModule sm = new DefaultScreenModule(sh, (BannerProcessor)new AdvBannerProcessor());
            sm.addTemplateListener((TemplateListener)returnService);
            DefaultCustomModule customModule = new DefaultCustomModule((Timer)timer, sh, (BannerProcessor)new AdvBannerProcessor());
            DefaultPopupModule popupModule = new DefaultPopupModule((Timer)timer, sh, (BannerProcessor)new AdvBannerProcessor());
            this.log.info((Object)"Create task executor");
            FxTaskExecutor taskExecutor = new FxTaskExecutor((WaitModule)waitModule);
            this.createDaemon(taskExecutor, "TaskThread");
            Task.setExecutor(taskExecutor);
            if (FxEnv.getCardModuleHandler() != null) {
                FxEnv.getCardModuleHandler().setWaitModule((WaitModule)waitModule);
            }
            TaskStateMonitor tsm = new TaskStateMonitor(userAction);
            taskExecutor.setListener(tsm);
            this.createDaemon(tsm, "TaskStateMonitor");
            this.log.info((Object)"-------------------------------------------------------------------------------");
            this.log.info((Object)"Create menu engine");
            this.menuEngine = new MenuEngine((ScreenModule)sm);
            FxEnvInit.setMenuEngine(this.menuEngine);
            this.menuEngine.setListener(new LocalMenuListener());
            this.log.info((Object)"Init environment factory");
            FxEnv.setScreenModule((ScreenModule)sm);
            FxEnv.setCustomModule((CustomModule)customModule);
            FxEnv.setPopupModule((PopupModule)popupModule);
            Dialog.setModule((DialogModule)dialogModule);
            BaseModule.init(entryPoint);
            Launcher.setEntryPoint(entryPoint);
            Session.addListener(new SessionListener(){

                @Override
                public void onChangeLocale(Locale locale) {
                    FxEnv.refreshScreen();
                }

                @Override
                public void onUpdateScreen() {
                    FxEnv.refreshScreen();
                }
            });
            this.log.info((Object)"Create lock module");
            this.lockModule = new DefaultLockModule((ScreenModule)sm);
            KeyStore keyStore = sd.getKeyStore();
            SecureSaveUtils.setKeyStore(keyStore);
            this.keeperInit(keyStore != null);
            if (sp.isUsePreloading()) {
                new PreloadTask(sp, this::startApp).process();
            } else {
                this.startApp();
            }
            this.initMenuVisitCounter();
        }
        catch (ShellCreateException | SkinException ex) {
            this.log.error((Object)"Error on create shell", ex);
            throw new ContextException("Can't run default soft-logic terminal context", ex);
        }
    }

    private void initMenuVisitCounter() {
        VisitMenuCounter.setMaxCount(SystemProp.getMenuEmptyClickCount());
        VisitMenuCounter.setListener((n, period) -> {
            String time = String.format("%02d:%02d:%02d", period / 3600L, period % 3600L / 60L, period % 60L);
            GuiNotifier.notifyProblem((String)(n + " visits without payment. Transitions performed during the period per " + time));
        });
    }

    private void keeperInit(boolean signed) {
        String path = PathUtils.getPath((String)"/data/keeper.obj");
        PayEnv payEnv = null;
        try {
            Result loadKeeperResult = SecureSaveUtils.loadSavedObject(path, signed);
            if (loadKeeperResult != null) {
                payEnv = (PayEnv)loadKeeperResult.getObject();
                if (loadKeeperResult.getState() != 0 && payEnv.getPack() != null) {
                    payEnv.getPack().setFraud(true);
                }
            } else {
                this.log.info((Object)"Keeper was not found");
            }
        }
        catch (SaveObjectException ex) {
            this.log.warn((Object)("Load keeper object error. Reason: " + ex));
        }
        if (payEnv == null) {
            NewKeeper2 newKeeper2 = new NewKeeper2(CompatCashFactory.getSystemCurrency());
            payEnv = new PayEnv(newKeeper2, null);
        }
        Session.setPayEnv(payEnv);
        SavingTask task = new SavingTask(path, SavingObjectType.payEnv, signed);
        SavingHandler envSavingHandler = SecureSaveUtils.addSavingTask(task);
        NewKeeper2 kpr = payEnv.getKeeper();
        Session.getPayEnv().setListener(() -> {
            envSavingHandler.saveObject(Session.getPayEnv());
            Sum totalChange = kpr.getInSumTotal().add(kpr.getOut());
            Session.setItem("sumchange", totalChange);
            Session.setDefaultItem("sumchange", totalChange);
        });
        this.sendForgottenPaymentsAfterInit();
    }

    private void startApp() {
        this.toInitialState(0);
        StateFacade.addListener(new LocalFacadeListener());
    }

    private void toInitialState(int initiator) {
        if (initiator != 0) {
            this.log2.info((Object)("Return to main menu, " + PackUtility.changeAsStr()));
        }
        if (Session.getRedirectItem() != null) {
            MenuItem mi = Session.getRedirectItem();
            this.resetData(initiator);
            this.menuEngine.start();
            Launcher.open(mi);
        } else {
            this.resetData(initiator);
            this.updateHardware();
            TerminalState state = StateFacade.getState();
            int errorCode = state.getErrorCode();
            if (errorCode != 0 || errorCode != 0) {
                this.log2.info((Object)("Current terminal state: " + state + (errorCode != 0 ? "(error)" : "")));
            }
            if (errorCode != 0) {
                Session.setItem("terminal_state", state);
                this.lockModule.start();
            } else {
                this.menuEngine.start();
            }
        }
    }

    private void updateHardware() {
        block4: {
            CardReader crd = FxEnv.getCardReader();
            try {
                if (crd == null || !crd.isEnabled()) break block4;
                try {
                    crd.ejectCard();
                }
                catch (IllegalStateException | CardReaderException ex) {
                    this.log.info((Object)"The card was returned");
                }
                crd.disableDevice();
                crd.release();
            }
            catch (IllegalStateException ex) {
                this.log.error((Object)("Update hardware error. Reason: " + ex.getMessage()));
            }
        }
    }

    private void sendForgottenPayments() {
        NewKeeper2 keeper = Session.getPayEnv().getKeeper();
        Pack pack = Session.getPayEnv().getPack();
        if (!(pack == null || keeper.isInEmpty() && keeper.getOut().isEmpty())) {
            this.log2.info((Object)("Change was reset: " + keeper));
            if (this.isOnlineProcessing(pack)) {
                this.processOnlineForgottenPayments(pack);
                keeper.reset();
                return;
            }
            Operation op = PackUtility.cancelPayEnvToPin(Session.getPayEnv());
            this.sendForgottenFunds(op);
            keeper.reset();
            Session.getPayEnv().setPack(null);
        }
    }

    private void sendForgottenPaymentsAfterInit() {
        NewKeeper2 keeper = Session.getPayEnv().getKeeper();
        Pack pack = Session.getPayEnv().getPack();
        if (!(pack == null || keeper == null || keeper.isInEmpty() && keeper.getOut().isEmpty())) {
            this.log2.info((Object)("Change was reset: " + keeper));
            if (this.isOnlineProcessing(pack)) {
                this.processOnlineForgottenPayments(pack);
                keeper.reset();
                return;
            }
            Operation op = PackUtility.cancelPayEnvToPin(Session.getPayEnv());
            this.sendForgottenFunds(op);
            Session.getPayEnv().setPack(null);
        } else if (pack != null) {
            this.log2.info((Object)"Keeper is empty, but pack isn't empty.");
            if (this.isOnlineProcessing(pack)) {
                this.processOnlineForgottenPayments(pack);
            } else {
                this.log2.info((Object)("Payment was offline. Reset pack: " + pack));
                Session.getPayEnv().setPack(null);
            }
        }
        if (keeper != null) {
            keeper.reset();
        }
    }

    private void processOnlineForgottenPayments(Pack pack) {
        this.log2.info((Object)"Payment was online. Create change operation.");
        Pair<Operation, Operation> opers = PackUtility.cancelOnlinePack2(pack);
        Operation operation = (Operation)opers.getKey();
        if (operation != null) {
            this.sendForgottenFunds(operation);
        }
        if (opers.getValue() != null) {
            operation = (Operation)opers.getValue();
            this.sendForgottenFunds(operation);
        }
        this.log2.info((Object)("Reset pack: " + pack));
        Session.getPayEnv().setPack(null);
    }

    private void createDaemon(Runnable runnable, String name) {
        Thread timerThread = new Thread(runnable, name);
        timerThread.setDaemon(true);
        timerThread.start();
    }

    private void resetData(int initiator) {
        String langs;
        PointOptions po = References.getPointOptions();
        String lang = po != null ? po.getLanguage() : null;
        String string = langs = po != null ? po.getLanguages() : null;
        if (1 == initiator) {
            if (lang != null && langs != null && !langs.contains(lang)) {
                langs = lang + ";" + langs;
            }
            lang = Session.getLocale().getLanguage();
        }
        this.log2.debug((Object)("Terminal lang: " + lang));
        this.log2.debug((Object)("Terminal langs: " + langs));
        Session.resetSession(lang, langs);
    }

    private void sendForgottenFunds(Operation op) {
        this.log2.info((Object)("Canceling change operation: " + op));
        FxEnv.getConnector().putOperation(op);
        this.log2.info((Object)"Done");
    }

    public boolean isOnlineProcessing(Pack pack) {
        if (pack == null) {
            return false;
        }
        ProcessingType pt = pack.getService().getProcessingType();
        return pt == ProcessingType.Online || pt == ProcessingType.HalfOnline;
    }

    private class LocalFacadeListener
    implements StateListener {
        private LocalFacadeListener() {
        }

        @Override
        public void onState(TerminalState state) {
            int type = ModuleStore.getModule().getType();
            int errorCode = state.getErrorCode();
            if (type == 1 && errorCode != 0) {
                DefaultTerminalContext.this.log2.info((Object)("Active module: main menu, state: " + StateMsg.getTerminalState(state) + ", lock terminal"));
                TerminalPlatform.runLater(() -> DefaultTerminalContext.this.toInitialState(0));
            } else if (type == 0 && errorCode == 0) {
                DefaultTerminalContext.this.log2.info((Object)("Active module: lock, state: " + StateMsg.getTerminalState(state) + ", unlock terminal"));
                TerminalPlatform.runLater(() -> DefaultTerminalContext.this.toInitialState(0));
            }
        }
    }

    private class LocalEntryPoint
    implements EntryPoint {
        private LocalEntryPoint() {
        }

        @Override
        public void toInitialState(int initiator) {
            if (initiator == 0) {
                DefaultTerminalContext.this.log2.debug((Object)"Exit by timeout");
                DefaultTerminalContext.this.sendForgottenPayments();
            } else {
                DefaultTerminalContext.this.log2.info((Object)("toInitialState: " + initiator));
                DefaultTerminalContext.this.log2.info((Object)"Exit by user action");
            }
            DefaultTerminalContext.this.toInitialState(initiator);
        }

        @Override
        public void toPreviosState() {
            DefaultTerminalContext.this.updateHardware();
            DefaultTerminalContext.this.menuEngine.restore();
        }
    }

    private class LocalMenuListener
    implements MenuListener {
        private LocalMenuListener() {
        }

        @Override
        public void onMenuItem(MenuItem menuItem) {
            Launcher.open(menuItem);
        }

        @Override
        public void onExit() {
            DefaultTerminalContext.this.log2.info((Object)"User press 'exit' into main menu");
            DefaultTerminalContext.this.toInitialState(1);
        }
    }
}

