/*
 * Decompiled with CFR 0.152.
 */
package fxterm.app;

import java.util.HashMap;
import java.util.Map;

public class SystemProp {
    private static final Map<String, Integer> intValues = new HashMap<String, Integer>();

    private SystemProp() {
    }

    public static final boolean isUpdaterEnable() {
        return !"true".equalsIgnoreCase(SystemProp.getProperty("no-update"));
    }

    public static final boolean isQueueAgentEnable() {
        return !"true".equalsIgnoreCase(SystemProp.getProperty("no-send"));
    }

    public static final boolean isWindowDecorated() {
        return "DECORATED".equals(SystemProp.getProperty("stage.style"));
    }

    public static final boolean isUseLocaleSearcher() {
        return "locale".equals(SystemProp.getProperty("provider.search"));
    }

    public static final String getDefaultCurrency() {
        return SystemProp.getProperty("currency", "RUB");
    }

    public static final String getLockScreenPassword() {
        return SystemProp.getProperty("password", "1234");
    }

    public static final String getDateTimeFormat() {
        return SystemProp.getProperty("datetime.format");
    }

    public static final int getMenuEmptyClickCount() {
        return SystemProp.getCachedIntValue("menu.click.count", 100, 50, 500);
    }

    public static final int getScheduleReboot() {
        return SystemProp.getCachedIntValue("schedule.reboot", 1, 1, 30);
    }

    public static final int getCmdLaucherDelay() {
        return SystemProp.getCachedIntValue("cmdlaucher.delay", 180, 10, 360);
    }

    public static final int getUpdateFreq() {
        return SystemProp.getCachedIntValue("update.freq", 180, 3, 180);
    }

    public static final boolean isAddButtonsToMax() {
        return "true".equalsIgnoreCase(SystemProp.getProperty("menu.hotarea.addtomax", "true"));
    }

    public static final boolean isConfirmAfterVerify() {
        return "true".equalsIgnoreCase(SystemProp.getProperty("confirmVerify", "true"));
    }

    public static final boolean isRemoveIncorrectService() {
        return "true".equalsIgnoreCase(SystemProp.getProperty("menu.hideIncorrect", "false"));
    }

    public static final boolean isChangeMobileUseMenuComm() {
        return "true".equalsIgnoreCase(SystemProp.getProperty("Module.reinit.change.modile.use-menu-comm", "false"));
    }

    public static final boolean isHotKeyRotate() {
        return "true".equalsIgnoreCase(SystemProp.getProperty("hotkey.rotate", "false"));
    }

    public static final int getPayTplProviderId() {
        return SystemProp.getCachedIntValue("paytpl.provider.id", -1, -1, Short.MAX_VALUE);
    }

    public static final int getComplaintServiceId() {
        return SystemProp.getCachedIntValue("service.complaint.id", -1, -1, Short.MAX_VALUE);
    }

    public static final int getFaultServiceId() {
        return SystemProp.getCachedIntValue("service.fault.id", -1, -1, Short.MAX_VALUE);
    }

    public static final short getAddServiceId() {
        return (short)SystemProp.getCachedIntValue("service.addsrv.id", -1, -1, Short.MAX_VALUE);
    }

    public static final boolean isAutoCollection() {
        return !"false".equalsIgnoreCase(SystemProp.getProperty("collection.auto", "true"));
    }

    public static final String getPreferredDenomination() {
        return SystemProp.getProperty("store.preferred.denomination");
    }

    public static final String getPreferredDenominationCount() {
        return SystemProp.getProperty("store.preferred.count");
    }

    private static synchronized int getCachedIntValue(String key, int def, int min, int max) {
        Integer val = intValues.get(key);
        if (val == null) {
            val = SystemProp.getIntValue(key, def, min, max);
            intValues.put(key, val);
        }
        return val;
    }

    private static int getIntValue(String key, int def, int min, int max) {
        int val;
        try {
            val = Integer.parseInt(SystemProp.getProperty(key, Integer.toString(def)));
        }
        catch (NumberFormatException ex) {
            val = def;
        }
        return SystemProp.checkRange(val, min, max);
    }

    private static int checkRange(int val, int min, int max) {
        if (min > 0 && val < min) {
            return min;
        }
        if (max > 0 && val > max) {
            return max;
        }
        return val;
    }

    private static String getProperty(String key) {
        String val = System.getProperty(key);
        return val == null ? null : val.trim();
    }

    private static String getProperty(String key, String def) {
        String val = System.getProperty(key, def);
        return val == null ? null : val.trim();
    }
}

