/*
 * Decompiled with CFR 0.152.
 */
package fxterm.app;

import fxterm.app.id.LoggerId;
import fxterm.core.reboot.CauseIO;
import fxterm.core.reboot.RebootAction;
import fxterm.msg.Messages;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.Callable;
import org.apache.log4j.Logger;
import ru.softlogic.srv.api.event.Event;
import ru.softlogic.srv.api.event.EventType;
import ru.softlogic.system.util.DaemonUtil;
import ru.softlogic.system.util.PathUtils;

public class StartCallable
implements Callable<List<Event>> {
    private Logger log = LoggerId.START;

    @Override
    public List<Event> call() throws Exception {
        Exception ex;
        Object obj;
        this.log.info((Object)"Process StartCallable");
        LinkedList<Event> events = new LinkedList<Event>();
        RebootAction ra = CauseIO.readRebootAction();
        this.log.info((Object)("Reboot cause: " + Messages.getReboot(ra)));
        String updJava = this.readJavaUpdateResult();
        if (updJava != null) {
            this.log.info((Object)("Java update result: " + updJava));
        }
        if (ra.getCause() != 7) {
            if (ra.getCause() == 3) {
                this.log.info((Object)"Restart after download updates");
                Properties prop = new Properties();
                this.readUpdateResult(prop);
                String res = prop.getProperty("result", "2");
                String msg = prop.getProperty("message");
                ra = new RebootAction(ra.getAction(), "0".equals(res) ? 4 : 5);
            }
            events.add(new Event(EventType.Start, "cause=" + Messages.getReboot(ra)));
        }
        if (updJava != null) {
            events.add(new Event(EventType.Update, updJava));
        }
        if ((obj = DaemonUtil.readObject((String)"_update_move", (boolean)true)) != null && obj instanceof Exception) {
            ex = (Exception)obj;
            events.add(new Event(EventType.UpdateFault, "Move: " + ex.getMessage()));
        }
        if ((obj = DaemonUtil.readObject((String)"_update_clean", (boolean)true)) != null && obj instanceof Exception) {
            ex = (Exception)obj;
            events.add(new Event(EventType.UpdateFault, "Clean: " + ex.getMessage()));
        }
        if ((obj = DaemonUtil.readObject((String)"_update_unpack", (boolean)true)) != null && obj instanceof Exception) {
            ex = (Exception)obj;
            events.add(new Event(EventType.UpdateFault, "Unpack: " + ex.getMessage()));
        }
        this.log.info((Object)"StartCallable is done");
        return events;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private String readJavaUpdateResult() {
        block20: {
            Properties prop = new Properties();
            File f = PathUtils.getFilePath((String)"/jre/upd//result");
            if (!f.exists()) break block20;
            try {
                String string;
                Throwable throwable;
                FileInputStream is;
                block18: {
                    block19: {
                        is = new FileInputStream(f);
                        throwable = null;
                        prop.load(is);
                        string = "Java update result: " + prop.getProperty("message") + ", timeout: " + prop.getProperty("timeout");
                        if (is == null) break block18;
                        if (throwable == null) break block19;
                        try {
                            ((InputStream)is).close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        break block18;
                    }
                    ((InputStream)is).close();
                }
                return string;
                catch (Throwable throwable3) {
                    try {
                        try {
                            throwable = throwable3;
                            throw throwable3;
                        }
                        catch (Throwable throwable4) {
                            if (is != null) {
                                if (throwable != null) {
                                    try {
                                        ((InputStream)is).close();
                                    }
                                    catch (Throwable throwable5) {
                                        throwable.addSuppressed(throwable5);
                                    }
                                } else {
                                    ((InputStream)is).close();
                                }
                            }
                            throw throwable4;
                        }
                    }
                    catch (IOException iOException) {
                    }
                }
            }
            finally {
                if (!f.delete()) {
                    f.deleteOnExit();
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readUpdateResult(Properties prop) {
        File f = PathUtils.getFilePath((String)"/data//update/result.properties");
        if (f.exists()) {
            try (FileInputStream is = new FileInputStream(f);){
                prop.load(is);
            }
            catch (IOException iOException) {
            }
            finally {
                if (!f.delete()) {
                    f.deleteOnExit();
                }
            }
        }
    }
}

