/*
 * Decompiled with CFR 0.152.
 */
package fxterm.app;

import fxterm.app.id.LoggerId;
import fxterm.core.reboot.SafeReboot;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.log4j.Logger;
import plfx.GuiNotifier;
import ru.softlogic.srv.api.event.Event;
import ru.softlogic.srv.api.event.EventType;
import ru.softlogic.srv.connector.ClientInterface;

class GuiNotifierImpl
extends GuiNotifier
implements Runnable {
    private final ClientInterface server;
    private final Logger log = LoggerId.START;
    private final BlockingQueue<Event> queue = new LinkedBlockingQueue<Event>();

    public GuiNotifierImpl(ClientInterface server) {
        if (server == null) {
            throw new NullPointerException("ClientInterface is not set");
        }
        this.server = server;
    }

    public void onError(Throwable ex) {
        this.log.error((Object)"Notify error", ex);
        this.queue.add(new Event(EventType.SoftwareFault, Thread.currentThread().getName() + "," + ex.getClass().getSimpleName() + ":" + ex.getMessage()));
    }

    public void onError(String message) {
        this.log.error((Object)("Notify error: " + message));
        this.printStackTrace();
        this.queue.add(new Event(EventType.SoftwareFault, message));
    }

    public void onProblem(String message) {
        this.log.warn((Object)("Notify problem: " + message));
        this.printStackTrace();
        this.queue.add(new Event(EventType.Warning, message));
    }

    protected void onRequestRestart(String cause) {
        this.log.error((Object)("Software fault, needs restart. Cause: " + cause));
        this.printStackTrace();
        this.server.sendEvent(new Event[]{new Event(EventType.SoftwareFault, "Reboot requested: " + cause)});
        SafeReboot.exit(0, 11);
    }

    private void printStackTrace() {
    }

    @Override
    public void run() {
        try {
            while (!Thread.currentThread().isInterrupted()) {
                Event ev = this.queue.take();
                this.server.sendEvent(new Event[]{ev});
            }
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
        }
    }
}

