/*
 * Decompiled with CFR 0.152.
 */
package fxterm.app;

import com.sun.management.OperatingSystemMXBean;
import com.sun.net.ssl.internal.ssl.Provider;
import fxterm.app.AppDataExtractor;
import fxterm.app.AppTimeMarker;
import fxterm.app.ApplicationException;
import fxterm.app.BaseDriverFactory;
import fxterm.app.CompositeRunner;
import fxterm.app.Configuration;
import fxterm.app.ConfigurationException;
import fxterm.app.ConfigurationNotFoundException;
import fxterm.app.FailureListener;
import fxterm.app.FxEnv;
import fxterm.app.FxEnvInit;
import fxterm.app.GuiNotifierImpl;
import fxterm.app.PaylogicResources;
import fxterm.app.ResolutionReader;
import fxterm.app.StartCallable;
import fxterm.app.SystemProp;
import fxterm.app.TerminalApplication;
import fxterm.app.VersionProducer;
import fxterm.app.context.Context;
import fxterm.app.context.ContextException;
import fxterm.app.context.ContextFactory;
import fxterm.app.context.StartupData;
import fxterm.app.id.LoggerId;
import fxterm.core.AppFinalizatorAdapter;
import fxterm.core.AppStateWatcher;
import fxterm.core.MemoryWatcher;
import fxterm.core.NoPaymentsRebooter;
import fxterm.core.OpenFileWatcher;
import fxterm.core.PowerScheduler;
import fxterm.core.Rebooter;
import fxterm.core.ResourceErrorListener;
import fxterm.core.SkinUpdater;
import fxterm.core.UncaughtExceptionListener;
import fxterm.core.adv.disig.AppSystemListener;
import fxterm.core.adv.disig.RefPlaylistProducer;
import fxterm.core.adv.stat.AdvStatHandler;
import fxterm.core.adv.stat.AdvStatListener;
import fxterm.core.adv.stat.AdvStatLoader;
import fxterm.core.cmd.CommandLauncher;
import fxterm.core.disk.DiskObserver;
import fxterm.core.disk.ErrorProcessor;
import fxterm.core.hdw.CommonDriverFactory;
import fxterm.core.hdw.bar.BarDriverFactory;
import fxterm.core.hdw.bvr.BvrDriverFactory;
import fxterm.core.hdw.bvr.CashManager;
import fxterm.core.hdw.bvr.PayoutProfileUpdater;
import fxterm.core.hdw.cdm.CdmDriverFactory;
import fxterm.core.hdw.cvd.CvdDriverFactory;
import fxterm.core.hdw.modem.DialupDriverFactory;
import fxterm.core.hdw.prt.PrtDriverFactory;
import fxterm.core.hdw.wcm.WcmDriverFactory;
import fxterm.core.net.NetworkInterfaceObserver;
import fxterm.core.net.QueueAgent;
import fxterm.core.net.QueueAgentNotifier;
import fxterm.core.net.VpnObserver;
import fxterm.core.net.ppp.DialupSystem;
import fxterm.core.net.ppp.NetworkObserver2;
import fxterm.core.net.stat.NetStatHandler;
import fxterm.core.net.stat.NetStatLoader;
import fxterm.core.reboot.SafeReboot;
import fxterm.core.state.BaseFacadeEngine;
import fxterm.core.state.StateFacade;
import fxterm.core.system.PcInfoRunnable;
import fxterm.core.system.RfRunnable;
import fxterm.core.timer.TimerThread;
import fxterm.core.update.UpdateChecker;
import fxterm.module.DynamicTimeoutManager;
import fxterm.module.TimeoutManager;
import fxterm.module.input.mobile.FilterUpdater;
import fxterm.module.input.mobile.ReferenceFilterUpdater;
import fxterm.session.VelocitySumFormatter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.management.ManagementFactory;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.Security;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import javafx.application.Platform;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.stage.Screen;
import javafx.stage.Stage;
import javafx.stage.StageStyle;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.log4j.Logger;
import org.apache.velocity.app.Velocity;
import org.apache.velocity.app.event.ReferenceInsertionEventHandler;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import plfx.AudioPlayerFx;
import plfx.GuiNotifier;
import plfx.TimeMarker;
import plfx.msg.MessageProcessor;
import plfx.msg.screen.DataExtractor;
import plfx.msg.screen.ScreenProcessor;
import plfx.screen.ScreenCreateException;
import plfx.screen.utility.launch.CrashScreenFactoty;
import plfx.screen.utility.launch.CrashScreenTemplate;
import plfx.screen.utility.launch.DefaultErrorFactory;
import plfx.screen.utility.launch.ErrorScreenListener;
import plfx.screen.utility.launch.LaunchErrorScreen;
import plfx.skin.Resolution;
import plfx.skin.Skin;
import plfx.skin.SkinException;
import plfx.skin.SkinProperties;
import plfx.skin.SkinSet;
import plfx.util.Locator;
import plfx.util.LocatorErrorListener;
import plfx.util.TimeMeter;
import ru.softlogic.app.DaemonVersion;
import ru.softlogic.config.add.ConConfiguration;
import ru.softlogic.config.add.Proxy;
import ru.softlogic.config.add.ServerProfile;
import ru.softlogic.disig.app.DiSigAppException;
import ru.softlogic.disig.app.DiSigApplication;
import ru.softlogic.disig.app.DiSigCreatingException;
import ru.softlogic.disig.app.DiSigFactory;
import ru.softlogic.disig.impl.CascadeProducer;
import ru.softlogic.disig.impl.DefaultPlayerListener;
import ru.softlogic.disig.impl.DefaultPlaylistProducer;
import ru.softlogic.disig.impl.Producer;
import ru.softlogic.disig.impl.StaticPlaylistProducer;
import ru.softlogic.disig.player.PlayerListener;
import ru.softlogic.disig.player.SystemListener;
import ru.softlogic.disig.utils.DiSigUtils;
import ru.softlogic.hdw.Hardware;
import ru.softlogic.hdw.dev.modem.Modem;
import ru.softlogic.hdw.dev.printer.PrintSpooler;
import ru.softlogic.hdw.dev.watchdog.WatchDog;
import ru.softlogic.hdw.dev.webcam.Webcam;
import ru.softlogic.io.serial.SerialPort;
import ru.softlogic.reference.References;
import ru.softlogic.reference.ReferencesIO;
import ru.softlogic.reference.ReferencesListener;
import ru.softlogic.reference.menu.Menu;
import ru.softlogic.reference.point.Dealer;
import ru.softlogic.reference.point.Point;
import ru.softlogic.services.identify.IdentifyService;
import ru.softlogic.services.identify.ResourcesLoader;
import ru.softlogic.srv.api.command.Command;
import ru.softlogic.srv.api.event.Event;
import ru.softlogic.srv.connector.ClientInterface;
import ru.softlogic.srv.connector.ConnConfiguration;
import ru.softlogic.srv.connector.ConnectorConfigurationException;
import ru.softlogic.srv.connector.ConnectorFactory;
import ru.softlogic.srv.connector.ConnectorType;
import ru.softlogic.srv.connector.NetObserver;
import ru.softlogic.srv.connector.ProxyConfiguration;
import ru.softlogic.srv.connector.RefVersionObserver;
import ru.softlogic.srv.connector.RemoteStatusObserver;
import ru.softlogic.srv.connector.ServerInterface;
import ru.softlogic.srv.connector.StateWatcher;
import ru.softlogic.srv.queue.Queue;
import ru.softlogic.srv.utils.NetworkUtils;
import ru.softlogic.storage.io.Serializator;
import ru.softlogic.storage.io.SetDataStore;
import ru.softlogic.storage.io.SimpleSerializator;
import ru.softlogic.system.util.FileUtil;
import ru.softlogic.system.util.FileUtilException;
import ru.softlogic.system.util.OsDetector;
import ru.softlogic.system.util.PathUtils;
import ru.softlogic.system.util.ProcessExecutor;
import ru.softlogic.system.util.TimeUtil;
import ru.softlogic.system.util.hwd.SerialExtractorApi;
import ru.softlogic.system.util.os.OsApi;
import ru.softlogic.update.updater.UpdateHandler;
import ru.softlogic.update.updater.UpdateSystem;

public class DefaultTerminalApplicationV2
extends BaseDriverFactory
implements TerminalApplication {
    private final Logger log = LoggerId.START;
    private final PaylogicResources resources;
    private ServerInterface serverInterface;
    private ClientInterface clientInterface;
    private Queue queue;
    private QueueAgent queueAgent;
    private ProcessExecutor executor;
    private ScheduledExecutorService scheduler;
    private int appState = 0;
    private final Object sync = new Object();
    private DiSigApplication dsa;

    public DefaultTerminalApplicationV2() {
        this.resources = new PaylogicResources();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start(Stage stage) {
        Object object = this.sync;
        synchronized (object) {
            if (this.appState != 0) {
                throw new IllegalStateException("Application already started");
            }
            this.appState = 1;
        }
        this.scheduler = Executors.newScheduledThreadPool(3);
        FxEnvInit.setThreadPool(this.scheduler);
        this.log.info((Object)"*******************************************************************************");
        this.log.info((Object)"Start application");
        StartCallable sc = new StartCallable();
        TimeMeter tm = new TimeMeter();
        UncaughtExceptionListener exceptionListener = new UncaughtExceptionListener();
        Thread.setDefaultUncaughtExceptionHandler(exceptionListener);
        this.log.info((Object)("System locale: " + Locale.getDefault()));
        try {
            Object events;
            Security.setProperty("networkaddress.cache.ttl", "86400");
            Security.setProperty("networkaddress.cache.negative.ttl", "0");
            this.log.info((Object)"Add security provider: com.sun.net.ssl.internal.ssl.Provider");
            Security.addProvider((java.security.Provider)new Provider());
            this.log.info((Object)"Add security provider: org.bouncycastle.jce.provider.BouncyCastleProvider");
            Security.addProvider((java.security.Provider)new BouncyCastleProvider());
            this.log.info((Object)"-------------------------------------------------------------------------------");
            SafeReboot.setFinalizator(new AppFinalizatorAdapter(this));
            this.log.info((Object)"Read references");
            ReferencesIO.load((File)PathUtils.getFilePath((String)"/data/references.pst"));
            this.log.info((Object)("References stored by: " + References.getSoftware()));
            if (References.getSoftware() != null && !DaemonVersion.version.equals(References.getSoftware())) {
                this.log.info((Object)"Software revision was changed, clear client references version");
                References.setVersion((long)0L);
                References.setSoftware((String)DaemonVersion.version);
            }
            ReferencesIO.addListener((ReferencesListener)new SkinUpdater());
            ReferencesIO.addListener((ReferencesListener)new PayoutProfileUpdater());
            this.log.info((Object)"-------------------------------------------------------------------------------");
            this.printEnvironmentInfo();
            this.log.info((Object)"Create process executor for os api");
            this.executor = new ProcessExecutor();
            OsApi.getInstance().setExecutor(this.executor);
            this.log.info((Object)"-------------------------------------------------------------------------------");
            this.log.info((Object)"Check the availability of directories");
            FileUtil.checkDir((String)PathUtils.getPath((String)"/data/"));
            FileUtil.checkDir((String)PathUtils.getPath((String)"/data/cash-in/"));
            FileUtil.checkDir((String)PathUtils.getPath((String)"/data/screenshot/"));
            FileUtil.checkDir((String)PathUtils.getPath((String)"/data/network/"));
            FileUtil.checkDir((String)PathUtils.getPath((String)"/data/sequence/"));
            FileUtil.checkDir((String)PathUtils.getPath((String)"/data/flags/"));
            FileUtil.checkDir((String)PathUtils.getPath((String)"/content/ad/"));
            FileUtil.checkDir((String)PathUtils.getPath((String)"/content/static/"));
            FileUtil.checkDir((String)PathUtils.getPath((String)"/content/default/"));
            FileUtil.checkDir((String)PathUtils.getPath((String)"/data/disp/bill/"));
            FileUtil.checkDir((String)PathUtils.getPath((String)"/data/disp/coin/"));
            FileUtil.checkDir((String)PathUtils.getPath((String)"/data/save/"));
            FileUtil.checkDir((String)PathUtils.getPath((String)"/data/barcode/"));
            FileUtil.checkDir((String)PathUtils.getPath((String)"/disig/"));
            this.log.info((Object)"Read configuration");
            Configuration cnf = new Configuration(PathUtils.getFilePath((String)"/conf.xml"));
            cnf.read();
            this.log.info((Object)"Done");
            Locale loc = Locale.getDefault();
            this.log.info((Object)("Set application locale: " + loc));
            Locale.setDefault(loc);
            this.log.info((Object)"Initialize media player");
            AudioPlayerFx.getInstance().setDirectory(PathUtils.getAppHome() + File.separator + AudioPlayerFx.SOUND_DIRECTORY_PATH + File.separator);
            AudioPlayerFx.getInstance().setLocale(loc);
            AudioPlayerFx.getInstance().start();
            MessageProcessor.getEventCartridge().addReferenceInsertionEventHandler((ReferenceInsertionEventHandler)new VelocitySumFormatter());
            this.log.info((Object)"Create command store");
            SetDataStore commandStore = new SetDataStore((Serializator)new SimpleSerializator(PathUtils.getFilePath((String)"/data//commands.obj")));
            this.createConnector(cnf.getConConfiguration(), (SetDataStore<Command>)commandStore);
            this.scheduler.schedule(DefaultTerminalApplicationV2._p(new PcInfoRunnable(this.queue)), 10L, TimeUnit.SECONDS);
            this.scheduler.scheduleAtFixedRate(DefaultTerminalApplicationV2._p(new RfRunnable(this.queue)), 1L, 240L, TimeUnit.MINUTES);
            GuiNotifierImpl gni = new GuiNotifierImpl(this.clientInterface);
            this.resources.getThreads().add(new Thread((Runnable)gni, "GuiNotifierImpl"));
            GuiNotifier.init((GuiNotifier)gni, (TimeMarker)new AppTimeMarker());
            Locator.setListener((LocatorErrorListener)new ResourceErrorListener(this.clientInterface));
            this.log.info((Object)"-------------------------------------------------------------------------------");
            this.log.info((Object)"Create update software system");
            UpdateHandler uh = new UpdateHandler(null, LoggerId.UPDATE);
            UpdateSystem.setUpdateHandler((UpdateHandler)uh);
            if (SystemProp.isUpdaterEnable()) {
                this.resources.getThreads().add(new Thread((Runnable)uh, "SoftwareUpdater"));
                UpdateChecker uc = new UpdateChecker(uh, this.clientInterface);
                this.serverInterface.addRemoteStatusObserver((RemoteStatusObserver)uc);
                this.scheduler.scheduleAtFixedRate(DefaultTerminalApplicationV2._p(uc), 60L, 120L, TimeUnit.SECONDS);
            } else {
                this.log.info((Object)"Update system is disabled");
            }
            VpnObserver vpnObserver = new VpnObserver();
            this.resources.getThreads().add(new Thread((Runnable)vpnObserver, "VpnObserver"));
            this.serverInterface.addRemoteStatusObserver((RemoteStatusObserver)vpnObserver);
            NetStatHandler nsh = new NetStatHandler(PathUtils.getFilePath((String)"/data/network//stat.obj"));
            this.serverInterface.addNetObserver((NetObserver)nsh);
            NetStatLoader netStatLoader = new NetStatLoader(nsh, this.clientInterface, this.scheduler);
            this.scheduler.schedule(DefaultTerminalApplicationV2._p(netStatLoader), 10L, TimeUnit.SECONDS);
            this.log.info((Object)"Create command launcher");
            CommandLauncher commandLauncher = new CommandLauncher((SetDataStore<Command>)commandStore, this.clientInterface, this.executor);
            this.resources.getThreads().add(new Thread((Runnable)commandLauncher, "CommandLauncher"));
            PrintSpooler printSpooler = PrtDriverFactory.createPrinter(cnf.getPrtConfiguration(), this.clientInterface, this.resources);
            FxEnvInit.setPrinterSpooler(printSpooler);
            this.log.info((Object)"---  Create cash-in system ----------------------------------------------------");
            this.log.info((Object)"Create cash-in system");
            CashManager cm = BvrDriverFactory.createCashinSystem(cnf.getBvrConfiguration(), cnf.getCvrConfiguration(), stage, this.clientInterface, this.resources, this.scheduler);
            FxEnvInit.setCashManager(cm);
            this.log.info((Object)"--- Cash-in system created");
            Modem modem = DialupDriverFactory.createModem(cnf.getModConfiguration(), this.clientInterface);
            WatchDog wd = DialupDriverFactory.createWatchdog(cnf.getWdtConfiguration(), this.clientInterface, this.resources);
            DialupSystem dialupSystem = DialupDriverFactory.createDialupSystem(cnf.getConConfiguration().getDialup(), wd, modem, this.clientInterface, this.resources, this.scheduler);
            if (dialupSystem != null) {
                dialupSystem.addListener(new QueueAgentNotifier(this.scheduler, this.queueAgent));
                NetworkObserver2 no = new NetworkObserver2(dialupSystem);
                this.serverInterface.addNetObserver((NetObserver)no);
                FxEnvInit.setDialupSystem(dialupSystem);
            }
            BarDriverFactory.createBarcode(cnf.getBarConfiguration(), stage, this.clientInterface, this.resources);
            Webcam w = WcmDriverFactory.createWebcam(cnf.getWcmConfiguration(), this.clientInterface, this.resources);
            if (w != null) {
                FxEnvInit.setWebcam(w);
            }
            CvdDriverFactory.createCardDispenser(cnf.getCvdConfiguration(), this.clientInterface, this.resources);
            CdmDriverFactory.createBillDispenser(cnf.getBdmConfiguration(), this.clientInterface, this.resources);
            CdmDriverFactory.createCoinDispenser(cnf.getCdmConfiguration(), this.clientInterface, this.resources);
            CommonDriverFactory.createCardReader(cnf.getCrdConfiguration(), this.clientInterface, this.resources);
            CommonDriverFactory.createSensors(cnf.getSnrConfiguration(), this.clientInterface, this.resources);
            CommonDriverFactory.createCardModule(PathUtils.getFilePath((String)"/res/module/input/card/card-config.xml"), this.clientInterface, this.resources);
            CommonDriverFactory.createIOC(cnf.getIocConfiguration(), this.clientInterface, this.resources);
            this.log.info((Object)"Try to create player for second monitor");
            if (DiSigUtils.isNeedStart()) {
                File disig = PathUtils.getFilePath((String)"/disig/");
                try {
                    this.log.info((Object)"Try to launch app");
                    this.dsa = DiSigFactory.createApp((File)disig);
                    DefaultPlayerListener dpl = new DefaultPlayerListener(this.dsa.getPlayer(), (Producer)new CascadeProducer(new Producer[]{new RefPlaylistProducer(), new StaticPlaylistProducer(PathUtils.getFilePath((String)"/content/static/")), new DefaultPlaylistProducer(PathUtils.getFilePath((String)"/content/default/"))}));
                    this.dsa.getPlayer().addPlayerListener((PlayerListener)dpl);
                    this.dsa.getPlayer().addSystemListener((SystemListener)new AppSystemListener());
                    this.log.info((Object)"Success");
                }
                catch (DiSigCreatingException ex) {
                    this.log.error((Object)"Error on launch player", (Throwable)ex);
                }
            } else {
                this.log.info((Object)"Starting the player denied. Perhaps there is a no second monitor");
            }
            this.log.info((Object)"Init  velocity processor");
            Velocity.setProperty((String)"runtime.log.logsystem.class", (Object)"org.apache.velocity.runtime.log.Log4JLogChute");
            Velocity.setProperty((String)"runtime.log.logsystem.log4j.logger", (Object)"dbg");
            IdentifyService.configure((File)PathUtils.getFilePath((String)"/res/module/input/mobile/"));
            this.scheduler.schedule(DefaultTerminalApplicationV2._p(new CompositeRunner(new Runnable[]{new ResourcesLoader(), new FilterUpdater()})), 0L, TimeUnit.SECONDS);
            ReferencesIO.addListener((ReferencesListener)new ReferenceFilterUpdater(new FilterUpdater()));
            this.log.info((Object)"Create adv statistic system");
            AdvStatHandler ash = new AdvStatHandler(PathUtils.getFilePath((String)("/data/" + File.separator + "adv-stat.obj")));
            AdvStatLoader advStatLoader = new AdvStatLoader(ash, this.clientInterface, this.scheduler);
            this.scheduler.schedule(DefaultTerminalApplicationV2._p(advStatLoader), 10L, TimeUnit.SECONDS);
            if (this.dsa != null) {
                AdvStatListener asl = new AdvStatListener(ash);
                this.dsa.getPlayer().addPlayerListener((PlayerListener)asl);
            }
            this.log.info((Object)"-------------------------------------------------------------------------------");
            this.log.info((Object)"Run application");
            this.log.info((Object)"Create state facade");
            BaseFacadeEngine stateFacade = new BaseFacadeEngine(this.queue);
            FxEnv.getBillValidator().addStateListener(stateFacade.getCashAcceptorListener());
            printSpooler.addStateListener(stateFacade.getPrinterListener());
            StateFacade.setEngine(stateFacade);
            this.serverInterface.addRemoteStatusObserver(stateFacade.getNetworkObserver());
            TimeoutManager.setInstance(new DynamicTimeoutManager());
            this.log.info((Object)("Application load: " + tm.getIntervalMsAsStr()));
            this.resources.getThreads().add(new Thread((Runnable)new TimerThread(), "TimerThread"));
            this.scheduler.schedule(DefaultTerminalApplicationV2._p(new PowerScheduler(this.scheduler)), 10L, TimeUnit.MINUTES);
            this.scheduler.scheduleAtFixedRate(DefaultTerminalApplicationV2._p(new NoPaymentsRebooter()), 60L, 60L, TimeUnit.SECONDS);
            this.scheduler.scheduleAtFixedRate(DefaultTerminalApplicationV2._p(new NetworkInterfaceObserver(this.clientInterface)), 60L, 30L, TimeUnit.SECONDS);
            this.scheduler.scheduleAtFixedRate(DefaultTerminalApplicationV2._p(new MemoryWatcher()), 60L, 180L, TimeUnit.SECONDS);
            if (OsDetector.current() == 1) {
                this.scheduler.scheduleAtFixedRate(DefaultTerminalApplicationV2._p(new OpenFileWatcher()), 10L, 30L, TimeUnit.MINUTES);
            }
            this.scheduler.schedule(DefaultTerminalApplicationV2._p(new ErrorProcessor(this.clientInterface)), 10L, TimeUnit.SECONDS);
            this.scheduler.scheduleAtFixedRate(DefaultTerminalApplicationV2._p(new Rebooter()), TimeUtil.until((int)2) / 1000L, 86400L, TimeUnit.SECONDS);
            this.scheduler.scheduleAtFixedRate(DefaultTerminalApplicationV2._p(new DiskObserver(this.clientInterface)), TimeUtil.untilMidnight() / 1000L + 1L, 86400L, TimeUnit.SECONDS);
            FxEnvInit.setConnector(this.clientInterface);
            FxEnv.setPrimaryStage(stage);
            StartupData startupData = new StartupData();
            startupData.setScheduler(this.scheduler);
            startupData.setAdvStatHandler(ash);
            startupData.setGuiConfiguration(cnf.getGuiConfiguration());
            Context ep = ContextFactory.createContext("default");
            ep.run(startupData);
            this.log.info((Object)"-------------------------------------------------------------------------------");
            this.log.info((Object)"Run threads");
            for (Thread t : this.resources.getThreads()) {
                this.log.info((Object)("   " + t.getName()));
                t.start();
            }
            if (this.dsa != null) {
                this.log.info((Object)"Run player");
                try {
                    this.dsa.start();
                    this.log.info(this.sync);
                }
                catch (DiSigAppException ex) {
                    this.log.error((Object)"Error on start player", (Throwable)ex);
                }
            }
            if (!(events = sc.call()).isEmpty()) {
                this.clientInterface.sendEvent(events.toArray(new Event[events.size()]));
            }
            this.log.info((Object)"The application is running");
            this.log.info((Object)("Application startup: " + tm.getIntervalMsAsStr()));
            this.log.info((Object)"===============================================================================");
            this.appState = 2;
        }
        catch (FileUtilException ex) {
            this.showErrorScreen(ex, 3, stage);
        }
        catch (ApplicationException ex) {
            this.showErrorScreen(ex, ex.getLaunchError(), stage);
        }
        catch (ConnectorConfigurationException ex) {
            this.showErrorScreen(ex, 4, stage);
        }
        catch (ContextException ex) {
            this.showErrorScreen(ex, 0, stage);
        }
        catch (ConfigurationException ex) {
            this.showErrorScreen(ex, 2, stage);
        }
        catch (ConfigurationNotFoundException ex) {
            this.showErrorScreen(ex, 1, stage);
        }
        catch (Throwable ex) {
            this.showErrorScreen(ex, 0, stage);
        }
    }

    private void showErrorScreen(Throwable ex, int cause, Stage stage) {
        this.appState = 3;
        this.log.error((Object)"Error on startup", ex);
        this.log.info((Object)("Classpath: " + System.getProperty("java.class.path")));
        GuiNotifier.notifyErrorOnce((String)("Error on startup -> " + ex.getMessage()));
        try {
            if (this.executor == null) {
                this.executor = new ProcessExecutor();
                OsApi.getInstance().setExecutor(this.executor);
            }
            OsApi.getInstance().startEmergencyScript();
            Resolution resolution = ResolutionReader.process(stage, null);
            LaunchErrorScreen est = DefaultErrorFactory.createLaunchErrorScreen((Resolution)resolution, (String)SystemProp.getLockScreenPassword());
            est.setListener((ErrorScreenListener)new FailureListener());
            HashMap<String, String> data = new HashMap<String, String>();
            data.put("cause", Integer.toString(cause));
            data.put("trace", ExceptionUtils.getStackTrace((Throwable)ex));
            MessageProcessor.process((String)est.getTemplate().getDefaultBundle(), (Locale)Locale.getDefault(), (List)est.getTemplate().getElements(), data);
            Scene scene = new Scene((Parent)est.getTemplate().getPane(), (double)resolution.getWidth(), (double)resolution.getHeight());
            stage.setScene(scene);
            if (!stage.isShowing()) {
                stage.initStyle(StageStyle.UNDECORATED);
            }
            stage.show();
        }
        catch (Throwable th) {
            try {
                this.log.error((Object)"Can't create error screen,exit", th);
                Resolution resolution = ResolutionReader.process(stage, null);
                CrashScreenTemplate crashScreen = CrashScreenFactoty.createCrashScreen((Throwable)th, (ErrorScreenListener)new FailureListener(), (Resolution)resolution, (String)SystemProp.getLockScreenPassword());
                crashScreen.init();
                Scene scene = new Scene((Parent)crashScreen.getPane(), (double)resolution.getWidth(), (double)resolution.getHeight());
                stage.setScene(scene);
                stage.show();
            }
            catch (ScreenCreateException ex1) {
                this.log.error((Object)"Can't create crash screen,exit", (Throwable)ex1);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop(int code) {
        Object object = this.sync;
        synchronized (object) {
            if (this.appState != 2 && this.appState != 3) {
                throw new IllegalArgumentException("Current state " + this.appState);
            }
            this.appState = 4;
        }
        try {
            TimeMeter tm = new TimeMeter();
            this.log.info((Object)"===============================================================================");
            this.log.info((Object)("Stop application with code: " + code));
            for (Thread t2 : this.resources.getThreads()) {
                this.log.info((Object)("Stop thread: " + t2.getName()));
                t2.interrupt();
            }
            this.resources.getThreads().stream().forEach(t -> {
                try {
                    TimeMeter tm1 = new TimeMeter();
                    this.log.info((Object)("Waiting for completion: " + t.getName()));
                    t.join(1000L);
                    this.log.info((Object)("Completed: " + t.getName() + ", " + tm1.getIntervalMsAsStr()));
                }
                catch (InterruptedException ex) {
                    this.log.error((Object)("Error at the completion the thread " + t.getName() + ", " + ex.getMessage()));
                }
            });
            this.log.info((Object)"Stop scheduler");
            if (this.scheduler != null) {
                this.scheduler.shutdown();
            }
            this.log.info((Object)"Close storages");
            this.resources.getClosables().stream().forEach(cl -> cl.close());
            this.log.info((Object)"Close serializators");
            this.resources.getSerializators().stream().forEach(cl -> {
                try {
                    cl.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            });
            this.log.info((Object)"Stop disig");
            if (this.dsa != null) {
                this.dsa.stop();
            }
            this.log.info((Object)"Stop JavaFx platform");
            Platform.exit();
            this.log.info((Object)"Stop complete");
            this.log.info((Object)("Application shutdown: " + tm.getIntervalMsAsStr()));
            this.log.info((Object)"===============================================================================");
            this.appState = 5;
            System.exit(code);
        }
        catch (Throwable ex) {
            this.log.error((Object)"Error on stop application", ex);
        }
    }

    private void printEnvironmentInfo() throws SkinException {
        SkinProperties sp;
        ScreenProcessor.setExtractor((DataExtractor)new AppDataExtractor());
        OperatingSystemMXBean bean = (OperatingSystemMXBean)ManagementFactory.getOperatingSystemMXBean();
        this.log.info((Object)"Terminal environment:");
        this.log.info((Object)("   Software version      : " + DaemonVersion.version));
        this.log.info((Object)("   Hardware lib version  : " + Hardware.getVersion()));
        this.log.info((Object)("   Java version          : " + System.getProperty("java.version")));
        this.log.info((Object)("   JavaFx version        : " + System.getProperty("javafx.runtime.version")));
        this.log.info((Object)("   OS version            : " + System.getProperty("os.name") + " " + System.getProperty("os.version") + " " + System.getProperty("os.arch")));
        this.log.info((Object)("   Home dir              : " + PathUtils.getPath((String)"/")));
        this.log.info((Object)("   Max java memory       : " + Runtime.getRuntime().maxMemory() / 1024L / 1024L + " Mb"));
        this.log.info((Object)("   Total pc memory       : " + bean.getTotalPhysicalMemorySize() / 1024L / 1024L + " Mb"));
        this.log.info((Object)("   Total swap memory     : " + bean.getTotalSwapSpaceSize() / 1024L / 1024L + " Mb"));
        this.log.info((Object)("   Commlogic version     : " + SerialPort.getVersion() + "/" + SerialPort.getNativeVersion()));
        this.log.info((Object)" ");
        this.log.info((Object)"Read skin properties");
        SkinSet skinSet = Skin.getSkinSet();
        this.log.info((Object)("   Available skins: " + skinSet.getAvailable()));
        this.log.info((Object)("   Default skin name: " + skinSet.getPrimary()));
        String name = Optional.ofNullable(References.getMenu()).map(Menu::getIface).filter(Predicate.isEqual("").negate()).orElse(skinSet.getPrimary());
        this.log.info((Object)("   Skin name: " + name));
        try {
            sp = Skin.readProperties((String)name);
        }
        catch (Exception e) {
            this.log.error((Object)("Could not load skin properties for name: " + name + ". Try load default skin: " + skinSet.getPrimary()));
            sp = Skin.readProperties((String)skinSet.getPrimary());
        }
        this.log.info((Object)("   Skin version: " + sp.getVersion()));
        this.log.info((Object)("   Default resolution: " + sp.getDefaultResolution()));
        this.log.info((Object)" ");
        this.log.info((Object)"Display configuration:");
        if (Screen.getScreens() != null) {
            this.log.info((Object)("   Number of displays    : " + Screen.getScreens().size()));
            for (int i = 0; i < Screen.getScreens().size(); ++i) {
                Screen sc = (Screen)Screen.getScreens().get(i);
                this.log.info((Object)("      Display: " + i + ", bounds: " + sc.getBounds() + ", dpi: " + sc.getDpi()));
            }
        } else {
            this.log.info((Object)"   Not avaliable");
        }
        this.log.info((Object)" ");
        this.log.info((Object)"Read hardware serial numbers:");
        try {
            String hddSerial = SerialExtractorApi.getInstance().getHddSerial();
            this.log.info((Object)("   HDD                   : " + hddSerial));
            String processorName = SerialExtractorApi.getInstance().getProcessorName();
            this.log.info((Object)("   CPU                   : " + processorName));
        }
        catch (Throwable ex) {
            this.log.error((Object)("   An error occurred during read serials: " + ex.getMessage()));
        }
        this.log.info((Object)" ");
        this.log.info((Object)"Terminal identification:");
        Dealer d = References.getDealer();
        if (d != null) {
            this.log.info((Object)"   Dealer:");
            this.log.info((Object)("      Name               : " + d.getName()));
            this.log.info((Object)("      Inn                : " + d.getInn()));
            this.log.info((Object)("      Address            : " + d.getAddress()));
            this.log.info((Object)("      Support            : " + d.getSupport()));
        } else {
            this.log.info((Object)"   Information about dealer is not available");
        }
        Point p = References.getPoint();
        if (p != null) {
            this.log.info((Object)"   Point:");
            this.log.info((Object)("      Id                 : " + p.getId()));
            this.log.info((Object)("      Name               : " + p.getName()));
            this.log.info((Object)("      Address            : " + p.getAddress()));
            this.log.info((Object)("      City               : " + p.getCity()));
            this.log.info((Object)("      City code          : " + p.getCityCode()));
        } else {
            this.log.info((Object)"   Information about point is not available");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getState() {
        Object object = this.sync;
        synchronized (object) {
            return this.appState;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private KeyStore getKeyStore() {
        InputStream in = null;
        try {
            KeyStore ks = KeyStore.getInstance("JCEKS");
            in = DefaultTerminalApplicationV2.class.getResourceAsStream("keystore.jks");
            ks.load(in, "softlogic".toCharArray());
            KeyStore keyStore = ks;
            return keyStore;
        }
        catch (IOException | GeneralSecurityException exception) {
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
        }
        return null;
    }

    private void createConnector(ConConfiguration conConf, SetDataStore<Command> commandStore) throws ApplicationException, ConnectorConfigurationException {
        this.log.info((Object)"-------------------------------------------------------------------------------");
        this.log.info((Object)"Create server connector");
        if (conConf == null) {
            throw new ApplicationException(4, "Connector configuration is not found");
        }
        if (conConf.getProfiles() == null || conConf.getProfiles().length == 0) {
            throw new ApplicationException(4, "Server profiles are not found");
        }
        if (conConf.getSelected() == null || conConf.getSelected().isEmpty()) {
            throw new ApplicationException(4, "Active profile is not set");
        }
        ServerProfile selected = null;
        for (ServerProfile sp : conConf.getProfiles()) {
            if (!conConf.getSelected().equals(sp.getId())) continue;
            selected = sp;
            break;
        }
        if (selected == null) {
            throw new ApplicationException(4, "Active profile is not found");
        }
        this.log.info((Object)"Create a queue of pending packets");
        this.queue = new Queue(PathUtils.getPath((String)"/data//queue"), this.getKeyStore(), null);
        ProxyConfiguration proxy = NetworkUtils.convertProxy((Proxy)conConf.getProxy());
        this.log.info((Object)("Proxy settings: " + proxy));
        try {
            File keyDir = PathUtils.getFilePath((String)"/key/");
            ConnConfiguration conn = NetworkUtils.getConnConfiguration((ServerProfile)selected, (File)keyDir);
            this.serverInterface = ConnectorFactory.createConnector((ConnectorType)ConnectorType.WS, (ConnConfiguration)conn, (ProxyConfiguration)proxy, (long)SerialExtractorApi.getInstance().getConfigurationId(), (int)selected.getPointId(), (StateWatcher)new AppStateWatcher(), (ru.softlogic.srv.connector.Producer)new VersionProducer());
        }
        catch (IOException ex) {
            throw new ApplicationException(4, "Key not found " + ex.getMessage());
        }
        this.log.info((Object)"Create client connector");
        this.clientInterface = new ClientInterface(this.serverInterface, this.queue);
        this.log.info((Object)"Create queue agent");
        this.queueAgent = new QueueAgent(this.queue, commandStore, this.serverInterface);
        this.serverInterface.addRemoteStatusObserver((RemoteStatusObserver)this.queueAgent);
        this.serverInterface.addRefVersionObserver((RefVersionObserver)this.queueAgent);
        this.queue.addFinancialObserver(SafeReboot.getObserver());
        if (SystemProp.isQueueAgentEnable()) {
            this.resources.getThreads().add(new Thread((Runnable)this.queueAgent, "QueueAgentThread"));
        } else {
            this.log.info((Object)"Sending of packages is disabled");
        }
    }
}

