/*
 * Decompiled with CFR 0.152.
 */
package fxterm.app;

import fxterm.app.ApplicationStopper;
import fxterm.app.Commander;
import fxterm.app.DefaultTerminalApplicationV2;
import fxterm.app.id.LoggerId;
import java.io.File;
import java.net.URL;
import javafx.application.Application;
import javafx.event.EventHandler;
import javafx.stage.Stage;
import org.apache.log4j.PropertyConfigurator;
import ru.softlogic.hdw.Hardware;
import ru.softlogic.input.model.advanced.configuration.RuntimeConfiguration;
import ru.softlogic.input.model.advanced.configuration.SoftwareType;
import ru.softlogic.system.util.PathUtils;

public class CoreFx
extends Application {
    public void start(Stage stage) throws Exception {
        DefaultTerminalApplicationV2 application = new DefaultTerminalApplicationV2();
        RuntimeConfiguration rc = RuntimeConfiguration.getInstance();
        rc.setSoftwareType(SoftwareType.Terminal);
        rc.setHomePath(PathUtils.getAppHome());
        rc.setBinPath(PathUtils.getFilePath((String)"/bin/"));
        rc.setDsPath(PathUtils.getFilePath((String)"/res/module/input/ds/"));
        Hardware.setFirmwarePath((File)PathUtils.getFilePath((String)"/data/firmware/"));
        PropertyConfigurator.configure((URL)CoreFx.class.getResource("/fxterm/log4j.properties"));
        try {
            Commander commander = new Commander(application);
            commander.startServer();
        }
        catch (Exception ex) {
            System.out.println("Launched the second copy, exit");
            System.out.println("Reason: " + ex.getMessage());
            System.exit(15);
            return;
        }
        LoggerId.DEBUG.info((Object)("Classpath: " + System.getProperty("java.class.path")));
        application.start(stage);
        stage.setOnHidden((EventHandler)new ApplicationStopper(application));
    }

    public static void main(String[] args) {
        CoreFx.launch((String[])args);
    }
}

