/*
 * Decompiled with CFR 0.152.
 */
package fxterm.app;

import fxterm.app.ConfigurationException;
import fxterm.app.ConfigurationNotFoundException;
import fxterm.app.id.LoggerId;
import java.io.File;
import java.util.LinkedList;
import org.apache.log4j.Logger;
import ru.softlogic.config.ConfigurationIO;
import ru.softlogic.config.add.ConConfiguration;
import ru.softlogic.config.add.ConSection;
import ru.softlogic.config.add.GuiConfiguration;
import ru.softlogic.config.add.GuiSection;
import ru.softlogic.hdw.dev.barcode.BarConfiguration;
import ru.softlogic.hdw.dev.barcode.BarSection;
import ru.softlogic.hdw.dev.cashacc.BvrConfiguration;
import ru.softlogic.hdw.dev.cashacc.BvrSection;
import ru.softlogic.hdw.dev.cashacc.CvrConfiguration;
import ru.softlogic.hdw.dev.cashacc.CvrSection;
import ru.softlogic.hdw.dev.cashdisp.BdmSection;
import ru.softlogic.hdw.dev.cashdisp.CdmConfiguration;
import ru.softlogic.hdw.dev.cashdisp.CdmSection;
import ru.softlogic.hdw.dev.crd.CrdConfiguration;
import ru.softlogic.hdw.dev.crd.CrdSection;
import ru.softlogic.hdw.dev.cvd.CvdConfiguration;
import ru.softlogic.hdw.dev.cvd.CvdSection;
import ru.softlogic.hdw.dev.ioc.IocConfiguration;
import ru.softlogic.hdw.dev.ioc.IocSection;
import ru.softlogic.hdw.dev.modem.ModConfiguration;
import ru.softlogic.hdw.dev.modem.ModSection;
import ru.softlogic.hdw.dev.printer.PrtConfiguration;
import ru.softlogic.hdw.dev.printer.PrtSection;
import ru.softlogic.hdw.dev.sensors.SnrConfiguration;
import ru.softlogic.hdw.dev.sensors.SnrSection;
import ru.softlogic.hdw.dev.watchdog.WdtConfiguration;
import ru.softlogic.hdw.dev.watchdog.WdtSection;
import ru.softlogic.hdw.dev.webcam.WcmConfiguration;
import ru.softlogic.hdw.dev.webcam.WcmSection;

public class Configuration {
    private final File file;
    private final Logger log = LoggerId.START;
    private ConConfiguration conConfiguration;
    private BvrConfiguration bvrConfiguration;
    private CvrConfiguration cvrConfiguration;
    private CdmConfiguration bdmConfiguration;
    private CdmConfiguration cdmConfiguration;
    private CvdConfiguration cvdConfiguration;
    private BarConfiguration barConfiguration;
    private ModConfiguration modConfiguration;
    private GuiConfiguration guiConfiguration;
    private WdtConfiguration wdtConfiguration;
    private PrtConfiguration prtConfiguration;
    private CrdConfiguration crdConfiguration;
    private SnrConfiguration snrConfiguration;
    private IocConfiguration iocConfiguration;
    private WcmConfiguration wcmConfiguration;

    public Configuration(File file) {
        this.file = file;
    }

    public ConConfiguration getConConfiguration() {
        return this.conConfiguration;
    }

    public void setConConfiguration(ConConfiguration conConfiguration) {
        this.conConfiguration = conConfiguration;
    }

    public BvrConfiguration getBvrConfiguration() {
        return this.bvrConfiguration;
    }

    public void setBvrConfiguration(BvrConfiguration bvrConfiguration) {
        this.bvrConfiguration = bvrConfiguration;
    }

    public CvrConfiguration getCvrConfiguration() {
        return this.cvrConfiguration;
    }

    public void setCvrConfiguration(CvrConfiguration cvrConfiguration) {
        this.cvrConfiguration = cvrConfiguration;
    }

    public CdmConfiguration getBdmConfiguration() {
        return this.bdmConfiguration;
    }

    public void setBdmConfiguration(CdmConfiguration bdmConfiguration) {
        this.bdmConfiguration = bdmConfiguration;
    }

    public CdmConfiguration getCdmConfiguration() {
        return this.cdmConfiguration;
    }

    public void setCdmConfiguration(CdmConfiguration cdmConfiguration) {
        this.cdmConfiguration = cdmConfiguration;
    }

    public CvdConfiguration getCvdConfiguration() {
        return this.cvdConfiguration;
    }

    public void setCvdConfiguration(CvdConfiguration cvdConfiguration) {
        this.cvdConfiguration = cvdConfiguration;
    }

    public BarConfiguration getBarConfiguration() {
        return this.barConfiguration;
    }

    public void setBarConfiguration(BarConfiguration barConfiguration) {
        this.barConfiguration = barConfiguration;
    }

    public ModConfiguration getModConfiguration() {
        return this.modConfiguration;
    }

    public void setModConfiguration(ModConfiguration modConfiguration) {
        this.modConfiguration = modConfiguration;
    }

    public GuiConfiguration getGuiConfiguration() {
        return this.guiConfiguration;
    }

    public void setGuiConfiguration(GuiConfiguration guiConfiguration) {
        this.guiConfiguration = guiConfiguration;
    }

    public WdtConfiguration getWdtConfiguration() {
        return this.wdtConfiguration;
    }

    public void setWdtConfiguration(WdtConfiguration wdtConfiguration) {
        this.wdtConfiguration = wdtConfiguration;
    }

    public PrtConfiguration getPrtConfiguration() {
        return this.prtConfiguration;
    }

    public void setPrtConfiguration(PrtConfiguration prtConfiguration) {
        this.prtConfiguration = prtConfiguration;
    }

    public SnrConfiguration getSnrConfiguration() {
        return this.snrConfiguration;
    }

    public void setSnrConfiguration(SnrConfiguration snrConfiguration) {
        this.snrConfiguration = snrConfiguration;
    }

    public CrdConfiguration getCrdConfiguration() {
        return this.crdConfiguration;
    }

    public void setCrdConfiguration(CrdConfiguration crdConfiguration) {
        this.crdConfiguration = crdConfiguration;
    }

    public IocConfiguration getIocConfiguration() {
        return this.iocConfiguration;
    }

    public void setIocConfiguration(IocConfiguration iocConfiguration) {
        this.iocConfiguration = iocConfiguration;
    }

    public WcmConfiguration getWcmConfiguration() {
        return this.wcmConfiguration;
    }

    public void setWcmConfiguration(WcmConfiguration wcmConfiguration) {
        this.wcmConfiguration = wcmConfiguration;
    }

    public void read() throws ConfigurationNotFoundException, ConfigurationException {
        if (!this.file.canRead()) {
            throw new ConfigurationNotFoundException();
        }
        ConSection con = new ConSection();
        BvrSection bvr = new BvrSection();
        CvrSection cvr = new CvrSection();
        BdmSection bds = new BdmSection();
        CdmSection cds = new CdmSection();
        CvdSection cvd = new CvdSection();
        GuiSection gui = new GuiSection();
        BarSection bar = new BarSection();
        ModSection mod = new ModSection();
        WdtSection wdt = new WdtSection();
        PrtSection prt = new PrtSection();
        CrdSection crd = new CrdSection();
        SnrSection snr = new SnrSection();
        IocSection ioc = new IocSection();
        WcmSection wcm = new WcmSection();
        LinkedList<Object> secs = new LinkedList<Object>();
        secs.add(con);
        secs.add(bvr);
        secs.add(cvr);
        secs.add(bds);
        secs.add(cds);
        secs.add(cvd);
        secs.add(gui);
        secs.add(bar);
        secs.add(mod);
        secs.add(wdt);
        secs.add(prt);
        secs.add(crd);
        secs.add(snr);
        secs.add(ioc);
        secs.add(wcm);
        try {
            ConfigurationIO io = new ConfigurationIO(this.file, this.log);
            io.load(secs);
        }
        catch (Exception ex) {
            throw new ConfigurationException(ex);
        }
        this.conConfiguration = con.getConfiguration();
        this.bvrConfiguration = bvr.getConfiguration();
        this.cvrConfiguration = cvr.getConfiguration();
        this.bdmConfiguration = bds.getConfiguration();
        this.cdmConfiguration = cds.getConfiguration();
        this.cvdConfiguration = cvd.getConfiguration();
        this.guiConfiguration = gui.getConfiguration();
        this.barConfiguration = bar.getConfiguration();
        this.modConfiguration = mod.getConfiguration();
        this.wdtConfiguration = wdt.getConfiguration();
        this.prtConfiguration = prt.getConfiguration();
        this.crdConfiguration = crd.getConfiguration();
        this.snrConfiguration = snr.getConfiguration();
        this.iocConfiguration = ioc.getConfiguration();
        this.wcmConfiguration = wcm.getConfiguration();
    }
}

