/*
 * Decompiled with CFR 0.152.
 */
package fxterm.app;

import fxterm.app.ApplicationException;
import fxterm.app.TerminalApplication;
import fxterm.app.id.LoggerId;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.ServerSocket;
import java.net.Socket;
import java.nio.charset.StandardCharsets;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.Logger;
import ru.softlogic.system.util.ThreadUtil;

public class Commander {
    private static final int PORT = 10555;
    private static final String CMD_STOP = "stop";
    private final TerminalApplication application;
    private ServerSocket serverSocket;
    private static final Logger log = LoggerId.START;

    public Commander(TerminalApplication application) {
        this.application = application;
    }

    public void startServer() throws ApplicationException {
        try {
            this.serverSocket = new ServerSocket(10555);
            Thread th = new Thread((Runnable)new SocketListener(), "NetworkCommandListener");
            th.setDaemon(true);
            th.start();
        }
        catch (IOException ex) {
            throw new ApplicationException(0, "Can't connect to port 10555, " + ex.getMessage());
        }
    }

    public static void shutdown() throws ApplicationException {
        Socket socket = null;
        try {
            socket = new Socket("127.0.0.1", 10555);
            BufferedWriter bw = new BufferedWriter(new OutputStreamWriter(socket.getOutputStream(), StandardCharsets.UTF_8));
            bw.write("stop\n");
            bw.flush();
        }
        catch (IOException ex) {
            try {
                throw new ApplicationException(0, ex.getMessage());
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(socket);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Socket)socket);
    }

    private class SocketListener
    implements Runnable {
        private SocketListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            log.info((Object)"Start commander thread");
            while (!Thread.currentThread().isInterrupted()) {
                Socket socket;
                block9: {
                    socket = null;
                    try {
                        log.info((Object)"Wait connection");
                        socket = Commander.this.serverSocket.accept();
                        log.info((Object)"Connection accepted");
                        socket.setSoTimeout(10000);
                        BufferedReader br = new BufferedReader(new InputStreamReader(socket.getInputStream(), StandardCharsets.UTF_8));
                        BufferedWriter bw = new BufferedWriter(new OutputStreamWriter(socket.getOutputStream(), StandardCharsets.UTF_8));
                        String cmd = br.readLine();
                        if (cmd != null) {
                            if (cmd.equals(Commander.CMD_STOP)) {
                                bw.write("Stoping application");
                                log.info((Object)"Stoping application");
                                if (Commander.this.application != null) {
                                    Commander.this.application.stop(15);
                                }
                            } else {
                                log.error((Object)("Received unknown command: " + cmd));
                            }
                            break block9;
                        }
                        log.error((Object)"Error on reading data");
                    }
                    catch (IOException ex) {
                        try {
                            log.error((Object)ex);
                        }
                        catch (Throwable throwable) {
                            IOUtils.closeQuietly(socket);
                            throw throwable;
                        }
                        IOUtils.closeQuietly((Socket)socket);
                    }
                }
                IOUtils.closeQuietly((Socket)socket);
                ThreadUtil.sleep((long)1000L);
            }
            IOUtils.closeQuietly((ServerSocket)Commander.this.serverSocket);
            log.info((Object)"Stop commander thread");
        }
    }
}

