/*
 * Decompiled with CFR 0.152.
 */
package fxterm.app;

import fxterm.app.ProtectedRunnable;
import fxterm.app.id.LoggerId;
import fxterm.core.hdw.SrvSensorListener;
import java.util.List;
import org.apache.log4j.Appender;
import org.apache.log4j.DailyRollingFileAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;
import ru.softlogic.hdw.base.Device;
import ru.softlogic.hdw.dev.sensors.Sensor;
import ru.softlogic.hdw.dev.sensors.SensorsListener;
import ru.softlogic.io.Port;
import ru.softlogic.srv.api.status.DeviceStatus;
import ru.softlogic.srv.connector.ClientInterface;
import ru.softlogic.srv.connector.ws.stub.DeviceInfoStub;
import ru.softlogic.system.util.PathUtils;

public abstract class BaseDriverFactory {
    protected static final Logger log = LoggerId.START;

    protected static Logger createLogger(String name, String path, Level level) {
        Logger itemLogger = Logger.getLogger((String)name);
        itemLogger.setAdditivity(false);
        itemLogger.setLevel(level);
        DailyRollingFileAppender drfa = new DailyRollingFileAppender();
        drfa.setEncoding("UTF-8");
        drfa.setLayout((Layout)new PatternLayout("%d{ABSOLUTE} %5p [%t] %m%n"));
        drfa.setFile(PathUtils.getPath((String)("/log/" + path + ".log")));
        drfa.setDatePattern("'.'yyyy-MM-dd");
        drfa.activateOptions();
        itemLogger.addAppender((Appender)drfa);
        return itemLogger;
    }

    protected static Logger createLogger(String name, String path) {
        return BaseDriverFactory.createLogger(name, path, Level.INFO);
    }

    protected static void setSensorListener(Device device, ClientInterface clientInterface) {
        List sensors = device.getSensors();
        if (sensors != null) {
            log.info((Object)("Driver contains " + sensors.size() + " sensor(s)"));
            for (Sensor s : sensors) {
                s.addListener((SensorsListener)new SrvSensorListener(clientInterface));
            }
        }
    }

    protected static void onCreatingError(ClientInterface clientInterface, short deviceClass, String deviceType, Port port, Exception ex) {
        log.error((Object)"Error on creating driver", (Throwable)ex);
        DeviceInfoStub di = new DeviceInfoStub(Short.valueOf(deviceClass), deviceType);
        di.setPort(port != null ? port.asStr() : null);
        di.setInfo(ex.getMessage());
        clientInterface.send(di);
        clientInterface.sendStatus(new DeviceStatus(Short.valueOf(deviceClass), -1));
    }

    protected static Runnable _p(Runnable r) {
        return new ProtectedRunnable(r);
    }
}

