/*
 * Decompiled with CFR 0.152.
 */
package fxc.app.task.dev.prt;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.Locale;
import org.apache.log4j.Logger;
import ru.softlogic.hdw.DeviceClass;

public class TemplateExtractor {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String getImage(short deviceClass, String defIntTpl, String defIntLocale, Locale locale, Logger log) {
        String string;
        log.info((Object)("Build image for device-type: " + DeviceClass.asStr((short)deviceClass) + ", locale=" + locale));
        log.info((Object)"Try to use internal template");
        InputStream is = null;
        try {
            is = TemplateExtractor.getInternalTemplateStream(deviceClass, defIntTpl, locale, defIntLocale, log);
            log.info((Object)"Stream found");
            string = TemplateExtractor.toString(is);
        }
        catch (IOException ex1) {
            try {
                log.error((Object)"Error on process internal template: ", (Throwable)ex1);
            }
            catch (Throwable throwable) {
                TemplateExtractor.closeQuietly(is);
                throw throwable;
            }
            TemplateExtractor.closeQuietly(is);
            return "Wrong template";
        }
        TemplateExtractor.closeQuietly(is);
        return string;
    }

    protected static String getPathByType(short deviceClass) {
        switch (deviceClass) {
            case 1: {
                return "/i18n/docs/ipp/";
            }
            case 2: {
                return "/i18n/docs/kkm/";
            }
        }
        return "/i18n/docs/pos/";
    }

    protected static InputStream getInternalTemplateStream(short deviceClass, String name, Locale locale, String defResource, Logger log) throws IOException {
        log.info((Object)("Try to use internal template=" + name));
        InputStream is = TemplateExtractor.getStreamFromJar(TemplateExtractor.getPathByType(deviceClass) + name, Locale.getDefault(), defResource, log);
        if (is == null) {
            throw new IOException("Internal template is not found");
        }
        return is;
    }

    protected static InputStream getStreamFromJar(String path, Locale locale, String defResource, Logger log) {
        if (path == null || locale == null) {
            return null;
        }
        String res = path.replace("{0}", "_" + locale.getLanguage() + "_" + locale.getCountry());
        log.info((Object)("Lookup stream: " + res));
        InputStream is = TemplateExtractor.class.getResourceAsStream(res);
        if (is == null) {
            res = path.replace("{0}", "_" + locale.getLanguage());
            log.info((Object)("Lookup stream: " + res));
            is = TemplateExtractor.class.getResourceAsStream(res);
            if (is == null) {
                res = path.replace("{0}", defResource);
                log.info((Object)("Lookup stream: " + res));
                is = TemplateExtractor.class.getResourceAsStream(res);
            }
        }
        return is;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String toString(InputStream is) throws IOException {
        String string;
        BufferedReader br = null;
        StringBuilder sb = new StringBuilder();
        try {
            String line;
            br = new BufferedReader(new InputStreamReader(is, StandardCharsets.UTF_8));
            while ((line = br.readLine()) != null) {
                sb.append(line).append("\n");
            }
            string = sb.toString();
        }
        catch (Throwable throwable) {
            TemplateExtractor.closeQuietly(br);
            throw throwable;
        }
        TemplateExtractor.closeQuietly(br);
        return string;
    }

    private static void closeQuietly(Closeable is) {
        if (is != null) {
            try {
                is.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

