/*
 * Decompiled with CFR 0.152.
 */
package fxc.app.task.dev.prt;

import fxc.app.Configurator;
import fxc.app.task.dev.DeviceTestTask;
import fxc.app.task.dev.prt.SimpleTextJob;
import java.util.List;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import org.apache.log4j.Logger;
import ru.softlogic.hdw.CreatingException;
import ru.softlogic.hdw.dev.printer.PrintSpooler;
import ru.softlogic.hdw.dev.printer.PrinterFactory;
import ru.softlogic.hdw.dev.printer.PrtConfiguration;
import ru.softlogic.hdw.dev.printer.spooler.PrintSpoolerDriver;
import ru.softlogic.hdw.dev.printer.spooler.PrinterJob;
import ru.softlogic.hdw.handling.DeviceInfoListener;
import ru.softlogic.hdw.handling.DeviceStateListener;

public class PrinterTestTask
extends DeviceTestTask {
    private final PrtConfiguration prnConf;
    private List<Thread> threads;
    private PrintSpooler spooler;

    public PrinterTestTask(Configurator conf, PrtConfiguration prnConf) {
        super(conf);
        this.prnConf = prnConf;
    }

    @Override
    protected List<Thread> getThreads() {
        return this.threads;
    }

    @Override
    public Object process() throws InterruptedException {
        try {
            PrintSpoolerDriver psd = PrinterFactory.creatDriver((PrtConfiguration)this.prnConf, (Logger)this.getDeviceLogger());
            this.threads = psd.getThreads();
            this.spooler = psd.getPrintSpooler();
            this.spooler.addDeviceInfoListener((DeviceInfoListener)this);
            this.spooler.addStateListener((DeviceStateListener)this);
            this.threads.forEach(Thread::start);
            this.waitForCancel();
        }
        catch (CreatingException ex) {
            return ex;
        }
        return null;
    }

    @Override
    protected EventHandler<ActionEvent> getRunEventHandler() {
        return event -> {
            if (this.spooler != null) {
                this.spooler.print((PrinterJob)new SimpleTextJob(this.getDeviceLogger()));
            }
        };
    }
}

