/*
 * Decompiled with CFR 0.152.
 */
package fxc.app.task.dev.cvd;

import fxc.app.Configurator;
import fxc.app.task.dev.DeviceTestTask;
import java.util.List;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import org.apache.log4j.Logger;
import ru.softlogic.hdw.CreatingException;
import ru.softlogic.hdw.dev.cvd.CardDispenser;
import ru.softlogic.hdw.dev.cvd.CardDispenserDriver;
import ru.softlogic.hdw.dev.cvd.CardDispenserFactory;
import ru.softlogic.hdw.dev.cvd.CvdOptions;
import ru.softlogic.hdw.dev.cvd.DispenseException;
import ru.softlogic.hdw.dev.cvd.DispenseOperation;
import ru.softlogic.hdw.dev.cvd.OnlyDispenseOperation;
import ru.softlogic.hdw.handling.DeviceInfoListener;
import ru.softlogic.hdw.handling.DeviceStateListener;
import ru.softlogic.io.serial.SerialPort;

public class CvdTestTask
extends DeviceTestTask {
    private final String type;
    private final SerialPort port;
    private final CvdOptions options;
    private List<Thread> threads;
    private CardDispenser dispenser;

    public CvdTestTask(Configurator conf, String type, SerialPort port, CvdOptions options) {
        super(conf);
        this.type = type;
        this.port = port;
        this.options = options;
    }

    @Override
    protected List<Thread> getThreads() {
        return this.threads;
    }

    @Override
    protected EventHandler<ActionEvent> getRunEventHandler() {
        return event -> {
            if (this.dispenser != null) {
                try {
                    this.dispenser.dispense((DispenseOperation)new OnlyDispenseOperation());
                }
                catch (DispenseException dispenseException) {
                    // empty catch block
                }
            }
        };
    }

    @Override
    public Object process() throws InterruptedException {
        try {
            CardDispenserDriver drv = CardDispenserFactory.createDriver((String)this.type, (SerialPort)this.port, (CvdOptions)this.options, (Logger)this.getDeviceLogger());
            this.threads = drv.getThreads();
            this.dispenser = drv.getCardDispenser();
            this.dispenser.addDeviceInfoListener((DeviceInfoListener)this);
            this.dispenser.addStateListener((DeviceStateListener)this);
            this.threads.forEach(Thread::start);
            this.waitForCancel();
        }
        catch (CreatingException ex) {
            return ex;
        }
        return null;
    }
}

