/*
 * Decompiled with CFR 0.152.
 */
package fxc.app.task.dev.bvr;

import fxc.app.Configurator;
import fxc.app.gui.oth.Dialog;
import fxc.app.res.LoggerId;
import fxc.app.res.ResourceId;
import fxc.app.task.dev.DeviceTestTask;
import java.text.MessageFormat;
import java.util.List;
import java.util.stream.Collectors;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import org.apache.log4j.Logger;
import ru.softlogic.hardware.currency.Cash;
import ru.softlogic.hardware.currency.Denomination;
import ru.softlogic.hardware.currency.Sum;
import ru.softlogic.hardware.currency.SumFormatter;
import ru.softlogic.hdw.CreatingException;
import ru.softlogic.hdw.DeviceId;
import ru.softlogic.hdw.dev.cashacc.CashAcceptorDevice;
import ru.softlogic.hdw.dev.cashacc.CashAcceptorDriver;
import ru.softlogic.hdw.dev.cashacc.CashInOperation;
import ru.softlogic.hdw.dev.cashacc.CashInOperationListener;
import ru.softlogic.hdw.dev.cashacc.EventListener;
import ru.softlogic.hdw.handling.DeviceInfo;
import ru.softlogic.hdw.handling.DeviceInfoListener;
import ru.softlogic.hdw.handling.DeviceStateListener;
import ru.softlogic.hdw.handling.HdwMsg;

public abstract class CashAccTestTask
extends DeviceTestTask {
    private final Configurator conf;
    private List<Thread> threads;
    private CashAcceptorDevice dev;
    private final Logger log = LoggerId.LOG;
    private boolean addCash;

    public CashAccTestTask(Configurator conf) {
        super(conf);
        this.conf = conf;
    }

    @Override
    public Object process() throws InterruptedException {
        this.log.info((Object)"Try to create driver");
        try {
            CashAcceptorDriver drv = this.create();
            this.threads = drv.getThreads();
            this.dev = drv.getCashAcceptor();
            this.dev.addDeviceInfoListener((DeviceInfoListener)this);
            this.dev.addDeviceInfoListener((DeviceInfoListener)new CurrencyListener());
            this.dev.addStateListener((DeviceStateListener)this);
            this.dev.addEventListener((EventListener)new LocalEventListener());
            this.threads.forEach(Thread::start);
            this.waitForCancel();
        }
        catch (CreatingException ex) {
            return ex;
        }
        return null;
    }

    @Override
    protected void beforeCancel() {
        try {
            if (this.dev != null && this.dev.isEnabled()) {
                this.dev.disable();
                this.dev.waitSafeState();
                Thread.sleep(200L);
            }
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
        }
    }

    @Override
    protected List<Thread> getThreads() {
        return this.threads;
    }

    @Override
    protected void _onResult(Object object) {
        super._onResult(object);
        if (object instanceof Exception) {
            Exception ex = (Exception)object;
            this.conf.showDialog(new Dialog(ResourceId.BUNDLE.getString("dialog.title.error"), MessageFormat.format(ResourceId.BUNDLE.getString("bvr.test.error"), ex.getMessage()), ResourceId.BUNDLE.getString("dialog.btn.ok")), null);
        } else if (this.addCash) {
            this.conf.showDialog(new Dialog(ResourceId.BUNDLE.getString("dialog.title.info"), ResourceId.BUNDLE.getString("bvr.test.remove_cash"), ResourceId.BUNDLE.getString("dialog.btn.ok")), null);
        }
    }

    @Override
    protected EventHandler<ActionEvent> getRunEventHandler() {
        return event -> {
            if (this.dev != null && !this.dev.isEnabled()) {
                this.dev.enable((CashInOperation)new TestCashInOperation());
            }
        };
    }

    @Override
    protected boolean isEventsVisible() {
        return true;
    }

    protected abstract CashAcceptorDriver create() throws CreatingException;

    private class CurrencyListener
    implements DeviceInfoListener {
        private CurrencyListener() {
        }

        public void onDeviceInfo(DeviceInfo di) {
            CashAccTestTask.this.addEvent(ResourceId.BUNDLE.getString("bvr.test.curr") + CashAccTestTask.this.dev.getCurrencies());
            CashAccTestTask.this.addEvent(ResourceId.BUNDLE.getString("bvr.test.den") + CashAccTestTask.this.dev.getDenominations().stream().map(d -> SumFormatter.asStr((Denomination)d)).collect(Collectors.toList()));
        }
    }

    private class LocalEventListener
    implements EventListener {
        private LocalEventListener() {
        }

        public void onEvent(int i) {
            CashAccTestTask.this.addEvent(HdwMsg.getBvrEvent((int)i));
        }
    }

    private class TestCashInOperation
    implements CashInOperation {
        private TestCashInOperation() {
        }

        public String getCurrency() {
            return Cash.getSystemCurrency();
        }

        public Sum getAllowedSum() {
            return new Sum(100000, Cash.getSystemCurrency());
        }

        public boolean canAccept(DeviceId di, Denomination dnmntn) {
            return true;
        }

        public boolean isStrongVerify(Denomination dnmntn) {
            return false;
        }

        public void onAccept(DeviceId di, Denomination dnmntn) {
            CashAccTestTask.this.addCash = true;
            CashAccTestTask.this.addEvent(">> >> >> " + SumFormatter.asStr((Denomination)dnmntn));
        }

        public void onFraudMarker(int i) {
        }

        public void addOperationListener(CashInOperationListener cl) {
        }

        public void removeOperationListener(CashInOperationListener cl) {
        }

        public String getToken() {
            return "Device testing";
        }
    }
}

