/*
 * Decompiled with CFR 0.152.
 */
package fxc.app.task.dev;

import fxc.app.task.dev.LogArea;
import fxc.app.task.dev.ViewAppenderListener;
import java.util.LinkedList;
import java.util.List;
import javafx.application.Platform;

public class LogListener
implements ViewAppenderListener {
    private int lineCount;
    private List<String> buffer;
    private LogArea logArea;
    private int remove;

    public LogListener(LogArea logArea, int lineCount) {
        if (logArea == null) {
            throw new IllegalArgumentException("LogArea is null");
        }
        this.logArea = logArea;
        this.buffer = new LinkedList<String>();
        this.buffer.add("Start viewer\n");
        this.lineCount = lineCount;
    }

    @Override
    public synchronized void onLine(String string) {
        this.buffer.add(string);
        this.remove = -1;
        if (this.buffer.size() > this.lineCount) {
            this.remove = this.buffer.remove(0).length();
        }
        Platform.runLater(() -> {
            if (this.remove > 0) {
                this.logArea.remove(this.remove);
            }
            this.logArea.append(string);
        });
    }

    public synchronized void clear() {
        this.buffer.clear();
        this.logArea.clear();
    }
}

