/*
 * Decompiled with CFR 0.152.
 */
package fxc.app.task.dev;

import fxc.app.Configurator;
import fxc.app.task.dev.DeviceTestTask;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import org.apache.log4j.Logger;
import ru.softlogic.hdw.CreatingException;
import ru.softlogic.hdw.dev.ioc.IOController;
import ru.softlogic.hdw.dev.ioc.IOControllerDriver;
import ru.softlogic.hdw.dev.ioc.IOControllerException;
import ru.softlogic.hdw.dev.ioc.IOControllerFactory;
import ru.softlogic.hdw.dev.ioc.LineState;
import ru.softlogic.hdw.handling.DeviceInfoListener;
import ru.softlogic.hdw.handling.DeviceStateListener;
import ru.softlogic.io.serial.SerialPort;

public class IOCTestTask
extends DeviceTestTask
implements Runnable {
    private final String type;
    private final SerialPort port;
    private List<Thread> threads;
    private IOController device;
    private final BlockingQueue<Command> queue = new LinkedBlockingQueue<Command>();

    public IOCTestTask(Configurator conf, String type, SerialPort port) {
        super(conf);
        this.type = type;
        this.port = port;
    }

    @Override
    protected List<Thread> getThreads() {
        return this.threads;
    }

    @Override
    protected EventHandler<ActionEvent> getRunEventHandler() {
        return null;
    }

    @Override
    public Object process() throws InterruptedException {
        try {
            IOControllerDriver drv = IOControllerFactory.createDriver((String)this.type, (SerialPort)this.port, (Logger)this.getDeviceLogger());
            this.threads = drv.getThreads();
            this.device = drv.getIOController();
            this.device.addDeviceInfoListener((DeviceInfoListener)this);
            this.device.addStateListener((DeviceStateListener)this);
            this.threads.add(new Thread(this));
            this.threads.forEach(Thread::start);
            this.waitForCancel();
        }
        catch (CreatingException ex) {
            return ex;
        }
        return null;
    }

    @Override
    public void run() {
        try {
            while (!Thread.currentThread().isInterrupted()) {
                Command cmd = this.queue.take();
                try {
                    this.device.setOutputStatus(cmd.getLine(), cmd.getState());
                }
                catch (IOControllerException iOControllerException) {
                    // empty catch block
                }
                Thread.sleep(cmd.getSleep());
            }
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
        }
    }

    private class Command {
        private final int line;
        private final LineState state;
        private final int sleep;

        public Command(int line, LineState state, int sleep) {
            this.line = line;
            this.state = state;
            this.sleep = sleep;
        }

        public int getLine() {
            return this.line;
        }

        public LineState getState() {
            return this.state;
        }

        public int getSleep() {
            return this.sleep;
        }
    }
}

