/*
 * Decompiled with CFR 0.152.
 */
package fxc.app.task.dev;

import fxc.app.Configurator;
import fxc.app.gui.oth.DeviceTestDialog;
import fxc.app.gui.oth.Dialog;
import fxc.app.res.LoggerId;
import fxc.app.res.ResourceId;
import fxc.app.task.GuiTask;
import fxc.app.task.dev.LogArea;
import fxc.app.task.dev.LogListener;
import fxc.app.task.dev.TextLogArea;
import fxc.app.task.dev.ViewAppender;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.List;
import javafx.application.Platform;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXMLLoader;
import javafx.scene.layout.Pane;
import org.apache.log4j.Appender;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;
import ru.softlogic.hdw.handling.DeviceInfo;
import ru.softlogic.hdw.handling.DeviceInfoListener;
import ru.softlogic.hdw.handling.DeviceState;
import ru.softlogic.hdw.handling.DeviceStateListener;
import ru.softlogic.hdw.handling.HdwMsg;

public abstract class DeviceTestTask
extends GuiTask
implements EventHandler<ActionEvent>,
DeviceInfoListener,
DeviceStateListener {
    private static Pane test;
    private static DeviceTestDialog dialog;
    private static LogArea area;
    private static ViewAppender viewAppender;
    private final Configurator conf;
    private final Logger log;
    private static final Logger devLog;
    private boolean fSync = false;
    private final Object oSync = new Object();

    public DeviceTestTask(Configurator conf) {
        this.conf = conf;
        this.log = LoggerId.LOG;
    }

    @Override
    protected void _onResult(Object object) {
        this.log.info((Object)("Task complete with result: " + object));
        if (test != null) {
            this.conf.getGui().clearPopup(test);
        }
        if (object != null && object instanceof Exception) {
            Exception ex = (Exception)object;
            this.log.error((Object)ex, (Throwable)ex);
            this.conf.showDialog(new Dialog(ResourceId.BUNDLE.getString("dialog.title.error"), MessageFormat.format(ResourceId.BUNDLE.getString("dev_test.error.create"), ex.getMessage()), ResourceId.BUNDLE.getString("dialog.btn.ok")), null);
        }
    }

    @Override
    protected void _onPreExecute() {
        area.clear();
        if (test != null) {
            dialog.getCancel().setOnAction((EventHandler)this);
            EventHandler<ActionEvent> runHandler = this.getRunEventHandler();
            dialog.getRun().setDisable(runHandler == null);
            if (runHandler != null) {
                dialog.getRun().setOnAction(runHandler);
            }
            dialog.getRun().setDisable(true);
            dialog.getEvents().getItems().clear();
            dialog.getEvents().setVisible(this.isEventsVisible());
            this.conf.getGui().openPopup(test);
        }
    }

    public DeviceTestDialog getDialog() {
        return dialog;
    }

    public void handle(ActionEvent event) {
        this.onCancel();
    }

    protected Logger getDeviceLogger() {
        return devLog;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void waitForCancel() throws InterruptedException {
        Object object = this.oSync;
        synchronized (object) {
            if (!this.fSync) {
                this.oSync.wait();
            } else {
                this.fSync = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onCancel() {
        this.log.info((Object)"Stop threads");
        this.beforeCancel();
        List<Thread> threads = this.getThreads();
        threads.forEach(Thread::interrupt);
        threads.stream().forEach(t -> {
            try {
                t.join(1000L);
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
                this.log.error((Object)("Error at the completion the thread " + t.getName() + ", " + ex.getMessage()));
            }
        });
        Object object = this.oSync;
        synchronized (object) {
            this.fSync = true;
            this.oSync.notifyAll();
        }
        this.log.info((Object)"Done");
    }

    protected void beforeCancel() {
    }

    public void onDeviceInfo(DeviceInfo di) {
        Platform.runLater(() -> {
            dialog.getVendor().setText(this.getValue(di.getVendor()));
            dialog.getModel().setText(this.getValue(di.getModel()));
            dialog.getFirmware().setText(this.getValue(di.getFirmware()));
            dialog.getDriver().setText(this.getValue(di.getDriver()));
        });
    }

    public void onState(DeviceState ds) {
        Platform.runLater(() -> {
            dialog.getState().setText(HdwMsg.getState((DeviceState)ds));
            dialog.getRun().setDisable(!ds.isOk());
        });
    }

    protected abstract List<Thread> getThreads();

    protected abstract EventHandler<ActionEvent> getRunEventHandler();

    protected boolean isEventsVisible() {
        return false;
    }

    protected void addEvent(String event) {
        Platform.runLater(() -> {
            ObservableList list = dialog.getEvents().getItems();
            if (list.size() > 7) {
                list.remove(0);
            }
            dialog.getEvents().getItems().add((Object)event);
            dialog.getEvents().scrollTo(dialog.getEvents().getItems().size() - 1);
        });
    }

    private static synchronized Logger createLogger(String name) {
        Logger itemLogger = Logger.getLogger((String)name);
        itemLogger.setAdditivity(false);
        itemLogger.setLevel(Level.INFO);
        viewAppender = new ViewAppender();
        viewAppender.setLayout((Layout)new PatternLayout("%m%n"));
        itemLogger.addAppender((Appender)viewAppender);
        itemLogger.addAppender(Logger.getLogger((String)"conf").getAppender("conf"));
        return itemLogger;
    }

    private static synchronized void createEnv() {
        try {
            FXMLLoader l = new FXMLLoader(DeviceTestTask.class.getResource("/fxc/pane/popup/device_test.fxml"), ResourceId.BUNDLE);
            test = (Pane)l.load();
            dialog = (DeviceTestDialog)l.getController();
            area = new TextLogArea(dialog.getTextArea());
            viewAppender.addListener(new LogListener(area, 500));
        }
        catch (IOException ex) {
            LoggerId.LOG.error((Object)"Error on creating screen", (Throwable)ex);
        }
    }

    private String getValue(String val) {
        return val == null || val.isEmpty() ? ResourceId.BUNDLE.getString("dev_test.info.na") : val;
    }

    static {
        devLog = DeviceTestTask.createLogger("dev");
        DeviceTestTask.createEnv();
    }
}

