/*
 * Decompiled with CFR 0.152.
 */
package fxc.app.task.dev;

import fxc.app.Configurator;
import fxc.app.gui.oth.Dialog;
import fxc.app.res.LoggerId;
import fxc.app.res.ResourceId;
import fxc.app.task.dev.DeviceTestTask;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.List;
import java.util.Map;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import org.apache.log4j.Logger;
import ru.softlogic.hardware.currency.Denomination;
import ru.softlogic.hardware.currency.Sum;
import ru.softlogic.hardware.currency.SumFormatter;
import ru.softlogic.hardware.currency.set.DenominationSet;
import ru.softlogic.hdw.CreatingException;
import ru.softlogic.hdw.dev.cashdisp.CashDispenser;
import ru.softlogic.hdw.dev.cashdisp.CashDispenserDriver;
import ru.softlogic.hdw.dev.cashdisp.CashDispenserFactory;
import ru.softlogic.hdw.dev.cashdisp.CdmOptions;
import ru.softlogic.hdw.dev.cashdisp.OperationDispenseResult;
import ru.softlogic.hdw.dev.cashdisp.OperationListener;
import ru.softlogic.hdw.handling.DeviceInfo;
import ru.softlogic.hdw.handling.DeviceInfoListener;
import ru.softlogic.hdw.handling.DeviceStateListener;
import ru.softlogic.io.serial.SerialPort;

public class BillDispTestTask
extends DeviceTestTask {
    private final Configurator conf;
    private List<Thread> threads;
    private CashDispenser dev;
    private final Logger log = LoggerId.LOG;
    private final String type;
    private final SerialPort port;
    private final CdmOptions bdsOptions;

    public BillDispTestTask(Configurator conf, String type, SerialPort port, CdmOptions bdsOptions) {
        super(conf);
        this.conf = conf;
        this.type = type;
        this.port = port;
        this.bdsOptions = bdsOptions;
    }

    private CashDispenserDriver create() throws CreatingException, IOException {
        return CashDispenserFactory.createBillDriver((String)this.type, (SerialPort)this.port, (File)File.createTempFile("tempfile", ".tmp"), (Logger)this.getDeviceLogger());
    }

    @Override
    public Object process() throws InterruptedException {
        this.log.info((Object)"Try to create driver");
        try {
            CashDispenserDriver drv = this.create();
            this.threads = drv.getThreads();
            this.dev = drv.getDispenser();
            this.dev.addDeviceInfoListener((DeviceInfoListener)this);
            this.dev.addDeviceInfoListener((DeviceInfoListener)new DeviceListener());
            this.dev.addStateListener((DeviceStateListener)this);
            this.threads.forEach(Thread::start);
            this.waitForCancel();
        }
        catch (IOException | CreatingException ex) {
            return ex;
        }
        return null;
    }

    @Override
    protected void beforeCancel() {
    }

    @Override
    protected List<Thread> getThreads() {
        return this.threads;
    }

    @Override
    protected void _onResult(Object object) {
        super._onResult(object);
        if (object instanceof Exception) {
            Exception ex = (Exception)object;
            this.conf.showDialog(new Dialog(ResourceId.BUNDLE.getString("dialog.title.error"), MessageFormat.format(ResourceId.BUNDLE.getString("cdm.test.error"), ex.getMessage()), ResourceId.BUNDLE.getString("dialog.btn.ok")), null);
        }
    }

    @Override
    protected EventHandler<ActionEvent> getRunEventHandler() {
        return event -> {};
    }

    @Override
    protected boolean isEventsVisible() {
        return true;
    }

    private static final class DeviceListener
    implements DeviceInfoListener {
        private DeviceListener() {
        }

        public void onDeviceInfo(DeviceInfo di) {
        }
    }

    private class Listener
    implements OperationListener {
        private Listener() {
        }

        public void onProgress(List<Sum> sums) {
            BillDispTestTask.this.addEvent("progress: " + sums);
        }

        public void onResult(OperationDispenseResult odr) {
            this.printIssue(odr.getTotals());
        }

        public void onError() {
            BillDispTestTask.this.addEvent("Error");
        }

        private void printIssue(DenominationSet ds) {
            if (ds.isEmpty()) {
                BillDispTestTask.this.addEvent(ResourceId.BUNDLE.getString("cdm.test.empty"));
                return;
            }
            StringBuilder sb = new StringBuilder(ResourceId.BUNDLE.getString("cdm.test.issue")).append("\n");
            for (Map.Entry entry : ds.getCounts().entrySet()) {
                sb.append(String.format("%1$10s", SumFormatter.asStr((Denomination)((Denomination)entry.getKey())))).append("\t\t").append(entry.getValue());
                if ((Integer)entry.getValue() == 1) {
                    sb.append(ResourceId.BUNDLE.getString("cdm.test.pc")).append("\n");
                    continue;
                }
                sb.append(ResourceId.BUNDLE.getString("cdm.test.pcs")).append("\n");
            }
            BillDispTestTask.this.addEvent(sb.toString());
        }

        public void onPrepareError() {
            BillDispTestTask.this.addEvent("onPrepareError");
        }
    }
}

