/*
 * Decompiled with CFR 0.152.
 */
package fxc.app.key;

import fxc.app.key.KeyParser;
import fxc.app.key.TerminalKey;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.commons.io.FileUtils;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;
import ru.softlogic.srv.utils.NetworkUtils;
import ru.softlogic.system.util.PathUtils;

public class TerminalKeyUtils {
    private static XMLReader reader;

    private TerminalKeyUtils() {
    }

    public static synchronized TerminalKey load(File file, boolean extractValues) throws Exception {
        if (reader == null) {
            SAXParserFactory spf = SAXParserFactory.newInstance();
            SAXParser saxParser = spf.newSAXParser();
            reader = saxParser.getXMLReader();
        }
        KeyParser kp = new KeyParser(extractValues);
        reader.setContentHandler(kp);
        try (BufferedReader r = Files.newBufferedReader(file.toPath(), Charset.forName("utf-8"));){
            reader.parse(new InputSource(r));
        }
        return kp.getKey();
    }

    public static void save(TerminalKey key) throws IOException {
        String keyPath = PathUtils.getPath((String)"/key/");
        new File(keyPath).mkdirs();
        String unique = NetworkUtils.buildTerminalKeyName((String)key.getHost(), (int)key.getHttpsPort(), (int)key.getPoint());
        String privName = unique + "_private.key";
        String pubName = unique + "_public.key";
        FileUtils.write((File)new File(keyPath, privName), (CharSequence)key.getPrivateTerminalKey().trim().replaceAll(" +", ""));
        FileUtils.write((File)new File(keyPath, pubName), (CharSequence)key.getPublicServerKey().trim().replaceAll(" +", ""));
    }

    public static File[] getRoots() {
        String osName = System.getProperty("os.name");
        if (osName != null) {
            if (osName.toLowerCase().contains("linux")) {
                LinkedList<File> files = new LinkedList<File>();
                File f = new File("/run/media/terminal/");
                if (f.isDirectory()) {
                    files.addAll(Arrays.asList(f.listFiles()));
                }
                if ((f = new File("/media/")).isDirectory()) {
                    files.addAll(Arrays.asList(f.listFiles()));
                }
                return files.toArray(new File[files.size()]);
            }
            if (osName.toLowerCase().contains("windows")) {
                return File.listRoots();
            }
        }
        return new File[0];
    }

    private static List<File> processPath(List<File> dirs, File path, String type, String ... relativePaths) {
        ArrayList<File> fileList = new ArrayList<File>();
        dirs.add(path);
        File[] files = path.listFiles();
        if (files != null) {
            for (File f : files) {
                if (!f.canRead() || !f.getAbsolutePath().endsWith(type)) continue;
                fileList.add(f);
            }
            for (String dirPath : relativePaths) {
                File k = new File(path, dirPath);
                dirs.add(k);
                if (!k.isDirectory()) continue;
                for (File f : k.listFiles()) {
                    if (!f.canRead() || !f.getAbsolutePath().endsWith(type)) continue;
                    fileList.add(f);
                }
            }
        }
        return fileList;
    }

    public static List<File> searchFileByType(List<File> dirs, String type, String ... relativePaths) {
        ArrayList<File> fileList = new ArrayList<File>();
        for (File f : TerminalKeyUtils.getRoots()) {
            fileList.addAll(TerminalKeyUtils.processPath(dirs, f, type, relativePaths));
        }
        fileList.addAll(TerminalKeyUtils.processPath(dirs, new File("."), type, relativePaths));
        return fileList;
    }
}

