/*
 * Decompiled with CFR 0.152.
 */
package fxc.app.key;

import fxc.app.Configurator;
import fxc.app.gui.Gui;
import fxc.app.gui.oth.Dialog;
import fxc.app.gui.oth.ServerSelectScreen;
import fxc.app.key.SrvUrlLocation;
import fxc.app.key.TerminalKeyUtils;
import fxc.app.res.ResourceId;
import fxc.app.task.WaitTask;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import java.util.stream.Collectors;
import javafx.scene.layout.Pane;

public class SearchServersUrl
extends WaitTask {
    private final List<SrvUrlLocation> keys = new LinkedList<SrvUrlLocation>();
    private final List<File> dirs = new LinkedList<File>();
    private final Configurator conf;
    private final SearchServerslListener listener;

    public SearchServersUrl(Configurator conf, SearchServerslListener listener) {
        super(conf);
        this.conf = conf;
        this.listener = listener;
    }

    @Override
    protected void _onResult(Object object) {
        super._onResult(object);
        Gui g = this.conf.getGui();
        if (!this.keys.isEmpty()) {
            ServerSelectScreen kss = g.getServerSelectScreen();
            kss.update(this.keys, new SelectListener(g, kss.getPane()));
            g.openPopup(kss.getPane());
        } else {
            String paths = this.dirs.stream().map(File::getAbsolutePath).map(str -> str.replace("\\.", "").replace("/.", "")).collect(Collectors.joining(", "));
            this.conf.showDialog(new Dialog(ResourceId.BUNDLE.getString("dialog.title.gen"), MessageFormat.format(ResourceId.BUNDLE.getString("dialog.gen.paths"), paths), ResourceId.BUNDLE.getString("dialog.btn.ok")), null);
        }
    }

    @Override
    public Object process() {
        for (File f : TerminalKeyUtils.searchFileByType(this.dirs, "key-server.properties", "keys", "res", "res/system")) {
            Properties properties = new Properties();
            try {
                FileInputStream fis = new FileInputStream(f);
                Throwable throwable = null;
                try {
                    properties.load(fis);
                    String url = properties.getProperty("url");
                    if (url.isEmpty()) continue;
                    this.keys.add(new SrvUrlLocation(f.getAbsoluteFile(), url));
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (fis == null) continue;
                    if (throwable != null) {
                        try {
                            fis.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    fis.close();
                }
            }
            catch (IOException iOException) {}
        }
        return null;
    }

    public static interface SearchServerslListener {
        public void onSelect(SrvUrlLocation var1);
    }

    private class SelectListener
    implements ServerSelectScreen.SrvScreenListener {
        private final Gui gui;
        private final Pane pane;

        public SelectListener(Gui gui, Pane pane) {
            this.gui = gui;
            this.pane = pane;
        }

        @Override
        public void onSelect(SrvUrlLocation location) {
            this.gui.clearPopup(this.pane);
            SearchServersUrl.this.listener.onSelect(location);
        }

        @Override
        public void onClose() {
            this.gui.clearPopup(this.pane);
        }
    }
}

