/*
 * Decompiled with CFR 0.152.
 */
package fxc.app.key;

import fxc.app.Configurator;
import fxc.app.gui.Gui;
import fxc.app.gui.oth.Dialog;
import fxc.app.gui.oth.KeyScreenListener;
import fxc.app.gui.oth.KeySelectScreen;
import fxc.app.key.KeyLocation;
import fxc.app.key.KeySelectListener;
import fxc.app.key.TerminalKey;
import fxc.app.key.TerminalKeyUtils;
import fxc.app.res.ResourceId;
import fxc.app.task.WaitTask;
import java.io.File;
import java.text.MessageFormat;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import javafx.scene.layout.Pane;

public class SearchKeyTask
extends WaitTask {
    private final List<KeyLocation> keys = new LinkedList<KeyLocation>();
    private final List<File> dirs = new LinkedList<File>();
    private final Configurator conf;
    private final KeySelectListener listener;

    public SearchKeyTask(Configurator conf, KeySelectListener listener) {
        super(conf);
        this.conf = conf;
        this.listener = listener;
    }

    @Override
    protected void _onResult(Object object) {
        super._onResult(object);
        Gui g = this.conf.getGui();
        if (!this.keys.isEmpty()) {
            KeySelectScreen kss = g.getKeySelectScreen();
            kss.update(this.keys, new Key(g, kss.getPane()));
            g.openPopup(kss.getPane());
        } else {
            String paths = this.dirs.stream().map(File::getAbsolutePath).map(str -> str.replace("\\.", "").replace("/.", "")).collect(Collectors.joining(", "));
            this.conf.showDialog(new Dialog(ResourceId.BUNDLE.getString("dialog.title.keys"), MessageFormat.format(ResourceId.BUNDLE.getString("dialog.keys.paths"), paths), ResourceId.BUNDLE.getString("dialog.btn.ok")), null);
        }
    }

    @Override
    public Object process() {
        for (File f : TerminalKeyUtils.searchFileByType(this.dirs, ".tkey", "keys")) {
            try {
                TerminalKey k = TerminalKeyUtils.load(f, false);
                this.keys.add(new KeyLocation(f.getAbsoluteFile(), k.getHost() + ":" + k.getHttpsPort(), k.getPoint(), k.getName()));
            }
            catch (Exception exception) {}
        }
        return null;
    }

    private class Key
    implements KeyScreenListener {
        private final Gui gui;
        private final Pane pane;

        public Key(Gui gui, Pane pane) {
            this.gui = gui;
            this.pane = pane;
        }

        @Override
        public void onSelect(KeyLocation location) {
            this.gui.clearPopup(this.pane);
            SearchKeyTask.this.listener.onSelect(location.getPath());
        }

        @Override
        public void onClose() {
            this.gui.clearPopup(this.pane);
        }
    }
}

