/*
 * Decompiled with CFR 0.152.
 */
package fxc.app.key;

import fxc.app.key.TerminalKey;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

class KeyParser
extends DefaultHandler {
    private final boolean extractValues;
    private int pointId;
    private String name;
    private String host;
    private String pointKey = "";
    private String serverKey = "";
    private int httpPort;
    private int httpsPort;
    private boolean inPoint;
    private boolean inServer;
    private boolean inKey;

    public KeyParser(boolean extractValues) {
        this.extractValues = extractValues;
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        try {
            if ("point".equals(qName)) {
                this.pointId = Integer.parseInt(attributes.getValue("id"));
                this.name = attributes.getValue("name");
                this.inPoint = true;
            } else if ("server".equals(qName)) {
                this.host = attributes.getValue("ip");
                this.httpPort = Integer.parseInt(attributes.getValue("http_port"));
                this.httpsPort = Integer.parseInt(attributes.getValue("port"));
                this.inServer = true;
            } else if ("key".equals(qName)) {
                this.inKey = true;
            } else if (!"auth".equals(qName)) {
                throw new SAXException("Wrong xml file, unknown " + qName);
            }
        }
        catch (NumberFormatException ex) {
            throw new SAXException(ex);
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.extractValues && this.inKey) {
            if (this.inPoint) {
                this.pointKey = this.pointKey + new String(ch, start, length);
            } else if (this.inServer) {
                this.serverKey = this.serverKey + new String(ch, start, length);
            }
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        try {
            if (null != qName) {
                switch (qName) {
                    case "point": {
                        this.inPoint = false;
                        break;
                    }
                    case "server": {
                        this.inServer = false;
                        break;
                    }
                    case "key": {
                        this.inKey = false;
                        break;
                    }
                }
            }
        }
        catch (NumberFormatException ex) {
            throw new SAXException(ex);
        }
    }

    public TerminalKey getKey() {
        return new TerminalKey(this.pointKey.trim(), null, this.serverKey.trim(), this.host, this.httpPort, this.httpsPort, this.pointId, this.name);
    }
}

