/*
 * Decompiled with CFR 0.152.
 */
package fxc.app.key;

import fxc.app.Configurator;
import fxc.app.gui.oth.Dialog;
import fxc.app.key.TerminalKey;
import fxc.app.res.ResourceId;
import fxc.app.task.WaitTask;
import java.io.IOException;
import java.text.MessageFormat;
import ru.softlogic.keyclient.GenerateException;
import ru.softlogic.keyclient.KeyClient;
import ru.softlogic.keyclient.KeyClientException;
import ru.softlogic.keyclient.KeyClientMessageExtractor;
import ru.softlogic.keyclient.PinCodeGenerator;
import ru.softlogic.keyclient.PointKeyResult;
import ru.softlogic.keyclient.X509Generator;
import ru.softlogic.srv.utils.NetworkUtils;
import ru.softlogic.system.util.hwd.SerialExtractorApi;

public class GenerateKeyTask
extends WaitTask {
    private final String login;
    private final String password;
    private final String url;
    private final Configurator conf;
    private final LoadKeyListener listener;

    public GenerateKeyTask(Configurator conf, LoadKeyListener listener, String url, String login, String password) {
        super(conf);
        this.conf = conf;
        this.url = url;
        this.login = login;
        this.password = password;
        this.listener = listener;
    }

    @Override
    public Object process() {
        try {
            X509Generator.EncodedKeyPair pair = X509Generator.generatePrivateKey();
            KeyClient client = new KeyClient(this.url, Long.valueOf(SerialExtractorApi.getInstance().getConfigurationId()));
            PointKeyResult pkr = client.sendPointKey(this.login, this.password, pair.getPublicKey());
            if (pkr.getError() != 0) {
                throw new Exception(KeyClientMessageExtractor.getMessage((int)pkr.getError()));
            }
            return new TerminalKey(pair.getPrivateKey(), pair.getPublicKey(), pkr.getOpenServerKey(), pkr.getServerAddress(), pkr.getHttpPort(), pkr.getHttpsPort(), Integer.parseInt(this.login), NetworkUtils.buildTerminalKeyName((String)this.login, (int)pkr.getHttpsPort(), (int)Integer.parseInt(this.login)));
        }
        catch (Exception ex) {
            return ex;
        }
    }

    @Override
    public void _onResult(Object object) {
        super._onResult(object);
        if (object instanceof Exception) {
            Exception ex = (Exception)object;
            if (object instanceof IOException) {
                this.showErrorDialog(ResourceId.BUNDLE.getString("genkey.error.config"));
            } else if (object instanceof GenerateException) {
                this.showErrorDialog(ResourceId.BUNDLE.getString("genkey.error.generate"));
            } else if (object instanceof KeyClientException) {
                this.showErrorDialog(ResourceId.BUNDLE.getString("genkey.error.network") + ": " + ex.getMessage());
            } else {
                this.showErrorDialog(ex.getMessage());
            }
        } else {
            TerminalKey tk = (TerminalKey)object;
            if (tk.getPublicTerminalKey() != null) {
                String pin = PinCodeGenerator.getPin((String)tk.getPublicTerminalKey());
                this.showPincodeDialog(pin);
            }
            if (this.listener != null) {
                this.listener.onLoad(tk);
            }
        }
    }

    private void showErrorDialog(String msg) {
        this.conf.showDialog(new Dialog(ResourceId.BUNDLE.getString("dialog.title.error"), msg, ResourceId.BUNDLE.getString("dialog.btn.ok")), null);
    }

    private void showPincodeDialog(String pin) {
        this.conf.showDialog(new Dialog(ResourceId.BUNDLE.getString("dialog.title.info"), MessageFormat.format(ResourceId.BUNDLE.getString("genkey.result.success1"), pin), ResourceId.BUNDLE.getString("dialog.btn.ok")), null);
    }

    public static interface LoadKeyListener {
        public void onLoad(TerminalKey var1);
    }
}

