/*
 * Decompiled with CFR 0.152.
 */
package fxc.app.gui.oth;

import fxc.app.gui.oth.KeyRow;
import fxc.app.gui.oth.SrvUrlRow;
import fxc.app.key.SrvUrlLocation;
import java.net.URL;
import java.util.List;
import java.util.ResourceBundle;
import java.util.stream.Collectors;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.control.Button;
import javafx.scene.control.SelectionMode;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.layout.Pane;
import javafx.util.Callback;

public class ServerSelectScreen
implements Initializable {
    private List<SrvUrlLocation> srvUrlLocations;
    private SrvScreenListener listener;
    @FXML
    private Pane root;
    @FXML
    private Button bSelect;
    @FXML
    private TableView<SrvUrlRow> tSrvUrls;
    @FXML
    private TableColumn<KeyRow, String> tcHost;
    @FXML
    private TableColumn<KeyRow, String> tcPath;

    public void initialize(URL location, ResourceBundle resources) {
        this.tcHost.setCellValueFactory((Callback)new PropertyValueFactory("host"));
        this.tcPath.setCellValueFactory((Callback)new PropertyValueFactory("path"));
        this.tcHost.prefWidthProperty().bind((ObservableValue)this.tSrvUrls.widthProperty().multiply(0.4));
        this.tcPath.prefWidthProperty().bind((ObservableValue)this.tSrvUrls.widthProperty().multiply(0.59));
        this.tSrvUrls.setEditable(false);
        this.tSrvUrls.getSelectionModel().selectionModeProperty().setValue((Object)SelectionMode.SINGLE);
        this.bSelect.disableProperty().bind((ObservableValue)this.tSrvUrls.getSelectionModel().selectedItemProperty().isNull());
    }

    public void update(List<SrvUrlLocation> srvUrlLocations, SrvScreenListener listener) {
        this.srvUrlLocations = srvUrlLocations;
        this.listener = listener;
        List rows = srvUrlLocations.stream().map(sul -> new SrvUrlRow(sul.getServer(), sul.getPath().getAbsolutePath())).collect(Collectors.toList());
        this.tSrvUrls.setItems(FXCollections.observableArrayList(rows));
        this.tSrvUrls.getSelectionModel().clearSelection();
    }

    public Pane getPane() {
        return this.root;
    }

    @FXML
    private void select() {
        if (this.listener != null && this.srvUrlLocations != null) {
            this.listener.onSelect(this.srvUrlLocations.get(this.tSrvUrls.getSelectionModel().getSelectedIndex()));
        }
    }

    @FXML
    private void close() {
        if (this.listener != null) {
            this.listener.onClose();
        }
    }

    public static interface SrvScreenListener {
        public void onSelect(SrvUrlLocation var1);

        public void onClose();
    }
}

