/*
 * Decompiled with CFR 0.152.
 */
package fxc.app.gui.oth;

import fxc.app.gui.oth.ScanRecord;
import fxc.app.gui.oth.ScanRender;
import fxc.app.gui.oth.ScanScreenListener;
import java.net.URL;
import java.util.List;
import java.util.ResourceBundle;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.control.Label;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.layout.Pane;
import javafx.util.Callback;

public class ScanScreen
implements Initializable {
    @FXML
    private Pane root;
    @FXML
    private TableView<ScanRecord> table;
    @FXML
    private TableColumn<ScanRecord, Integer> port;
    @FXML
    private TableColumn<ScanRecord, String> device;
    @FXML
    private TableColumn<ScanRecord, String> params;
    @FXML
    private TableColumn<ScanRecord, String> found;
    @FXML
    private TableColumn<ScanRecord, String> finish;
    @FXML
    private Label interval;
    private ScanScreenListener listener;

    public void initialize(URL location, ResourceBundle resources) {
        this.port.setCellValueFactory((Callback)new PropertyValueFactory("port"));
        this.device.setCellValueFactory((Callback)new PropertyValueFactory("type"));
        this.params.setCellValueFactory((Callback)new PropertyValueFactory("params"));
        this.found.setCellValueFactory((Callback)new PropertyValueFactory("found"));
        this.finish.setCellValueFactory((Callback)new PropertyValueFactory("finish"));
        this.port.prefWidthProperty().bind((ObservableValue)this.table.widthProperty().divide(6));
        this.device.prefWidthProperty().bind((ObservableValue)this.table.widthProperty().divide(3.1));
        this.params.prefWidthProperty().bind((ObservableValue)this.table.widthProperty().divide(6));
        this.found.prefWidthProperty().bind((ObservableValue)this.table.widthProperty().divide(6));
        this.finish.prefWidthProperty().bind((ObservableValue)this.table.widthProperty().divide(6));
        this.table.setEditable(false);
        this.table.setRowFactory((Callback)new ScanRender());
    }

    public void update(List<ScanRecord> records) {
        this.table.getItems().clear();
        if (records != null) {
            this.table.setItems(FXCollections.observableArrayList(records));
        }
    }

    public void setInterval(String interval) {
        this.interval.setText(interval);
    }

    public void setListener(ScanScreenListener listener) {
        this.listener = listener;
    }

    public Pane geRoot() {
        return this.root;
    }

    @FXML
    private void onCancel() {
        if (this.listener != null) {
            this.listener.onCancel();
        }
    }
}

