/*
 * Decompiled with CFR 0.152.
 */
package fxc.app.gui.oth;

import fxc.app.gui.oth.KeyRow;
import fxc.app.gui.oth.KeyScreenListener;
import fxc.app.key.KeyLocation;
import java.net.URL;
import java.util.LinkedList;
import java.util.List;
import java.util.ResourceBundle;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.control.Button;
import javafx.scene.control.SelectionMode;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.layout.Pane;
import javafx.util.Callback;

public class KeySelectScreen
implements Initializable {
    private List<KeyLocation> keyLocations;
    private KeyScreenListener listener;
    @FXML
    private Pane root;
    @FXML
    private Button bSelect;
    @FXML
    private TableView<KeyRow> tKeys;
    @FXML
    private TableColumn<KeyRow, String> tcHost;
    @FXML
    private TableColumn<KeyRow, String> tcPoint;
    @FXML
    private TableColumn<KeyRow, String> tcName;
    @FXML
    private TableColumn<KeyRow, String> tcPath;

    public void initialize(URL location, ResourceBundle resources) {
        this.tcHost.setCellValueFactory((Callback)new PropertyValueFactory("host"));
        this.tcPoint.setCellValueFactory((Callback)new PropertyValueFactory("point"));
        this.tcName.setCellValueFactory((Callback)new PropertyValueFactory("name"));
        this.tcPath.setCellValueFactory((Callback)new PropertyValueFactory("path"));
        this.tcHost.prefWidthProperty().bind((ObservableValue)this.tKeys.widthProperty().multiply(0.25));
        this.tcPoint.prefWidthProperty().bind((ObservableValue)this.tKeys.widthProperty().multiply(0.08));
        this.tcName.prefWidthProperty().bind((ObservableValue)this.tKeys.widthProperty().multiply(0.27));
        this.tcPath.prefWidthProperty().bind((ObservableValue)this.tKeys.widthProperty().multiply(0.4));
        this.tKeys.setEditable(false);
        this.tKeys.getSelectionModel().selectionModeProperty().setValue((Object)SelectionMode.SINGLE);
        this.bSelect.disableProperty().bind((ObservableValue)this.tKeys.getSelectionModel().selectedItemProperty().isNull());
    }

    public void update(List<KeyLocation> keyLocations, KeyScreenListener listener) {
        this.keyLocations = keyLocations;
        this.listener = listener;
        LinkedList<KeyRow> rows = new LinkedList<KeyRow>();
        for (KeyLocation kl : keyLocations) {
            rows.add(new KeyRow(kl.getServer(), Integer.toString(kl.getPointId()), kl.getName(), kl.getPath().getAbsolutePath()));
        }
        this.tKeys.setItems(FXCollections.observableArrayList(rows));
        this.tKeys.getSelectionModel().clearSelection();
    }

    public Pane getPane() {
        return this.root;
    }

    @FXML
    private void select() {
        if (this.listener != null && this.keyLocations != null) {
            this.listener.onSelect(this.keyLocations.get(this.tKeys.getSelectionModel().getSelectedIndex()));
        }
    }

    @FXML
    private void close() {
        if (this.listener != null) {
            this.listener.onClose();
        }
    }
}

