/*
 * Decompiled with CFR 0.152.
 */
package fxc.app.gui.oth;

import fxc.app.gui.ctrl.digital.DigitalFieldController;
import fxc.app.gui.ctrl.digital.DigitalKeyboardOptions;
import fxc.app.gui.ctrl.letter.LetterFieldController;
import fxc.app.gui.ctrl.letter.LetterKeyboardOptions;
import java.net.URL;
import java.util.ResourceBundle;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableValue;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.control.Button;
import javafx.scene.layout.Pane;

public class GenerateKeyDialog
implements Initializable {
    @FXML
    private Pane root;
    @FXML
    private Button bRight;
    @FXML
    private DigitalFieldController pointIdController;
    @FXML
    private LetterFieldController passwordController;
    private GenerateDialogListener listener;

    public void initialize(URL url, ResourceBundle rb) {
        this.pointIdController.setOptions(new DigitalKeyboardOptions(1, Short.MAX_VALUE, 5, null));
        this.passwordController.setOptions(new LetterKeyboardOptions(15, false));
        this.bRight.disableProperty().bind((ObservableValue)this.pointIdController.getIsValidProperty().and((ObservableBooleanValue)this.passwordController.getIsValidProperty()).not());
    }

    public void init(GenerateDialogListener listener) {
        this.listener = listener;
        this.passwordController.setValue("");
    }

    public Pane getRoot() {
        return this.root;
    }

    @FXML
    public void onClose() {
        if (this.listener != null) {
            this.listener.onClose();
        }
    }

    @FXML
    public void onGenerate() {
        if (this.listener != null) {
            int pointId = this.pointIdController.getValue();
            String password = this.passwordController.getValue();
            this.listener.onSelect(String.valueOf(pointId), password);
        }
    }

    public static interface GenerateDialogListener {
        public void onClose();

        public void onSelect(String var1, String var2);
    }
}

