/*
 * Decompiled with CFR 0.152.
 */
package fxc.app.gui.oth;

import fxc.app.gui.oth.Dialog;
import fxc.app.gui.oth.DialogListener;
import java.net.URL;
import java.util.ResourceBundle;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.layout.Pane;

public class DialogScreen
implements Initializable,
EventHandler<ActionEvent> {
    @FXML
    private Pane root;
    @FXML
    private Button bLeft;
    @FXML
    private Button bRight;
    @FXML
    private Label lTitle;
    @FXML
    private Label lMessage;
    private DialogListener listener;

    public void initialize(URL url, ResourceBundle rb) {
        this.bLeft.setOnAction((EventHandler)this);
        if (this.bRight != null) {
            this.bRight.setOnAction((EventHandler)this);
        }
    }

    public void init(Dialog dialog, DialogListener listener) {
        if (dialog == null) {
            throw new NullPointerException("Dialog is not set");
        }
        this.listener = listener;
        this.lTitle.setText(dialog.getTitle());
        this.lMessage.setText(dialog.getMessage());
        this.bLeft.setText(dialog.getButtons()[0]);
        if (dialog.getButtons().length > 1) {
            this.bRight.setText(dialog.getButtons()[1]);
        }
    }

    public Pane getRoot() {
        return this.root;
    }

    public void handle(ActionEvent t) {
        if (this.listener != null) {
            this.listener.onSelect(t.getSource() == this.bLeft ? 0 : 1);
        }
    }
}

