/*
 * Decompiled with CFR 0.152.
 */
package fxc.app.gui.oth;

import fxc.app.Configurator;
import fxc.app.connect.CheckConnectCloseListener;
import fxc.app.connect.PingExternalTask;
import fxc.app.connect.PingServerTask;
import fxc.app.connect.PingTaskListener;
import fxc.app.connect.RequestServerTask;
import fxc.app.gui.oth.CheckRender;
import fxc.app.gui.oth.ConnectionCheckRow;
import fxc.app.res.LoggerId;
import java.net.URL;
import java.util.ResourceBundle;
import java.util.concurrent.BrokenBarrierException;
import java.util.concurrent.CyclicBarrier;
import java.util.concurrent.ExecutorService;
import javafx.application.Platform;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.control.Button;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.layout.Pane;
import javafx.util.Callback;
import org.apache.log4j.Logger;

public class CheckConnectionScreen
implements Initializable {
    private ConnectionCheckRow checkExternalSrvRow;
    private ConnectionCheckRow checkPaymentSrvRow;
    private ConnectionCheckRow checkRequestSrvRow;
    private ResourceBundle resources;
    private final Configurator conf;
    private CyclicBarrier barrier;
    private CheckConnectCloseListener listener;
    ObservableList<ConnectionCheckRow> observableList;
    private final Logger log = LoggerId.LOG;
    @FXML
    private Pane root;
    @FXML
    private TableView<ConnectionCheckRow> table;
    @FXML
    private TableColumn<ConnectionCheckRow, String> tcAction;
    @FXML
    private TableColumn<ConnectionCheckRow, String> tcStatus;
    @FXML
    private Button btnClose;

    public CheckConnectionScreen(Configurator conf) {
        this.conf = conf;
    }

    public void initialize(URL location, ResourceBundle resources) {
        this.resources = resources;
        this.tcAction.setCellValueFactory((Callback)new PropertyValueFactory("action"));
        this.tcStatus.setCellValueFactory((Callback)new PropertyValueFactory("status"));
        this.tcAction.prefWidthProperty().bind((ObservableValue)this.table.widthProperty().multiply(0.745));
        this.tcStatus.prefWidthProperty().bind((ObservableValue)this.table.widthProperty().multiply(0.25));
        this.table.getSelectionModel().clearSelection();
        this.barrier = new CyclicBarrier(3, () -> Platform.runLater(() -> this.btnClose.setDisable(false)));
    }

    public void start(CheckConnectCloseListener listener) {
        this.listener = listener;
        String waitString = this.resources.getString("connect.status.wait");
        this.checkExternalSrvRow = new ConnectionCheckRow(this.resources.getString("connect.ping.external"), waitString);
        this.checkPaymentSrvRow = new ConnectionCheckRow(this.resources.getString("connect.ping.payment"), waitString);
        this.checkRequestSrvRow = new ConnectionCheckRow(this.resources.getString("connect.ping.request"), waitString);
        this.observableList = FXCollections.observableArrayList();
        this.observableList.add((Object)this.checkExternalSrvRow);
        this.observableList.add((Object)this.checkPaymentSrvRow);
        this.observableList.add((Object)this.checkRequestSrvRow);
        this.updateTable();
        this.table.setRowFactory((Callback)new CheckRender());
        this.barrier.reset();
        ExecutorService threadPool = this.conf.getThreadPool();
        threadPool.submit(new PingExternalTask(new LocalPingTaskListener(this.checkExternalSrvRow)));
        threadPool.submit(new RequestServerTask(this.conf, new LocalPingTaskListener(this.checkRequestSrvRow)));
        threadPool.submit(new PingServerTask(this.conf.getServerProfile(), new LocalPingTaskListener(this.checkPaymentSrvRow)));
    }

    public void updateTable() {
        this.table.getItems().clear();
        if (this.observableList != null) {
            this.table.setItems(FXCollections.observableArrayList(this.observableList));
        }
    }

    public Pane getPane() {
        return this.root;
    }

    @FXML
    private void onCancel() {
        if (this.listener != null) {
            this.listener.onClose();
        }
    }

    private class LocalPingTaskListener
    implements PingTaskListener {
        ConnectionCheckRow row;

        public LocalPingTaskListener(ConnectionCheckRow row) {
            this.row = row;
        }

        @Override
        public void onSeccess() {
            this.row.setStatus(CheckConnectionScreen.this.resources.getString("connect.status.success"));
            this.row.setStatusFlag(1);
            CheckConnectionScreen.this.updateTable();
            this.barrierAwait();
        }

        @Override
        public void onError() {
            this.row.setStatus(CheckConnectionScreen.this.resources.getString("connect.status.error"));
            this.row.setStatusFlag(-1);
            CheckConnectionScreen.this.updateTable();
            this.barrierAwait();
        }

        private void barrierAwait() {
            try {
                CheckConnectionScreen.this.barrier.await();
            }
            catch (InterruptedException | BrokenBarrierException ex) {
                CheckConnectionScreen.this.log.warn((Object)("Barrier await exception: " + ex));
            }
        }
    }
}

