/*
 * Decompiled with CFR 0.152.
 */
package fxc.app.gui.ctrl.ports;

import fxc.app.gui.Gui;
import fxc.app.gui.SelectorItem;
import fxc.app.gui.ctrl.ports.ComboBoxValidateExeption;
import fxc.app.gui.ctrl.ports.PortSettingController;
import fxc.app.res.LoggerId;
import java.net.URL;
import java.util.ResourceBundle;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.layout.Pane;
import org.apache.log4j.Logger;
import ru.softlogic.io.serial.DataBits;
import ru.softlogic.io.serial.Parity;
import ru.softlogic.io.serial.SerialParams;
import ru.softlogic.io.serial.StopBits;

public class PortSettingScreen
implements Initializable {
    @FXML
    private Pane root;
    @FXML
    private ComboBox<SelectorItem<Integer>> cbSpeads;
    @FXML
    private ComboBox<SelectorItem<StopBits>> cbStopBits;
    @FXML
    private ComboBox<SelectorItem<DataBits>> cbDataBits;
    @FXML
    private ComboBox<SelectorItem<Parity>> cbParity;
    @FXML
    private Label portName;
    private final Gui gui;
    private PortSettingController cntr;
    private final Logger log = LoggerId.LOG;

    public PortSettingScreen(Gui gui) {
        this.gui = gui;
    }

    public void initialize(URL location, ResourceBundle resources) {
        this.cbSpeads.getItems().clear();
        this.cbSpeads.getItems().add(new SelectorItem<Integer>("2400", 2400));
        this.cbSpeads.getItems().add(new SelectorItem<Integer>("4800", 4800));
        this.cbSpeads.getItems().add(new SelectorItem<Integer>("9600", 9600));
        this.cbSpeads.getItems().add(new SelectorItem<Integer>("19200", 19200));
        this.cbSpeads.getItems().add(new SelectorItem<Integer>("38400", 38400));
        this.cbSpeads.getItems().add(new SelectorItem<Integer>("57600", 57600));
        this.cbSpeads.getItems().add(new SelectorItem<Integer>("115200", 115200));
        this.cbDataBits.getItems().clear();
        this.cbDataBits.getItems().add(new SelectorItem<DataBits>("5", DataBits.Five));
        this.cbDataBits.getItems().add(new SelectorItem<DataBits>("6", DataBits.Six));
        this.cbDataBits.getItems().add(new SelectorItem<DataBits>("7", DataBits.Seven));
        this.cbDataBits.getItems().add(new SelectorItem<DataBits>("8", DataBits.Eight));
        this.cbStopBits.getItems().clear();
        this.cbStopBits.getItems().add(new SelectorItem<StopBits>("1", StopBits.One));
        this.cbStopBits.getItems().add(new SelectorItem<StopBits>("1.5", StopBits.OneHalf));
        this.cbStopBits.getItems().add(new SelectorItem<StopBits>("2", StopBits.Two));
        this.cbParity.getItems().clear();
        this.cbParity.getItems().add(new SelectorItem<Parity>("NONE", Parity.None));
        this.cbParity.getItems().add(new SelectorItem<Parity>("EVEN", Parity.Even));
        this.cbParity.getItems().add(new SelectorItem<Parity>("ODD", Parity.Odd));
        this.cbParity.getItems().add(new SelectorItem<Parity>("SPACE", Parity.Space));
        this.cbParity.getItems().add(new SelectorItem<Parity>("MARK", Parity.Mark));
    }

    public void show(PortSettingController cntr, String title) {
        if (cntr == null) {
            throw new NullPointerException("PortSettingController is null");
        }
        this.cntr = cntr;
        this.portName.setText(title);
        this.selectValues();
        this.gui.openPopup(this.root);
    }

    private void selectValues() {
        SerialParams params;
        if (this.cntr != null && (params = this.cntr.getParams()) != null) {
            this.cbSpeads.getSelectionModel().select(new SelectorItem<Integer>(null, params.getSpeed()));
            this.cbDataBits.getSelectionModel().select(new SelectorItem<DataBits>(null, params.getDataBits()));
            this.cbStopBits.getSelectionModel().select(new SelectorItem<StopBits>(null, params.getStopBits()));
            this.cbParity.getSelectionModel().select(new SelectorItem<Parity>(null, params.getParity()));
        }
    }

    @FXML
    private void onApply() {
        try {
            int spead = (Integer)this.getValidateValue(this.cbSpeads);
            DataBits dataBits = (DataBits)this.getValidateValue(this.cbDataBits);
            StopBits stopBits = (StopBits)this.getValidateValue(this.cbStopBits);
            Parity parity = (Parity)this.getValidateValue(this.cbParity);
            SerialParams params = new SerialParams(spead, dataBits, stopBits, parity);
            this.cntr.setParams(params);
            this.gui.clearPopup(this.root);
        }
        catch (ComboBoxValidateExeption ex) {
            this.log.error((Object)ex);
        }
    }

    private Object getValidateValue(ComboBox comboBox) throws ComboBoxValidateExeption {
        SelectorItem si = (SelectorItem)comboBox.getSelectionModel().getSelectedItem();
        if (si instanceof SelectorItem) {
            comboBox.setStyle("-fx-border-size: 0px; ");
            return si.getData();
        }
        comboBox.setStyle("-fx-border-size: 2px; -fx-border-color: red;");
        throw new ComboBoxValidateExeption();
    }

    @FXML
    private void onCancel() {
        this.gui.clearPopup(this.root);
    }
}

