/*
 * Decompiled with CFR 0.152.
 */
package fxc.app.gui.ctrl.ports;

import fxc.app.gui.ctrl.ports.PortSettingListener;
import fxc.app.model.Environment;
import fxc.app.res.ResourceId;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.ResourceBundle;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.value.ObservableValue;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.control.Button;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import ru.softlogic.io.Port;
import ru.softlogic.io.PortScanner;
import ru.softlogic.io.PortType;
import ru.softlogic.io.parallel.ParallelPort;
import ru.softlogic.io.serial.DataBits;
import ru.softlogic.io.serial.SerialParams;
import ru.softlogic.io.serial.SerialPort;
import ru.softlogic.io.serial.StopBits;
import ru.softlogic.io.usb.UsbPort;

public class PortSettingController
implements Initializable {
    private SerialParams params;
    private static PortSettingListener listener;
    private static String defaultString;
    private final BooleanProperty selectedProperty = new SimpleBooleanProperty();
    @FXML
    private Label description;
    @FXML
    private ComboBox<String> cbPort;
    @FXML
    private Button bSetting;

    public static void setListener(PortSettingListener listener) {
        PortSettingController.listener = listener;
    }

    private void startEdit() {
        if (listener != null) {
            listener.onEdit(this, (String)this.cbPort.getSelectionModel().getSelectedItem());
        }
    }

    public void initialize(URL url, ResourceBundle resources) {
        this.bSetting.setOnAction(event -> this.startEdit());
        this.cbPort.valueProperty().addListener((observable, oldValue, newValue) -> {
            String portName = (String)this.cbPort.getSelectionModel().getSelectedItem();
            PortType pt = PortScanner.suggestType((String)portName);
            boolean isSelected = this.cbPort.getSelectionModel().getSelectedIndex() != 0;
            boolean isSerial = pt == PortType.SerialPort;
            this.bSetting.setDisable(!isSelected || !isSerial);
            this.description.setVisible(isSelected && isSerial);
        });
        this.selectedProperty.bind((ObservableValue)this.cbPort.getSelectionModel().selectedIndexProperty().isNotEqualTo(0));
        this.params = new SerialParams(9600);
        this.description.setText(this.formatSerialPortFormat(this.params));
    }

    public void showingPorts(PortType ... types) {
        this.cbPort.getItems().clear();
        this.cbPort.getItems().add((Object)defaultString);
        this.cbPort.getSelectionModel().select(-1);
        if (types != null) {
            ArrayList<String> list = new ArrayList<String>();
            for (PortType pt : types) {
                if (PortType.ParallelPort.equals((Object)pt) && Environment.getParallelPorts() != null) {
                    list.addAll(Arrays.asList(Environment.getParallelPorts()));
                }
                if (PortType.UsbPort.equals((Object)pt) && Environment.getUsbPorts() != null) {
                    list.addAll(Arrays.asList(Environment.getUsbPorts()));
                }
                if (!PortType.SerialPort.equals((Object)pt) || Environment.getSerialPorts() == null) continue;
                list.addAll(Arrays.asList(Environment.getSerialPorts()));
            }
            this.cbPort.getItems().addAll(list);
        }
        this.cbPort.getSelectionModel().select(0);
    }

    public void setParams(SerialParams params) {
        if (params != null) {
            this.description.setText(this.formatSerialPortFormat(params));
        }
        this.params = params;
    }

    public SerialParams getParams() {
        return this.params;
    }

    public SerialPort getSerialPort() {
        int index = this.cbPort.getSelectionModel().getSelectedIndex();
        if (index <= 0) {
            return null;
        }
        String portName = (String)this.cbPort.getSelectionModel().getSelectedItem();
        return new SerialPort(portName, this.params);
    }

    public void setPortName(String portName) {
        if (portName == null) {
            this.cbPort.getSelectionModel().select(0);
        } else if (this.cbPort.getItems().contains((Object)portName)) {
            this.cbPort.getSelectionModel().select((Object)portName);
        } else {
            this.cbPort.getSelectionModel().select(0);
        }
    }

    private String formatSerialPortFormat(SerialParams params) {
        if (params == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder(String.valueOf(params.getSpeed()));
        if (params.getDataBits() == DataBits.Eight) {
            sb.append(",8");
        } else if (params.getDataBits() == DataBits.Seven) {
            sb.append(",7");
        } else if (params.getDataBits() == DataBits.Six) {
            sb.append(",6");
        } else if (params.getDataBits() == DataBits.Five) {
            sb.append(",5");
        }
        if (params.getStopBits() == StopBits.One) {
            sb.append(",1");
        } else if (params.getStopBits() == StopBits.OneHalf) {
            sb.append(",1.5");
        } else if (params.getStopBits() == StopBits.Two) {
            sb.append(",2");
        }
        sb.append(",");
        sb.append(params.getParity());
        return sb.toString();
    }

    public Port getPort() {
        int index = this.cbPort.getSelectionModel().getSelectedIndex();
        if (index <= 0) {
            return null;
        }
        String portName = (String)this.cbPort.getSelectionModel().getSelectedItem();
        PortType pt = PortScanner.suggestType((String)portName);
        if (pt == PortType.SerialPort) {
            return new SerialPort(portName, this.params);
        }
        if (pt == PortType.ParallelPort) {
            return new ParallelPort(portName);
        }
        return new UsbPort(portName);
    }

    public ComboBox<String> getComboBox() {
        return this.cbPort;
    }

    public BooleanProperty getSelectedProperty() {
        return this.selectedProperty;
    }

    static {
        defaultString = ResourceId.BUNDLE.getString("value.notselected");
    }
}

