/*
 * Decompiled with CFR 0.152.
 */
package fxc.app.gui.ctrl.letter;

import fxc.app.gui.Gui;
import fxc.app.gui.ctrl.BaseStringModel;
import fxc.app.gui.ctrl.ValueModelListener;
import fxc.app.gui.ctrl.letter.LetterFieldController;
import fxc.app.gui.ctrl.letter.LetterKeyboardOptions;
import java.net.URL;
import java.util.LinkedList;
import java.util.List;
import java.util.ResourceBundle;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.TabPane;
import javafx.scene.layout.Pane;

public class LetterKeyboardScreen
implements Initializable,
ValueModelListener,
EventHandler<ActionEvent> {
    @FXML
    private Pane root;
    @FXML
    private Pane letterPane;
    @FXML
    private Pane digitalPane;
    @FXML
    private Pane symbPane;
    @FXML
    private TabPane tabPane;
    @FXML
    private Label view;
    private BaseStringModel model;
    private final Gui gui;
    private LetterFieldController cntr;
    private List<Button> letters;
    private boolean upperCase;

    public LetterKeyboardScreen(Gui gui) {
        this.gui = gui;
    }

    public void initialize(URL location, ResourceBundle resources) {
        Button b;
        this.letters = new LinkedList<Button>();
        if (this.letterPane != null) {
            for (Node n : this.letterPane.lookupAll(".letter")) {
                if (!(n instanceof Button)) continue;
                b = (Button)n;
                b.setOnAction((EventHandler)this);
                this.letters.add(b);
            }
        }
        if (this.digitalPane != null) {
            for (Node n : this.digitalPane.lookupAll(".digit")) {
                if (!(n instanceof Button)) continue;
                b = (Button)n;
                b.setOnAction((EventHandler)this);
            }
        }
        if (this.symbPane != null) {
            for (Node n : this.symbPane.lookupAll(".symb")) {
                if (!(n instanceof Button)) continue;
                b = (Button)n;
                b.setOnAction((EventHandler)this);
            }
        }
    }

    public void show(LetterFieldController cntr) {
        if (cntr == null) {
            throw new NullPointerException("LetterFieldController is null");
        }
        this.cntr = cntr;
        LetterKeyboardOptions options = cntr.getOptions();
        this.model = new BaseStringModel(options.getMaxLen());
        this.model.addListener(this);
        this.model.setValue(cntr.getValue());
        this.gui.openPopup(this.root);
        if (this.tabPane != null) {
            this.tabPane.getSelectionModel().select(0);
        }
        if (this.upperCase) {
            this.upperCase = false;
            this.processCase();
        }
    }

    @FXML
    private void onPress(ActionEvent t) {
        Button b = (Button)t.getSource();
        this.model.add(b.getText().charAt(0));
    }

    @FXML
    private void onClear() {
        this.model.clear();
    }

    @FXML
    private void onClearLast() {
        this.model.clearLast();
    }

    @FXML
    private void onClose() {
        this.gui.clearPopup(this.root);
    }

    @FXML
    private void onApply() {
        if (this.cntr != null) {
            this.cntr.setValue(this.model.getValue());
        }
        this.gui.clearPopup(this.root);
    }

    @Override
    public void onChange(String v) {
        this.view.setText(v);
    }

    @FXML
    public void onChangeCase() {
        this.upperCase = !this.upperCase;
        this.processCase();
    }

    private void processCase() {
        this.letterPane.setVisible(false);
        for (Button b : this.letters) {
            String text = b.getText();
            b.setText(this.upperCase ? text.toUpperCase() : text.toLowerCase());
        }
        this.letterPane.setVisible(true);
    }

    public void handle(ActionEvent event) {
        this.onPress(event);
    }
}

