/*
 * Decompiled with CFR 0.152.
 */
package fxc.app.gui.ctrl.letter;

import fxc.app.gui.MaxlenFilter;
import fxc.app.gui.ctrl.letter.LetterFieldListener;
import fxc.app.gui.ctrl.letter.LetterKeyboardOptions;
import java.net.URL;
import java.util.ResourceBundle;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.control.Button;
import javafx.scene.control.TextField;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.Pane;

public class LetterFieldController
implements Initializable {
    @FXML
    private TextField field;
    @FXML
    private Button button;
    @FXML
    private Pane root;
    private LetterKeyboardOptions options;
    private MaxlenFilter filter;
    private BooleanProperty isValidProperty;
    private static LetterFieldListener listener;

    public void initialize(URL url, ResourceBundle rb) {
        this.filter = new MaxlenFilter(this.field, 2);
        this.field.addEventFilter(KeyEvent.KEY_TYPED, (EventHandler)this.filter);
        this.button.setOnAction(event -> this.startEdit());
    }

    public void setOptions(LetterKeyboardOptions options) {
        if (options == null) {
            throw new NullPointerException("LetterKeyboardOptions is null");
        }
        this.options = options;
        this.filter.setMaxLen(options.getMaxLen());
        this.isValidProperty = new SimpleBooleanProperty(this.isValid());
        this.field.textProperty().addListener((observable, oldValue, newValue) -> this.isValidProperty.setValue(Boolean.valueOf(this.isValid())));
    }

    public LetterKeyboardOptions getOptions() {
        return this.options;
    }

    public String getValue() {
        return this.field.getText();
    }

    public void setValue(String value) {
        this.field.setText(value);
    }

    public boolean isValid() {
        if (this.options != null) {
            return this.options.isAllowEmpty() || !this.field.getText().isEmpty();
        }
        return true;
    }

    public BooleanProperty getIsValidProperty() {
        return this.isValidProperty;
    }

    private void startEdit() {
        if (listener != null && this.options != null) {
            listener.onEdit(this);
        }
    }

    public static void setListener(LetterFieldListener listener) {
        LetterFieldController.listener = listener;
    }
}

