/*
 * Decompiled with CFR 0.152.
 */
package fxc.app.gui.ctrl.digital;

import fxc.app.gui.NumericFilter;
import fxc.app.gui.ctrl.digital.DigitalFieldCloseListener;
import fxc.app.gui.ctrl.digital.DigitalFieldListener;
import fxc.app.gui.ctrl.digital.DigitalKeyboardOptions;
import java.net.URL;
import java.util.ResourceBundle;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.control.Button;
import javafx.scene.control.TextField;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.Pane;

public class DigitalFieldController
implements Initializable {
    private static final String ERROR_STYLE = "numeric-error";
    @FXML
    private TextField field;
    @FXML
    private Button button;
    @FXML
    private Pane root;
    private NumericFilter filter;
    private DigitalKeyboardOptions options;
    private BooleanProperty isValidProperty;
    private static DigitalFieldListener listener;
    private DigitalFieldCloseListener closeListener;

    public void initialize(URL url, ResourceBundle rb) {
        this.filter = new NumericFilter(this.field, 2, this);
        this.field.addEventFilter(KeyEvent.KEY_TYPED, (EventHandler)this.filter);
        this.button.setOnAction(event -> this.startEdit());
    }

    public void setOptions(DigitalKeyboardOptions options) {
        if (options == null) {
            throw new NullPointerException("DigitalKeyboardSettings is null");
        }
        this.options = options;
        this.isValidProperty = new SimpleBooleanProperty(this.isValid());
        this.field.textProperty().addListener((observable, oldValue, newValue) -> {
            boolean v = this.isValid();
            this.isValidProperty.setValue(Boolean.valueOf(v));
            if (v) {
                this.field.getStyleClass().remove((Object)ERROR_STYLE);
            } else if (!this.field.getStyleClass().contains((Object)ERROR_STYLE)) {
                this.field.getStyleClass().add((Object)ERROR_STYLE);
            }
        });
    }

    public DigitalKeyboardOptions getOptions() {
        return this.options;
    }

    public void setDisable(boolean disable) {
        this.field.setDisable(disable);
        this.button.setDisable(disable);
    }

    public int getValue() {
        try {
            return Integer.parseInt(this.field.getText());
        }
        catch (NumberFormatException ex) {
            return this.options != null ? this.options.getMin() : 0;
        }
    }

    public void setValue(int value) {
        this.field.setText(Integer.toString(value));
    }

    public boolean isValid() {
        if (this.options != null) {
            return !this.field.getText().isEmpty() && this.getValue() >= this.options.getMin() && this.getValue() <= this.options.getMax();
        }
        return true;
    }

    public BooleanProperty getIsValidProperty() {
        return this.isValidProperty;
    }

    private void startEdit() {
        if (listener != null && this.options != null) {
            listener.onEdit(this);
        }
    }

    public static void setListener(DigitalFieldListener listener) {
        DigitalFieldController.listener = listener;
    }

    public void setCloseListener(DigitalFieldCloseListener closeListener) {
        this.closeListener = closeListener;
    }

    public DigitalFieldCloseListener getCloseListener() {
        return this.closeListener;
    }
}

