/*
 * Decompiled with CFR 0.152.
 */
package fxc.app.gui.ctrl.digital;

import fxc.app.gui.Gui;
import fxc.app.gui.ctrl.BaseDigitalModel;
import fxc.app.gui.ctrl.ValueModelListener;
import fxc.app.gui.ctrl.digital.DigitalFieldController;
import fxc.app.gui.ctrl.digital.DigitalKeyboardOptions;
import java.net.URL;
import java.util.ResourceBundle;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.layout.Pane;

public class DgtKeyboardScreen
implements Initializable,
ValueModelListener {
    @FXML
    private Pane root;
    @FXML
    private Button bMinus;
    @FXML
    private Button bPlus;
    @FXML
    private Button bDot;
    @FXML
    private Button bColon;
    @FXML
    private Button bApply;
    @FXML
    private Label view;
    private BaseDigitalModel model;
    private final Gui gui;
    private DigitalFieldController cntr;

    public DgtKeyboardScreen(Gui gui) {
        this.gui = gui;
    }

    public void initialize(URL location, ResourceBundle resources) {
    }

    public void show(DigitalFieldController cntr) {
        if (cntr == null) {
            throw new NullPointerException("DigitalFieldController is null");
        }
        this.cntr = cntr;
        DigitalKeyboardOptions options = cntr.getOptions();
        this.bMinus.setVisible((options.getFlags() & 1) > 0);
        this.bPlus.setVisible((options.getFlags() & 1) > 0);
        this.bDot.setVisible(false);
        this.bColon.setVisible(false);
        this.model = new BaseDigitalModel(options.getMin(), options.getMax(), options.getMaxLen());
        this.model.addListener(this);
        this.model.setIntValue(cntr.getValue());
        this.gui.openPopup(this.root);
    }

    @FXML
    private void onPress(ActionEvent t) {
        Button b = (Button)t.getSource();
        this.model.add(b.getText().charAt(0));
    }

    @FXML
    private void onClear() {
        this.model.clear();
    }

    @FXML
    private void onClearLast() {
        this.model.clearLast();
    }

    @FXML
    private void onPlus() {
        this.model.add();
    }

    @FXML
    private void onMinus() {
        this.model.sub();
    }

    @FXML
    private void onClose() {
        this.gui.clearPopup(this.root);
    }

    @FXML
    private void onApply() {
        this.cntr.setValue(Integer.parseInt(this.model.getValue()));
        if (this.cntr.getCloseListener() != null) {
            this.cntr.getCloseListener().afterClose();
        }
        this.gui.clearPopup(this.root);
    }

    @Override
    public void onChange(String v) {
        this.view.setText(v);
        this.bApply.setDisable(this.model.getValue().isEmpty());
    }
}

