/*
 * Decompiled with CFR 0.152.
 */
package fxc.app.gui.ctrl;

import fxc.app.gui.ctrl.ValueModel;
import fxc.app.gui.ctrl.ValueModelListener;
import java.util.HashSet;
import java.util.Set;

public class BaseStringModel
implements ValueModel {
    private final int maxLen;
    private String value = "";
    private final Set<ValueModelListener> listeners = new HashSet<ValueModelListener>();

    public BaseStringModel(int maxLen) {
        this.maxLen = maxLen;
    }

    @Override
    public void add(char ch) {
        if (this.value.length() < this.maxLen) {
            this.value = this.value + ch;
            this.update();
        }
    }

    @Override
    public void clear() {
        this.value = "";
        this.update();
    }

    @Override
    public void clearLast() {
        if (this.value.length() > 0) {
            this.value = this.value.substring(0, this.value.length() - 1);
            this.update();
        }
    }

    @Override
    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
        this.update();
    }

    @Override
    public void addListener(ValueModelListener listener) {
        if (listener == null) {
            throw new NullPointerException("ValueModelListener is null");
        }
        this.listeners.add(listener);
    }

    private void update() {
        for (ValueModelListener vml : this.listeners) {
            vml.onChange(this.getValue());
        }
    }
}

