/*
 * Decompiled with CFR 0.152.
 */
package fxc.app.gui.ctrl;

import fxc.app.gui.ctrl.DigitalValueModel;
import fxc.app.gui.ctrl.ValueModelListener;
import java.util.HashSet;
import java.util.Set;

public class BaseDigitalModel
implements DigitalValueModel {
    private int value;
    private final int min;
    private final int max;
    private final int maxLen;
    private final int maxVal;
    private final Set<ValueModelListener> listeners = new HashSet<ValueModelListener>();

    public BaseDigitalModel(int min, int max, int maxLen) {
        this.min = min;
        this.max = max;
        this.maxLen = maxLen;
        this.maxVal = (int)Math.pow(10.0, maxLen);
    }

    @Override
    public void add() {
        if (this.value < this.max) {
            ++this.value;
            this.update();
        }
    }

    @Override
    public void sub() {
        if (this.value > this.min) {
            --this.value;
            this.update();
        }
    }

    @Override
    public void add(char ch) {
        int nw;
        if (Character.isDigit(ch) && (nw = this.value * 10 + Character.getNumericValue(ch)) <= this.maxVal) {
            this.value = nw;
            this.update();
        }
    }

    @Override
    public void clear() {
        this.value = 0;
        this.update();
    }

    @Override
    public void clearLast() {
        this.value /= 10;
        this.update();
    }

    @Override
    public String getValue() {
        return Integer.toString(this.value);
    }

    @Override
    public int getIntValue() {
        return this.value;
    }

    @Override
    public void setIntValue(int value) {
        this.value = value;
        this.update();
    }

    @Override
    public void addListener(ValueModelListener listener) {
        if (listener == null) {
            throw new NullPointerException("ValueModelListener is null");
        }
        this.listeners.add(listener);
    }

    private void update() {
        for (ValueModelListener vml : this.listeners) {
            vml.onChange(this.getValue());
        }
    }
}

