/*
 * Decompiled with CFR 0.152.
 */
package fxc.app.gui.common;

import fxc.app.Configurator;
import fxc.app.gui.common.BaseHardwareScreen;
import ru.softlogic.hardware.lookup.DeviceDescription;
import ru.softlogic.hdw.base.SerialDevConfiguration;
import ru.softlogic.hdw.dev.watchdog.WdtConfiguration;
import ru.softlogic.io.serial.SerialPort;

public class WatchDogScreen
extends BaseHardwareScreen {
    private final Configurator conf;

    public WatchDogScreen(Configurator conf) {
        super(conf, "wdt");
        this.conf = conf;
    }

    @Override
    public void beforeOpen() {
        WdtConfiguration wdt = this.conf.getWatchDog();
        this.processConnection((SerialDevConfiguration)wdt);
    }

    @Override
    protected void updateConf(DeviceDescription desc, SerialPort port) throws Exception {
        this.conf.setWatchdog(new WdtConfiguration(this.cbEnable.isSelected(), desc.getType(), port));
    }

    @Override
    protected void removeConf() {
        this.conf.setWatchdog(null);
    }

    @Override
    protected boolean hasConf() {
        return this.conf.getWatchDog() != null;
    }
}

