/*
 * Decompiled with CFR 0.152.
 */
package fxc.app.gui.common;

import fxc.app.Configurator;
import fxc.app.ScanTask;
import fxc.app.connect.ConnectionCheckTask;
import fxc.app.connect.SyncTimeTask;
import fxc.app.gui.SelectorItem;
import fxc.app.gui.common.ClosableScreen;
import fxc.app.gui.common.LocalConnComparator;
import fxc.app.gui.ctrl.digital.DigitalFieldCloseListener;
import fxc.app.gui.ctrl.digital.DigitalFieldController;
import fxc.app.gui.ctrl.digital.DigitalKeyboardOptions;
import fxc.app.gui.ctrl.letter.LetterFieldController;
import fxc.app.gui.ctrl.letter.LetterKeyboardOptions;
import fxc.app.gui.oth.Dialog;
import fxc.app.gui.oth.GenerateKeyDialog;
import fxc.app.key.GenerateKeyTask;
import fxc.app.key.KeySelectListener;
import fxc.app.key.SearchKeyTask;
import fxc.app.key.SearchServersUrl;
import fxc.app.key.SrvUrlLocation;
import fxc.app.key.TerminalKey;
import fxc.app.key.TerminalKeyUtils;
import fxc.app.model.Environment;
import fxc.app.res.LoggerId;
import fxc.app.res.ResourceId;
import fxc.app.task.WaitTask;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.net.URL;
import java.util.Arrays;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.TreeSet;
import javafx.beans.value.ObservableValue;
import javafx.fxml.FXML;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ComboBox;
import javafx.scene.control.TextField;
import javafx.scene.layout.Pane;
import org.apache.log4j.Logger;
import ru.softlogic.config.add.ConConfiguration;
import ru.softlogic.config.add.Proxy;
import ru.softlogic.config.add.ServerProfile;
import ru.softlogic.ppp.DialupException;
import ru.softlogic.ppp.RPCException;
import ru.softlogic.srv.utils.NetworkUtils;

public class SrvScreen
extends ClosableScreen
implements KeySelectListener,
DigitalFieldCloseListener {
    private final Configurator app;
    private final Logger log;
    private ConConfiguration conf;
    private final Set<ServerProfile> profiles;
    private ServerProfile selectedProfile;
    @FXML
    private ComboBox<String> cbConnection;
    @FXML
    private ComboBox<SelectorItem<ServerProfile>> cbProfile;
    @FXML
    private TextField tfPoint;
    @FXML
    private TextField tfHost;
    @FXML
    private TextField tfHttpPort;
    @FXML
    private TextField tfHttpsPort;
    @FXML
    private Button bProxyHost;
    @FXML
    private Button bConnect;
    @FXML
    private Button bDisconnect;
    @FXML
    private Button bCheckConnection;
    @FXML
    private Button bSyncTime;
    @FXML
    private CheckBox cbUseProxy;
    @FXML
    private CheckBox cbProxyAuth;
    @FXML
    private Pane proxyParams;
    @FXML
    private Pane proxyAuth;
    @FXML
    private DigitalFieldController proxyPortController;
    @FXML
    private DigitalFieldController connTimeoutController;
    @FXML
    private LetterFieldController proxyHostController;
    @FXML
    private LetterFieldController proxyLoginController;
    @FXML
    private LetterFieldController proxyPasswordController;

    public SrvScreen(Configurator conf) {
        super(conf);
        this.app = conf;
        this.profiles = new TreeSet<ServerProfile>(new LocalConnComparator());
        this.log = LoggerId.LOG;
    }

    @Override
    public void initialize(URL location, ResourceBundle resources) {
        this.cbConnection.getItems().clear();
        this.cbConnection.getItems().add((Object)resources.getString("value.notselected"));
        if (Environment.getConnections() != null) {
            this.cbConnection.getItems().addAll(Arrays.asList(Environment.getConnections()));
        }
        this.bConnect.disableProperty().bind((ObservableValue)this.cbConnection.getSelectionModel().selectedIndexProperty().isEqualTo(0));
        this.bDisconnect.disableProperty().bind((ObservableValue)this.cbConnection.getSelectionModel().selectedIndexProperty().isEqualTo(0));
        this.bCheckConnection.disableProperty().bind((ObservableValue)this.cbProfile.getSelectionModel().selectedIndexProperty().isEqualTo(0));
        this.bSyncTime.disableProperty().bind((ObservableValue)this.cbProfile.getSelectionModel().selectedIndexProperty().isEqualTo(0));
        this.cbProfile.valueProperty().addListener((observable, oldValue, newValue) -> this.onProfileChange());
        this.proxyPortController.setOptions(new DigitalKeyboardOptions(0, 65535, 5, 1, ResourceId.BUNDLE.getString("srv.proxy.port")));
        this.proxyHostController.setOptions(new LetterKeyboardOptions(30));
        this.proxyLoginController.setOptions(new LetterKeyboardOptions(30));
        this.proxyPasswordController.setOptions(new LetterKeyboardOptions(30));
        this.connTimeoutController.setOptions(new DigitalKeyboardOptions(15, 180, 3, ResourceId.BUNDLE.getString("srv.timeout.title")));
        this.connTimeoutController.setCloseListener(this);
    }

    @Override
    public void beforeOpen() {
        this.conf = this.app.getConn();
        this.profiles.clear();
        String sp = null;
        if (this.conf != null) {
            this.processProxy(this.conf.getProxy());
            this.update(this.cbConnection, this.conf.getDialup());
            if (this.conf.getProfiles() != null) {
                this.profiles.addAll(Arrays.asList(this.conf.getProfiles()));
            }
            sp = this.conf.getSelected();
        } else {
            this.cbConnection.getSelectionModel().select(0);
        }
        this.onProxyParamsChange();
        this.updateProfiles(sp);
    }

    @FXML
    private void loadKey() {
        this.app.getTaskExecutor().add(new SearchKeyTask(this.app, this));
    }

    @FXML
    private void generateKey() {
        this.app.getTaskExecutor().add(new SearchServersUrl(this.app, new LocalSearchServerslListener()));
    }

    @FXML
    private void apply() {
        this.updateConn();
        this.close();
    }

    @FXML
    private void checkConnection() {
        this.app.getTaskExecutor().add(new ConnectionCheckTask(this.app));
    }

    @FXML
    public void search() {
        this.app.getTaskExecutor().add(new ScanTask(this.app, Arrays.asList(Environment.getDescriptions()), null, true));
    }

    @FXML
    public void syncTime() {
        this.app.getTaskExecutor().add(new SyncTimeTask(this.app));
    }

    @Override
    public void afrerSearch() {
    }

    @FXML
    private void onProxyParamsChange() {
        this.proxyParams.setDisable(!this.cbUseProxy.isSelected());
        this.proxyAuth.setDisable(!this.cbProxyAuth.isSelected());
    }

    private void processProxy(Proxy proxy) {
        if (proxy != null) {
            this.cbUseProxy.setSelected(proxy.isUse());
            this.proxyHostController.setValue(proxy.getHost());
            this.proxyPortController.setValue(proxy.getPort());
            this.cbProxyAuth.setSelected(proxy.isAuth());
            this.proxyLoginController.setValue(proxy.getUsername());
            this.proxyPasswordController.setValue(proxy.getPassword());
        } else {
            this.cbUseProxy.setSelected(false);
            this.proxyHostController.setValue("");
            this.proxyPortController.setValue(3128);
            this.cbProxyAuth.setSelected(false);
            this.proxyLoginController.setValue("");
            this.proxyPasswordController.setValue("");
        }
    }

    @Override
    public void onSelect(File file) {
        this.log.info((Object)("Select file: " + file));
        try {
            TerminalKey tk = TerminalKeyUtils.load(file, true);
            this.log.info((Object)("Key: " + tk));
            String profileId = NetworkUtils.buildTerminalKeyName((String)tk.getHost(), (int)tk.getHttpsPort(), (int)tk.getPoint());
            ServerProfile sp = new ServerProfile(profileId, tk.getHost(), tk.getHttpPort(), tk.getHttpsPort(), tk.getPoint(), 45);
            this.profiles.add(sp);
            File keys = this.app.getPath("/key/");
            if (!keys.isDirectory()) {
                keys.mkdir();
            }
            this.write(new File(keys, profileId + "_private.key"), tk.getPrivateTerminalKey());
            this.write(new File(keys, profileId + "_public.key"), tk.getPublicServerKey());
            this.updateProfiles(profileId);
            this.updateConn();
        }
        catch (Exception ex) {
            this.log.info((Object)"Error on loading key", (Throwable)ex);
        }
    }

    private void updateConn() {
        Proxy proxy = new Proxy(this.cbUseProxy.isSelected(), this.proxyHostController.getValue(), this.proxyPortController.getValue(), this.cbProxyAuth.isSelected(), this.proxyLoginController.getValue(), this.proxyPasswordController.getValue());
        String dialup = this.cbConnection.getSelectionModel().getSelectedIndex() == 0 ? null : (String)this.cbConnection.getSelectionModel().getSelectedItem();
        ServerProfile sp = (ServerProfile)((SelectorItem)this.cbProfile.getSelectionModel().getSelectedItem()).getData();
        ConConfiguration cc = new ConConfiguration(this.profiles.toArray(new ServerProfile[this.profiles.size()]), sp == null ? null : sp.getId(), proxy, dialup);
        this.app.setConn(cc);
    }

    @FXML
    private void onConnect() {
        this.app.getTaskExecutor().add(new LocalConnTask(this.app));
    }

    @FXML
    private void onDisconnect() {
        this.app.getTaskExecutor().add(new LocalDisconnTask(this.app));
    }

    private void write(File f, String str) throws IOException {
        try (FileWriter fw = new FileWriter(f);){
            fw.write(str);
            fw.flush();
        }
    }

    private void updateProfiles(String selected) {
        this.cbProfile.getItems().clear();
        this.cbProfile.getItems().add(new SelectorItem<Object>(ResourceId.BUNDLE.getString("value.notselected"), null));
        for (ServerProfile sp : this.profiles) {
            this.cbProfile.getItems().add(new SelectorItem<ServerProfile>(sp.getId(), sp));
        }
        this.update(this.cbProfile, new SelectorItem<ServerProfile>(null, new ServerProfile(selected, "", 0, 0, 0, 0)));
    }

    private void onProfileChange() {
        this.tfPoint.setText("");
        this.tfHost.setText("");
        this.tfHttpPort.setText("");
        this.tfHttpsPort.setText("");
        this.connTimeoutController.setValue(0);
        this.connTimeoutController.setDisable(true);
        SelectorItem it = (SelectorItem)this.cbProfile.getSelectionModel().getSelectedItem();
        if (it != null && it.getData() != null) {
            this.selectedProfile = (ServerProfile)it.getData();
            this.tfPoint.setText(Integer.toString(this.selectedProfile.getPointId()));
            this.tfHost.setText(this.selectedProfile.getHost());
            this.tfHttpPort.setText(Integer.toString(this.selectedProfile.getHttpPort()));
            this.tfHttpsPort.setText(Integer.toString(this.selectedProfile.getHttpsPort()));
            this.connTimeoutController.setValue(this.selectedProfile.getTimeout());
            this.connTimeoutController.setDisable(false);
            this.app.setServerProfile(this.selectedProfile);
        }
    }

    @Override
    public void afterClose() {
        this.selectedProfile.setTimeout(this.connTimeoutController.getValue());
    }

    private void showDialog(String msg) {
        this.app.showDialog(new Dialog(ResourceId.BUNDLE.getString("dialog.title.error"), msg, ResourceId.BUNDLE.getString("dialog.btn.ok")), null);
    }

    class LocalDisconnTask
    extends WaitTask {
        public LocalDisconnTask(Configurator conf) {
            super(conf);
        }

        @Override
        public Object process() throws InterruptedException {
            try {
                SrvScreen.this.app.getConnectionManager().disconnectAll();
                return null;
            }
            catch (DialupException | RPCException ex) {
                SrvScreen.this.log.error((Object)"Error on disconnect", ex);
                return ex;
            }
        }

        @Override
        protected void _onResult(Object object) {
            super._onResult(object);
            if (object != null && object instanceof Exception) {
                SrvScreen.this.showDialog(((Exception)object).getMessage());
            }
        }
    }

    class LocalConnTask
    extends WaitTask {
        public LocalConnTask(Configurator conf) {
            super(conf);
        }

        @Override
        public Object process() throws InterruptedException {
            try {
                SrvScreen.this.app.getConnectionManager().connect((String)SrvScreen.this.cbConnection.getSelectionModel().getSelectedItem());
                return null;
            }
            catch (DialupException | RPCException ex) {
                SrvScreen.this.log.error((Object)"Error on connect", ex);
                return ex;
            }
        }

        @Override
        protected void _onResult(Object object) {
            super._onResult(object);
            if (object != null && object instanceof Exception) {
                SrvScreen.this.showDialog(((Exception)object).getMessage());
            }
        }
    }

    private class LoadKeyListenerImpl
    implements GenerateKeyTask.LoadKeyListener {
        private LoadKeyListenerImpl() {
        }

        @Override
        public void onLoad(TerminalKey tk) {
            SrvScreen.this.app.loadTerminalKey(tk);
            String profileId = NetworkUtils.buildTerminalKeyName((String)tk.getHost(), (int)tk.getHttpsPort(), (int)tk.getPoint());
            ServerProfile sp = new ServerProfile(profileId, tk.getHost(), tk.getHttpPort(), tk.getHttpsPort(), tk.getPoint(), 45);
            SrvScreen.this.profiles.add(sp);
            SrvScreen.this.updateProfiles(profileId);
        }
    }

    private class LocalSearchServerslListener
    implements SearchServersUrl.SearchServerslListener {
        private LocalSearchServerslListener() {
        }

        @Override
        public void onSelect(final SrvUrlLocation location) {
            final GenerateKeyDialog gkDialog = SrvScreen.this.app.getGui().getGenerateKeyDialog();
            gkDialog.init(new GenerateKeyDialog.GenerateDialogListener(){

                @Override
                public void onClose() {
                    SrvScreen.this.app.getGui().clearPopup(gkDialog.getRoot());
                }

                @Override
                public void onSelect(String pointId, String password) {
                    SrvScreen.this.app.getGui().clearPopup(gkDialog.getRoot());
                    SrvScreen.this.app.getTaskExecutor().add(new GenerateKeyTask(SrvScreen.this.app, new LoadKeyListenerImpl(), location.getServer(), pointId, password));
                }
            });
            SrvScreen.this.app.getGui().openPopup(gkDialog.getRoot());
        }
    }
}

