/*
 * Decompiled with CFR 0.152.
 */
package fxc.app.gui.common;

import fxc.app.Configurator;
import fxc.app.ScanTask;
import fxc.app.gui.SelectorItem;
import fxc.app.gui.common.ClosableScreen;
import fxc.app.gui.ctrl.ports.PortSettingController;
import fxc.app.model.Environment;
import fxc.app.res.LoggerId;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import javafx.fxml.FXML;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ComboBox;
import org.apache.log4j.Logger;
import ru.softlogic.hardware.lookup.DeviceDescription;
import ru.softlogic.hardware.search.ConnectedDevice;
import ru.softlogic.hdw.CreatingException;
import ru.softlogic.hdw.dev.sensors.SensorDescriptor;
import ru.softlogic.hdw.dev.sensors.SensorFactory;
import ru.softlogic.hdw.dev.sensors.SensorOptions;
import ru.softlogic.hdw.dev.sensors.SnrConfiguration;
import ru.softlogic.io.Port;
import ru.softlogic.io.PortType;
import ru.softlogic.io.serial.SerialParams;
import ru.softlogic.io.serial.SerialPort;

public class SensorScreen
extends ClosableScreen {
    private final Configurator conf;
    private final Logger log;
    private final List<DeviceDescription> dds;
    @FXML
    protected ComboBox<SelectorItem<DeviceDescription>> cbType;
    @FXML
    protected Button bSearch;
    @FXML
    protected Button bTypeProp;
    @FXML
    protected Button bExit;
    @FXML
    protected Button bSave;
    @FXML
    protected CheckBox cbEnable;
    @FXML
    protected PortSettingController portSettingController;

    public SensorScreen(Configurator conf) {
        super(conf);
        this.conf = conf;
        this.dds = new ArrayList<DeviceDescription>();
        this.log = LoggerId.LOG;
    }

    @Override
    public void initialize(URL location, ResourceBundle resources) {
        super.initialize(location, resources);
        this.cbType.getItems().clear();
        this.cbType.getItems().add(new SelectorItem<Object>(resources.getString("value.notselected"), null));
        if (Environment.getDescriptions() != null) {
            for (DeviceDescription dd : Environment.getDescriptions()) {
                if (!"snr".equals(dd.getCategory())) continue;
                this.cbType.getItems().add(new SelectorItem<DeviceDescription>(dd.getName(), dd));
                this.dds.add(dd);
            }
        }
    }

    @Override
    public void beforeOpen() {
        SnrConfiguration cnr = this.conf.getSensor();
        if (cnr != null) {
            this.cbEnable.setSelected(cnr.isEnable());
            this.update(this.cbType, new SelectorItem<DeviceDescription>(null, Environment.getById("snr", cnr.getDriver())));
            this.onChangeDeviceDescription();
            Port port = cnr.getPort();
            if (port != null) {
                this.portSettingController.setPortName(port.getName());
                if (port.getType() == PortType.SerialPort) {
                    SerialPort sp = (SerialPort)port;
                    this.portSettingController.setParams(sp.getParams());
                }
            } else {
                this.portSettingController.setPortName(null);
                this.portSettingController.setParams(new SerialParams(9600));
            }
        } else {
            this.cbType.getSelectionModel().select(0);
        }
        this.cbType.valueProperty().addListener((observable, oldValue, newValue) -> this.onChangeDeviceDescription());
    }

    @Override
    public void afrerSearch() {
        ConnectedDevice cd = this.conf.getConnectedDevice("snr");
        if (cd == null) {
            this.cbType.getSelectionModel().select(0);
            if (this.portSettingController != null) {
                this.portSettingController.setPortName(null);
                this.portSettingController.setParams(new SerialParams(9600));
            }
        } else {
            this.cbType.getSelectionModel().select(new SelectorItem<DeviceDescription>(null, cd.getDescription()));
            if (this.portSettingController != null) {
                this.portSettingController.setPortName(cd.getPort().getName());
                this.portSettingController.setParams(cd.getPort().getParams());
            }
        }
    }

    private void onChangeDeviceDescription() {
        DeviceDescription dd = (DeviceDescription)((SelectorItem)this.cbType.getSelectionModel().getSelectedItem()).getData();
        this.log.info((Object)("Process " + dd));
        if (dd != null) {
            try {
                SensorDescriptor desc = SensorFactory.createDescriptor((String)dd.getType());
                ArrayList<PortType> ports = new ArrayList<PortType>(3);
                if (desc.isFeatureSupport(1)) {
                    ports.add(PortType.SerialPort);
                }
                if (desc.isFeatureSupport(2)) {
                    ports.add(PortType.SerialPort);
                }
                if (desc.isFeatureSupport(4)) {
                    ports.add(PortType.ParallelPort);
                }
                PortType[] array = new PortType[ports.size()];
                this.portSettingController.showingPorts(ports.toArray(array));
            }
            catch (CreatingException ex) {
                this.log.error((Object)"Error on process profiles", (Throwable)ex);
            }
        } else {
            this.portSettingController.showingPorts(new PortType[0]);
        }
    }

    @FXML
    protected final void search() {
        this.conf.getTaskExecutor().add(new ScanTask(this.conf, this.dds, this, true));
    }

    @FXML
    protected void apply() {
        Port port = this.portSettingController.getPort();
        SelectorItem selectedItem = (SelectorItem)this.cbType.getSelectionModel().getSelectedItem();
        if (port != null && selectedItem != null) {
            String driver = ((DeviceDescription)selectedItem.getData()).getType();
            SnrConfiguration sc = new SnrConfiguration(this.cbEnable.isSelected(), driver, port, new SensorOptions());
            this.conf.setSensor(sc);
        }
        this.close();
    }
}

