/*
 * Decompiled with CFR 0.152.
 */
package fxc.app.gui.common;

import fxc.app.Configurator;
import fxc.app.ScanTask;
import fxc.app.gui.SelectorItem;
import fxc.app.gui.common.ClosableScreen;
import fxc.app.gui.ctrl.digital.DigitalFieldController;
import fxc.app.gui.ctrl.digital.DigitalKeyboardOptions;
import fxc.app.gui.ctrl.letter.LetterFieldController;
import fxc.app.gui.ctrl.letter.LetterKeyboardOptions;
import fxc.app.gui.ctrl.ports.PortSettingController;
import fxc.app.model.Environment;
import fxc.app.res.LoggerId;
import fxc.app.res.ResourceId;
import fxc.app.task.dev.prt.PrinterTestTask;
import java.awt.GraphicsEnvironment;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.ResourceBundle;
import javafx.beans.binding.BooleanBinding;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableValue;
import javafx.fxml.FXML;
import javafx.print.Printer;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ComboBox;
import javafx.scene.layout.Pane;
import org.apache.log4j.Logger;
import ru.softlogic.hardware.lookup.DeviceDescription;
import ru.softlogic.hardware.search.ConnectedDevice;
import ru.softlogic.hardware.search.UsbConnectedDevice;
import ru.softlogic.hdw.CreatingException;
import ru.softlogic.hdw.dev.printer.PrinterFactory;
import ru.softlogic.hdw.dev.printer.PrtConfiguration;
import ru.softlogic.hdw.dev.printer.ipp.IppPrtConfiguration;
import ru.softlogic.hdw.dev.printer.ipp.IppPrtOptions;
import ru.softlogic.hdw.dev.printer.kkm.KkmPrtConfiguration;
import ru.softlogic.hdw.dev.printer.kkm.KkmPrtOptions;
import ru.softlogic.hdw.dev.printer.pos.PosPrinterDescriptor;
import ru.softlogic.hdw.dev.printer.pos.PosPrinterUtils;
import ru.softlogic.hdw.dev.printer.pos.PosPrtConfiguration;
import ru.softlogic.hdw.dev.printer.pos.PosPrtOptions;
import ru.softlogic.io.Port;
import ru.softlogic.io.PortType;
import ru.softlogic.io.serial.SerialParams;
import ru.softlogic.io.serial.SerialPort;

public class PrnScreen
extends ClosableScreen {
    private static final String CLASS_POS = "pos";
    private static final String CLASS_IPP = "ipp";
    private static final String CLASS_KKM = "kkm";
    private final Logger log = LoggerId.LOG;
    private final Configurator app;
    private List<DeviceDescription> dds;
    private PrtConfiguration pc;
    private SerialParams params;
    private String portName;
    @FXML
    private ComboBox<SelectorItem<DeviceDescription>> cbPosType;
    @FXML
    private ComboBox<SelectorItem<DeviceDescription>> cbKkmType;
    @FXML
    private ComboBox<SelectorItem<Integer>> cbPosFont;
    @FXML
    private ComboBox<SelectorItem<Integer>> cbPosSpan;
    @FXML
    private ComboBox<String> cbPosEncode;
    @FXML
    private ComboBox<SelectorItem<String>> cbClass;
    @FXML
    private CheckBox cbPosPneSensor;
    @FXML
    private CheckBox cbPosUseCustomFont;
    @FXML
    private Pane posPane;
    @FXML
    private Pane posConnPane;
    @FXML
    private Pane ippPane;
    @FXML
    private Pane ippConnPane;
    @FXML
    private ComboBox<String> cbIppName;
    @FXML
    private ComboBox<String> cbIppFontName;
    @FXML
    private ComboBox<String> cbIppFontSize;
    @FXML
    private ComboBox<String> cbIppScroll;
    @FXML
    private Pane kkmPane;
    @FXML
    private Pane kkmConnPane;
    @FXML
    private ComboBox<SelectorItem<Integer>> cbKkmPresenter;
    @FXML
    private CheckBox cbKkmPosMode;
    @FXML
    private DigitalFieldController posWidthController;
    @FXML
    private DigitalFieldController posLeftController;
    @FXML
    private DigitalFieldController posScrollController;
    @FXML
    private DigitalFieldController kkmScrollController;
    @FXML
    private DigitalFieldController kkmWidthController;
    @FXML
    private LetterFieldController kkmPwd1Controller;
    @FXML
    private LetterFieldController kkmPwd2Controller;
    @FXML
    private Button bTest;
    @FXML
    protected PortSettingController posPortSettingController;
    @FXML
    protected PortSettingController kkmPortSettingController;

    public PrnScreen(Configurator conf) {
        super(conf);
        this.app = conf;
    }

    @Override
    public void initialize(URL location, ResourceBundle resources) {
        super.initialize(location, resources);
        this.cbClass.getItems().clear();
        this.cbClass.getItems().add(new SelectorItem<String>(ResourceId.BUNDLE.getString("prn.class.pos"), CLASS_POS));
        this.cbClass.getItems().add(new SelectorItem<String>(ResourceId.BUNDLE.getString("prn.class.ipp"), CLASS_IPP));
        this.cbClass.valueProperty().addListener((observable, oldValue, newValue) -> this.onChangeClass());
        BooleanBinding posCondition = this.cbClass.getSelectionModel().selectedIndexProperty().isEqualTo(0).and((ObservableBooleanValue)this.cbPosType.getSelectionModel().selectedIndexProperty().isNotEqualTo(0)).and((ObservableBooleanValue)this.posPortSettingController.getSelectedProperty());
        BooleanBinding ippCondition = this.cbClass.getSelectionModel().selectedIndexProperty().isEqualTo(1);
        BooleanBinding or = posCondition.or((ObservableBooleanValue)ippCondition);
        this.bTest.disableProperty().bind((ObservableValue)or.not());
        this.posPane.visibleProperty().bind((ObservableValue)this.cbClass.getSelectionModel().selectedIndexProperty().isEqualTo(0));
        this.posConnPane.visibleProperty().bind((ObservableValue)this.cbClass.getSelectionModel().selectedIndexProperty().isEqualTo(0));
        this.ippPane.visibleProperty().bind((ObservableValue)this.cbClass.getSelectionModel().selectedIndexProperty().isEqualTo(1));
        this.ippConnPane.visibleProperty().bind((ObservableValue)this.cbClass.getSelectionModel().selectedIndexProperty().isEqualTo(1));
        this.kkmPane.visibleProperty().bind((ObservableValue)this.cbClass.getSelectionModel().selectedIndexProperty().isEqualTo(2));
        this.kkmConnPane.visibleProperty().bind((ObservableValue)this.cbClass.getSelectionModel().selectedIndexProperty().isEqualTo(2));
        this.dds = new LinkedList<DeviceDescription>();
        this.cbIppName.getItems().clear();
        for (Printer p : Printer.getAllPrinters()) {
            this.cbIppName.getItems().add((Object)p.getName());
        }
        Printer def = Printer.getDefaultPrinter();
        if (def != null) {
            this.cbIppName.getSelectionModel().select((Object)def.getName());
        } else {
            this.cbIppName.getSelectionModel().select(0);
        }
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        String[] names = ge.getAvailableFontFamilyNames();
        if (names != null) {
            this.cbIppFontName.getItems().clear();
            this.cbIppFontName.getItems().add((Object)ResourceId.BUNDLE.getString("prn.opt.ipp.font-name.default"));
            this.cbIppFontName.getItems().addAll(Arrays.asList(names));
        }
        this.cbPosType.getItems().clear();
        this.cbPosType.getItems().add(new SelectorItem<Object>(resources.getString("value.notselected"), null));
        if (Environment.getDescriptions() != null) {
            for (DeviceDescription dd : Environment.getDescriptions()) {
                if (!CLASS_POS.equals(dd.getCategory())) continue;
                this.cbPosType.getItems().add(new SelectorItem<DeviceDescription>(dd.getName(), dd));
                this.dds.add(dd);
            }
        }
        this.cbPosType.valueProperty().addListener((observable, oldValue, newValue) -> this.onChangePosType());
        this.cbPosFont.getItems().clear();
        this.cbPosFont.getItems().add(new SelectorItem<Integer>(resources.getString("prn.opt.pos.font.default"), 0));
        this.cbPosFont.getItems().add(new SelectorItem<Integer>(resources.getString("prn.opt.pos.font.font_a"), 1));
        this.cbPosFont.getItems().add(new SelectorItem<Integer>(resources.getString("prn.opt.pos.font.font_b"), 2));
        this.cbPosFont.getSelectionModel().select(0);
        this.cbPosUseCustomFont.setSelected(false);
        this.cbPosSpan.getItems().clear();
        this.cbPosSpan.getItems().add(new SelectorItem<Integer>(resources.getString("prn.opt.pos.span.default"), 0));
        this.cbPosSpan.getItems().add(new SelectorItem<Integer>(resources.getString("prn.opt.pos.span.small"), 1));
        this.cbPosSpan.getItems().add(new SelectorItem<Integer>(resources.getString("prn.opt.pos.span.big"), 2));
        this.cbPosSpan.getSelectionModel().select(0);
        this.cbPosEncode.getItems().clear();
        this.cbPosEncode.getItems().add((Object)resources.getString("prn.opt.pos.encode.default"));
        this.cbPosEncode.getItems().addAll((Collection)PosPrinterUtils.getEncodings());
        this.cbPosEncode.getSelectionModel().select(0);
        this.cbKkmType.getItems().clear();
        this.cbKkmType.getItems().add(new SelectorItem<Object>(resources.getString("value.notselected"), null));
        if (Environment.getDescriptions() != null) {
            for (DeviceDescription dd : Environment.getDescriptions()) {
                if (!CLASS_KKM.equals(dd.getCategory())) continue;
                this.cbKkmType.getItems().add(new SelectorItem<DeviceDescription>(dd.getName(), dd));
                this.dds.add(dd);
            }
        }
        if (this.cbKkmType.getItems().size() > 1) {
            this.cbClass.getItems().add(new SelectorItem<String>(ResourceId.BUNDLE.getString("prn.class.kkm"), CLASS_KKM));
        }
        this.cbKkmType.valueProperty().addListener((observable, oldValue, newValue) -> this.onChangeKkmType());
        this.kkmPortSettingController.setPortName(null);
        this.kkmPortSettingController.showingPorts(PortType.SerialPort);
        this.cbKkmPresenter.getItems().clear();
        this.cbKkmPresenter.getItems().add(new SelectorItem<Integer>(resources.getString("prn.opt.kkm.presenter.none"), 0));
        this.cbKkmPresenter.getItems().add(new SelectorItem<Integer>(resources.getString("prn.opt.kkm.presenter.give"), 2));
        this.cbKkmPresenter.getItems().add(new SelectorItem<Integer>(resources.getString("prn.opt.kkm.presenter.take"), 1));
        this.cbKkmPresenter.getSelectionModel().select(0);
        this.posWidthController.setOptions(new DigitalKeyboardOptions(50, 80, 2, 1, ResourceId.BUNDLE.getString("prn.opt.pos.width")));
        this.posLeftController.setOptions(new DigitalKeyboardOptions(0, 20, 2, 1, ResourceId.BUNDLE.getString("prn.opt.pos.left")));
        this.posScrollController.setOptions(new DigitalKeyboardOptions(0, 10, 2, 1, ResourceId.BUNDLE.getString("prn.opt.pos.scroll")));
        this.kkmScrollController.setOptions(new DigitalKeyboardOptions(0, 10, 2, 1, ResourceId.BUNDLE.getString("prn.opt.kkm.scroll")));
        this.kkmWidthController.setOptions(new DigitalKeyboardOptions(30, 50, 2, 1, ResourceId.BUNDLE.getString("prn.opt.kkm.width")));
        this.kkmPwd1Controller.setOptions(new LetterKeyboardOptions(15));
        this.kkmPwd2Controller.setOptions(new LetterKeyboardOptions(15));
    }

    @FXML
    protected final void search() {
        System.out.println(this.dds);
        this.app.getTaskExecutor().add(new ScanTask(this.app, this.dds, this, true));
    }

    @FXML
    protected void apply() {
        this.pc = this.getConfiguration();
        this.app.setPrinter(this.pc);
        this.close();
    }

    @Override
    public void beforeOpen() {
        this.params = new SerialParams(9600);
        this.pc = this.app.getPrinter();
        if (this.pc != null) {
            this.update(this.cbClass, new SelectorItem<String>(null, this.pc.getPrtClass()));
            if (CLASS_IPP.equals(this.pc.getPrtClass())) {
                IppPrtConfiguration ipc = this.pc.getIppPrtConfiguration();
                this.update(this.cbIppName, ipc.getName());
                IppPrtOptions ipo = ipc.getOptions();
                this.update(this.cbIppFontName, ipo.getFontName());
                this.update(this.cbIppFontSize, Integer.toString(ipo.getFontSize()));
                this.update(this.cbIppScroll, Integer.toString(ipo.getScroll()));
            } else if (CLASS_POS.equals(this.pc.getPrtClass())) {
                this.cbPosType.getSelectionModel().select(0);
                this.posPortSettingController.setPortName(null);
                this.cbPosPneSensor.setSelected(true);
                PosPrtConfiguration ppc = this.pc.getPosPrtConfiguration();
                if (ppc != null) {
                    this.update(this.cbPosType, new SelectorItem<DeviceDescription>(null, Environment.getById(CLASS_POS, ppc.getType())));
                    Port port = ppc.getPort();
                    if (port != null) {
                        this.posPortSettingController.setPortName(port.getName());
                        if (port.getType() == PortType.SerialPort) {
                            this.params = ((SerialPort)port).getParams();
                            this.posPortSettingController.setParams(this.params);
                        }
                    }
                    if (ppc.getOptions() != null) {
                        String encode = ppc.getOptions().getEncode();
                        this.update(this.cbPosEncode, encode);
                        this.update(this.cbPosFont, new SelectorItem<Integer>(null, ppc.getOptions().getFont()));
                        this.update(this.cbPosSpan, new SelectorItem<Integer>(null, ppc.getOptions().getSpacing()));
                        this.cbPosPneSensor.setSelected(ppc.getOptions().isUsePneSensor());
                    } else {
                        this.cbPosPneSensor.setSelected(true);
                    }
                }
            } else if (CLASS_KKM.equals(this.pc.getPrtClass())) {
                this.cbKkmType.getSelectionModel().select(0);
                this.kkmPortSettingController.setPortName(null);
                this.cbKkmPosMode.setSelected(false);
                this.kkmWidthController.setValue(0);
                this.kkmScrollController.setValue(0);
                this.cbKkmPresenter.getSelectionModel().select(0);
                KkmPrtConfiguration kpc = this.pc.getKkmPrtConfiguration();
                if (kpc != null) {
                    this.update(this.cbKkmType, new SelectorItem<DeviceDescription>(null, Environment.getById(CLASS_KKM, kpc.getType())));
                    this.kkmPortSettingController.setPortName(kpc.getPort().getName());
                    this.params = kpc.getPort().getParams();
                    this.kkmPortSettingController.setParams(this.params);
                    KkmPrtOptions kpo = kpc.getOptions();
                    if (kpo != null) {
                        this.kkmWidthController.setValue(kpo.getWidth());
                        this.kkmScrollController.setValue(kpo.getScroll());
                        this.update(this.cbKkmPresenter, new SelectorItem<Integer>(null, kpo.getPresenterMode()));
                        this.cbKkmPosMode.setSelected(kpo.isPrinterMode());
                        this.kkmPwd1Controller.setValue(kpo.getPassword1());
                        this.kkmPwd2Controller.setValue(kpo.getPassword2());
                    }
                }
            }
        } else {
            this.update(this.cbClass, new SelectorItem<String>(null, CLASS_POS));
            this.cbPosType.getSelectionModel().select(0);
            this.cbPosPneSensor.setSelected(true);
        }
    }

    @Override
    public void afrerSearch() {
        this.cbPosType.getSelectionModel().select(0);
        this.posPortSettingController.setPortName(null);
        this.params = new SerialParams(9600);
        this.portName = null;
        ConnectedDevice pcd = this.app.getConnectedDevice(CLASS_POS);
        UsbConnectedDevice upcd = this.app.getUsbConnectedDevice(CLASS_POS);
        ConnectedDevice kpc = this.app.getConnectedDevice(CLASS_KKM);
        if (upcd != null) {
            this.cbClass.getSelectionModel().select(new SelectorItem<String>("", CLASS_POS));
            this.portName = upcd.getPort().getName();
            this.cbPosType.getSelectionModel().select(new SelectorItem<DeviceDescription>(null, upcd.getDescription()));
            this.posPortSettingController.getComboBox().getSelectionModel().select((Object)this.portName);
            this.posPortSettingController.setParams(this.params);
            this.cbPosPneSensor.setSelected(true);
        } else if (pcd != null) {
            this.cbClass.getSelectionModel().select(new SelectorItem<String>("", CLASS_POS));
            this.portName = pcd.getPort().getName();
            this.cbPosType.getSelectionModel().select(new SelectorItem<DeviceDescription>(null, pcd.getDescription()));
            this.params = pcd.getPort().getParams();
            this.cbPosPneSensor.setSelected(true);
            this.posPortSettingController.setPortName(this.portName);
            this.posPortSettingController.setParams(this.params);
        } else if (kpc != null) {
            this.cbClass.getSelectionModel().select(new SelectorItem<String>("", CLASS_KKM));
            this.portName = kpc.getPort().getName();
            this.cbKkmType.getSelectionModel().select(new SelectorItem<DeviceDescription>(null, kpc.getDescription()));
            this.kkmPortSettingController.setPortName(this.portName);
            this.params = kpc.getPort().getParams();
            this.kkmPortSettingController.setParams(this.params);
        }
    }

    @FXML
    private void onChangeClass() {
    }

    @FXML
    private void onChangePosType() {
        this.posPortSettingController.setPortName(null);
        DeviceDescription dd = (DeviceDescription)((SelectorItem)this.cbPosType.getSelectionModel().getSelectedItem()).getData();
        this.log.info((Object)("Selected pos type: " + dd));
        if (dd != null) {
            PosPrtConfiguration c = this.pc != null ? this.pc.getPosPrtConfiguration() : null;
            PosPrtOptions opt = this.pc != null && c != null ? c.getOptions() : null;
            try {
                PosPrinterDescriptor ppd = PrinterFactory.createPosDescriptor((String)dd.getType());
                this.log.info((Object)("Descriptor: " + ppd));
                ArrayList<PortType> ptList = new ArrayList<PortType>(3);
                if (ppd.isFeatureSupport(1)) {
                    ptList.add(PortType.SerialPort);
                }
                if (ppd.isFeatureSupport(4)) {
                    ptList.add(PortType.ParallelPort);
                }
                if (ppd.isFeatureSupport(2)) {
                    ptList.add(PortType.UsbPort);
                }
                this.cbPosUseCustomFont.setDisable(ppd.getFontA() == null || ppd.getFontB() == null);
                PortType[] array = new PortType[ptList.size()];
                this.posPortSettingController.showingPorts(ptList.toArray(array));
                if (opt != null && this.pc.getPosPrtConfiguration().getType().equals(dd.getType())) {
                    this.posLeftController.setValue(opt.getLeftMargin());
                    this.posWidthController.setValue(opt.getWidth());
                    this.posScrollController.setValue(opt.getScroll());
                    this.cbPosUseCustomFont.setSelected(opt.isUseCustomFont());
                } else {
                    this.posLeftController.setValue(ppd.getDefLeftMargin());
                    this.posWidthController.setValue(ppd.getDefWidth());
                    this.posScrollController.setValue(ppd.getDefScroll());
                }
            }
            catch (CreatingException ex) {
                this.log.error((Object)"Error on read descriptor", (Throwable)ex);
            }
            if (c != null && c.getPort() != null) {
                this.update(this.posPortSettingController.getComboBox(), c.getPort().getName());
            } else if (this.portName != null) {
                this.update(this.posPortSettingController.getComboBox(), this.portName);
            }
        } else {
            this.posPortSettingController.showingPorts(new PortType[0]);
            this.posLeftController.setValue(0);
            this.posWidthController.setValue(0);
            this.posScrollController.setValue(0);
        }
    }

    @FXML
    private void onChangeKkmType() {
        this.kkmPortSettingController.setPortName(null);
        DeviceDescription dd = (DeviceDescription)((SelectorItem)this.cbKkmType.getSelectionModel().getSelectedItem()).getData();
        this.log.info((Object)("Selected kkm type: " + dd));
        if (dd != null) {
            KkmPrtConfiguration c = this.pc != null ? this.pc.getKkmPrtConfiguration() : null;
            KkmPrtOptions opt = this.pc != null && c != null ? c.getOptions() : null;
            ArrayList<PortType> ptList = new ArrayList<PortType>(3);
            ptList.add(PortType.SerialPort);
            ptList.add(PortType.ParallelPort);
            ptList.add(PortType.UsbPort);
            PortType[] array = new PortType[ptList.size()];
            this.kkmPortSettingController.showingPorts(ptList.toArray(array));
            if (opt != null && this.pc.getKkmPrtConfiguration().getType().equals(dd.getType())) {
                this.kkmWidthController.setValue(opt.getWidth());
                this.kkmScrollController.setValue(opt.getScroll());
                this.kkmPwd1Controller.setValue(opt.getPassword1());
                this.kkmPwd2Controller.setValue(opt.getPassword1());
            }
            if (c != null && c.getPort() != null) {
                this.update(this.kkmPortSettingController.getComboBox(), c.getPort().getName());
            } else if (this.portName != null) {
                this.update(this.kkmPortSettingController.getComboBox(), this.portName);
            }
        } else {
            this.kkmPortSettingController.showingPorts(new PortType[0]);
            this.kkmWidthController.setValue(0);
            this.kkmScrollController.setValue(0);
            this.kkmPwd1Controller.setValue(null);
            this.kkmPwd2Controller.setValue(null);
        }
    }

    private PrtConfiguration getConfiguration() {
        switch (this.cbClass.getSelectionModel().getSelectedIndex()) {
            case 0: {
                int leftMargin = this.posLeftController.getValue();
                int width = this.posWidthController.getValue();
                int scroll = this.posScrollController.getValue();
                int font = (Integer)((SelectorItem)this.cbPosFont.getSelectionModel().getSelectedItem()).getData();
                int spacing = (Integer)((SelectorItem)this.cbPosSpan.getSelectionModel().getSelectedItem()).getData();
                int eject = 0;
                boolean usePne = this.cbPosPneSensor.isSelected();
                String encode = this.cbPosEncode.getSelectionModel().getSelectedIndex() == 0 ? PosPrinterUtils.getDefaultEncoding() : (String)this.cbPosEncode.getSelectionModel().getSelectedItem();
                boolean useCustomFont = this.cbPosUseCustomFont.isSelected();
                DeviceDescription data = (DeviceDescription)((SelectorItem)this.cbPosType.getSelectionModel().getSelectedItem()).getData();
                if (data == null) {
                    return null;
                }
                Port prt = this.posPortSettingController.getPort();
                PrtConfiguration cnf = new PrtConfiguration();
                cnf.setPrtClass((String)((SelectorItem)this.cbClass.getSelectionModel().getSelectedItem()).getData());
                cnf.setPosPrtConfiguration(new PosPrtConfiguration(data.getType(), prt, new PosPrtOptions(leftMargin, width, scroll, font, spacing, eject, usePne, encode, useCustomFont)));
                return cnf;
            }
            case 1: {
                String fontName = this.cbIppFontName.getSelectionModel().getSelectedIndex() == 0 ? null : (String)this.cbIppFontName.getSelectionModel().getSelectedItem();
                int fontSize = Integer.parseInt((String)this.cbIppFontSize.getSelectionModel().getSelectedItem());
                int scroll = Integer.parseInt((String)this.cbIppScroll.getSelectionModel().getSelectedItem());
                IppPrtOptions opt = new IppPrtOptions(fontSize, fontName, scroll);
                PrtConfiguration cnf = new PrtConfiguration();
                cnf.setPrtClass((String)((SelectorItem)this.cbClass.getSelectionModel().getSelectedItem()).getData());
                cnf.setIppPrtConfiguration(new IppPrtConfiguration((String)this.cbIppName.getSelectionModel().getSelectedItem(), opt));
                return cnf;
            }
            case 2: {
                SerialPort port = this.kkmPortSettingController.getSerialPort();
                PrtConfiguration cnf = new PrtConfiguration();
                DeviceDescription data = (DeviceDescription)((SelectorItem)this.cbKkmType.getSelectionModel().getSelectedItem()).getData();
                if (data == null) {
                    return null;
                }
                boolean prnMode = this.cbKkmPosMode.isSelected();
                int width = this.kkmWidthController.getValue();
                int scroll = this.kkmScrollController.getValue();
                String pwd1 = this.kkmPwd1Controller.getValue();
                String pwd2 = this.kkmPwd2Controller.getValue();
                int pres = (Integer)((SelectorItem)this.cbKkmPresenter.getSelectionModel().getSelectedItem()).getData();
                cnf.setPrtClass((String)((SelectorItem)this.cbClass.getSelectionModel().getSelectedItem()).getData());
                cnf.setKkmPrtConfiguration(new KkmPrtConfiguration(((DeviceDescription)((SelectorItem)this.cbKkmType.getSelectionModel().getSelectedItem()).getData()).getType(), port, new KkmPrtOptions(prnMode, width, scroll, pwd1, pwd2, pres)));
                return cnf;
            }
        }
        return null;
    }

    @FXML
    private void runTest() {
        this.log.info((Object)"Run printer test");
        this.app.getTaskExecutor().add(new PrinterTestTask(this.app, this.getConfiguration()));
    }
}

