/*
 * Decompiled with CFR 0.152.
 */
package fxc.app.gui.common;

import fxc.app.Configurator;
import fxc.app.gui.common.BaseHardwareScreen;
import fxc.app.gui.ctrl.letter.LetterFieldController;
import fxc.app.gui.ctrl.letter.LetterKeyboardOptions;
import fxc.app.gui.oth.Dialog;
import fxc.app.res.LoggerId;
import fxc.app.res.ResourceId;
import fxc.app.task.WaitTask;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import javafx.fxml.FXML;
import javafx.scene.control.CheckBox;
import org.apache.log4j.Logger;
import ru.softlogic.hardware.lookup.DeviceDescription;
import ru.softlogic.hdw.base.SerialDevConfiguration;
import ru.softlogic.hdw.dev.modem.ModConfiguration;
import ru.softlogic.hdw.dev.modem.ModOptions;
import ru.softlogic.hdw.dev.modem.Modem;
import ru.softlogic.hdw.dev.modem.ModemFactory;
import ru.softlogic.hdw.dev.modem.ModemInfo;
import ru.softlogic.hdw.dev.modem.NetworkInfo;
import ru.softlogic.io.serial.SerialPort;

public class ModemScreen
extends BaseHardwareScreen {
    private final Configurator conf;
    private final Logger log;
    @FXML
    private CheckBox cbCheckBalance;
    @FXML
    private LetterFieldController ussdController;

    public ModemScreen(Configurator conf) {
        super(conf, "mod");
        this.conf = conf;
        this.log = LoggerId.LOG;
    }

    @Override
    public void initialize(URL location, ResourceBundle resources) {
        super.initialize(location, resources);
        this.ussdController.setOptions(new LetterKeyboardOptions(1, 20));
    }

    @Override
    public void beforeOpen() {
        ModConfiguration c = this.conf.getModem();
        this.processConnection((SerialDevConfiguration)c);
        if (c != null && c.getOptions() != null) {
            this.cbCheckBalance.setSelected(c.getOptions().isCheckBalance());
            this.ussdController.setValue(c.getOptions().getUssd());
        } else {
            this.cbCheckBalance.setSelected(true);
            this.ussdController.setValue("");
        }
    }

    @Override
    protected void updateConf(DeviceDescription desc, SerialPort port) throws Exception {
        this.conf.setModem(new ModConfiguration(this.cbEnable.isSelected(), desc.getType(), port, this.getOptions()));
    }

    @Override
    protected void removeConf() {
        this.conf.setModem(null);
    }

    @Override
    protected boolean hasConf() {
        return this.conf.getModem() != null;
    }

    @FXML
    private void runTest() {
        this.conf.getTaskExecutor().add(new TestModemTask(this.getSelectedDescription().getType(), this.getSelectedPort(), this.getOptions(), this.conf));
    }

    private ModOptions getOptions() {
        return new ModOptions(this.cbCheckBalance.isSelected(), this.ussdController.getValue());
    }

    class TestModemTask
    extends WaitTask {
        private final String type;
        private final SerialPort port;
        private final ModOptions opt;
        private ModemInfo mi;
        private NetworkInfo ni;

        public TestModemTask(String type, SerialPort port, ModOptions opt, Configurator conf) {
            super(conf);
            this.type = type;
            this.port = port;
            this.opt = opt;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object process() {
            try (Modem m = null;){
                ModemScreen.this.log.info((Object)("Try to create modem, options: " + this.opt));
                m = ModemFactory.createModem((String)this.type, (SerialPort)this.port, (ModOptions)this.opt, (Logger)LoggerId.LOG);
                ModemScreen.this.log.info((Object)"Done, try to open port");
                m.open();
                ModemScreen.this.log.info((Object)"Done, try to read modem info");
                this.mi = m.init();
                ModemScreen.this.log.info((Object)("Info: " + this.mi));
                ModemScreen.this.log.info((Object)"Try to read network info");
                this.ni = m.getNetworkInfo();
                ModemScreen.this.log.info((Object)("Result: " + this.ni));
            }
            return null;
        }

        @Override
        protected void _onResult(Object object) {
            super._onResult(object);
            ModemScreen.this.log.info((Object)"Show result");
            if (this.mi == null) {
                ModemScreen.this.conf.showDialog(new Dialog(ResourceId.BUNDLE.getString("dialog.title.info"), ResourceId.BUNDLE.getString("mdm.task.test.res.error"), ResourceId.BUNDLE.getString("dialog.btn.ok")), null);
            } else {
                String msg = MessageFormat.format(ResourceId.BUNDLE.getString("mdm.task.test.res.modem"), this.mi.getDeviceInfo().getVendor(), this.mi.getDeviceInfo().getModel(), this.mi.getDeviceInfo().getFirmware(), this.mi.getImei(), this.mi.getImsi());
                msg = this.ni != null ? msg + MessageFormat.format(ResourceId.BUNDLE.getString("mdm.task.test.res.net"), this.ni.getLac(), this.ni.getCid(), this.ni.getSignal(), this.ni.getName(), this.ni.getMncmcc(), this.ni.getBalance() == null ? "n/a" : this.ni.getBalance()) : msg + ResourceId.BUNDLE.getString("mdm.task.test.res.net.error");
                ModemScreen.this.log.info((Object)("Show msg: " + msg));
                ModemScreen.this.conf.showDialog(new Dialog(ResourceId.BUNDLE.getString("dialog.title.info"), msg, ResourceId.BUNDLE.getString("dialog.btn.ok")), null);
            }
        }
    }
}

