/*
 * Decompiled with CFR 0.152.
 */
package fxc.app.gui.common;

import fxc.app.Configurator;
import fxc.app.gui.common.BaseHardwareScreen;
import fxc.app.task.dev.IOCTestTask;
import javafx.fxml.FXML;
import ru.softlogic.hardware.lookup.DeviceDescription;
import ru.softlogic.hdw.base.SerialDevConfiguration;
import ru.softlogic.hdw.dev.ioc.IocConfiguration;
import ru.softlogic.io.serial.SerialPort;

public class IocScreen
extends BaseHardwareScreen {
    private final Configurator conf;
    private IocConfiguration configuration;

    public IocScreen(Configurator conf) {
        super(conf, "ioc");
        this.conf = conf;
    }

    @Override
    protected void updateConf(DeviceDescription desc, SerialPort port) throws Exception {
        this.conf.setIoc(new IocConfiguration(this.cbEnable.isSelected(), desc.getType(), port));
    }

    @Override
    protected void removeConf() {
        this.conf.setCoinDisp(null);
    }

    @Override
    protected boolean hasConf() {
        return this.conf.getCoinDisp() != null;
    }

    @FXML
    private void runTest() {
        IOCTestTask testTask = new IOCTestTask(this.conf, this.getSelectedDescription().getType(), this.getSelectedPort());
        this.conf.getTaskExecutor().add(testTask);
    }

    @Override
    public void beforeOpen() {
        this.configuration = this.conf.getIoc();
        this.processConnection((SerialDevConfiguration)this.configuration);
    }
}

