/*
 * Decompiled with CFR 0.152.
 */
package fxc.app.gui.common;

import fxc.app.Configurator;
import fxc.app.gui.common.BaseScreen;
import fxc.app.gui.ctrl.CatButton;
import fxc.app.model.Environment;
import fxc.app.res.LoggerId;
import fxc.app.res.ResourceId;
import java.net.URL;
import java.util.ResourceBundle;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.scene.control.Button;
import org.apache.log4j.Logger;
import ru.softlogic.hdw.base.SerialDevConfiguration;
import ru.softlogic.hdw.dev.printer.PrtConfiguration;

public class HomeScreen
extends BaseScreen {
    private final Configurator conf;
    private final Logger log;
    @FXML
    private Button ioc;
    @FXML
    private CatButton cashAccController;
    @FXML
    private CatButton coinAccController;
    @FXML
    private CatButton mdmController;
    @FXML
    private CatButton wdtController;
    @FXML
    private CatButton billDispController;
    @FXML
    private CatButton coinDispController;
    @FXML
    private CatButton barController;
    @FXML
    private CatButton crdController;
    @FXML
    private CatButton eppController;
    @FXML
    private CatButton cardDispController;
    @FXML
    private CatButton prnController;

    public HomeScreen(Configurator conf) {
        this.conf = conf;
        this.log = LoggerId.LOG;
    }

    @Override
    public void initialize(URL location, ResourceBundle resources) {
        this.initButton(this.cashAccController, "func.acc.bill", event -> this.openBillAcc(), Environment.isSupportCategory("bvr"));
        this.initButton(this.coinAccController, "func.acc.coin", event -> this.openCoinAcc(), Environment.isSupportCategory("cvr"));
        this.initButton(this.mdmController, "func.modem", event -> this.openModem(), Environment.isSupportCategory("mod"));
        this.initButton(this.wdtController, "func.wdt", event -> this.openWatchDog(), Environment.isSupportCategory("wdt"));
        this.initButton(this.billDispController, "func.disp.bill", event -> this.openBillDisp(), Environment.isSupportCategory("bdm"));
        this.initButton(this.coinDispController, "func.disp.coin", event -> this.openCoinDisp(), Environment.isSupportCategory("cdm"));
        this.initButton(this.barController, "func.bar", event -> this.openBarcode(), Environment.isSupportCategory("bar"));
        this.initButton(this.crdController, "func.cardreader", event -> this.openCardReader(), Environment.isSupportCategory("crd"));
        this.initButton(this.eppController, "func.epp", event -> this.openPinPad(), Environment.isSupportCategory("epp"));
        this.initButton(this.cardDispController, "func.disp.card", event -> this.openCardDisp(), Environment.isSupportCategory("cvd"));
        this.initButton(this.prnController, "func.printer", event -> this.openPrn(), true);
        this.ioc.setDisable(!Environment.isSupportCategory("ioc"));
    }

    @Override
    public void beforeOpen() {
        this.initState(this.cashAccController, (SerialDevConfiguration)this.conf.getBillAcc());
        this.initState(this.coinAccController, (SerialDevConfiguration)this.conf.getCoinAcc());
        this.initState(this.mdmController, (SerialDevConfiguration)this.conf.getModem());
        this.initState(this.wdtController, (SerialDevConfiguration)this.conf.getWatchDog());
        this.initState(this.billDispController, (SerialDevConfiguration)this.conf.getBillDisp());
        this.initState(this.coinDispController, (SerialDevConfiguration)this.conf.getCoinDisp());
        this.initState(this.barController, (SerialDevConfiguration)this.conf.getBarcode());
        this.initState(this.cardDispController, (SerialDevConfiguration)this.conf.getCardDisp());
        this.initState(this.prnController, this.conf.getPrinter());
        this.initState(this.crdController, (SerialDevConfiguration)this.conf.getCardReader());
    }

    @FXML
    private void openBillAcc() {
        this.log.info((Object)"Open bill acceptor panel");
        this.openPane("/fxc/pane/billacc.fxml");
    }

    @FXML
    private void openCoinAcc() {
        this.log.info((Object)"Open coin acceptor panel");
        this.openPane("/fxc/pane/coinacc.fxml");
    }

    @FXML
    private void openBillDisp() {
        this.log.info((Object)"Open bill disp panel");
        this.openPane("/fxc/pane/billdisp.fxml");
    }

    @FXML
    private void openCoinDisp() {
        this.log.info((Object)"Open coin disp panel");
        this.openPane("/fxc/pane/coindisp.fxml");
    }

    @FXML
    private void openCardReader() {
        this.log.info((Object)"Open card reader");
        this.openPane("/fxc/pane/cardreader.fxml");
    }

    @FXML
    private void openPinPad() {
        this.log.info((Object)"Open card reader");
    }

    @FXML
    private void openCardDisp() {
        this.log.info((Object)"Open coin disp panel");
        this.openPane("/fxc/pane/carddisp.fxml");
    }

    @FXML
    private void openSensor() {
        this.log.info((Object)"Open sensor panel");
        this.openPane("/fxc/pane/sensor.fxml");
    }

    @FXML
    private void openWatchDog() {
        this.log.info((Object)"Open watchdog panel");
        this.openPane("/fxc/pane/wdt.fxml");
    }

    @FXML
    private void openModem() {
        this.log.info((Object)"Open modem panel");
        this.openPane("/fxc/pane/modem.fxml");
    }

    @FXML
    private void openConnection() {
        this.log.info((Object)"Open conn panel");
        this.openPane("/fxc/pane/srv.fxml");
    }

    @FXML
    private void openGui() {
        this.log.info((Object)"Open gui panel");
        this.openPane("/fxc/pane/gui.fxml");
    }

    @FXML
    private void openBarcode() {
        this.log.info((Object)"Open barcode panel");
        this.openPane("/fxc/pane/barcode.fxml");
    }

    @FXML
    private void updateConf() {
        this.log.info((Object)"Update configuration");
        this.conf.updateConfiguration();
    }

    @FXML
    private void openPrn() {
        this.log.info((Object)"Open printer panel");
        this.openPane("/fxc/pane/printer.fxml");
    }

    @FXML
    private void openIoc() {
        this.log.info((Object)"Open ioc panel");
        this.openPane("/fxc/pane/ioc.fxml");
    }

    @FXML
    private void closeConf() {
        this.conf.closeConfiguration();
    }

    private void openPane(String url) {
        this.conf.getGui().open(url);
    }

    @Override
    public void afrerSearch() {
    }

    private void initButton(CatButton cb, String msgId, EventHandler eh, boolean active) {
        cb.setTitle(ResourceId.BUNDLE.getString(msgId));
        cb.setOnAction(eh);
        cb.setDisable(!active);
    }

    private void initState(CatButton cb, SerialDevConfiguration conf) {
        if (conf == null) {
            cb.setState(0);
        } else if (conf.getPort() == null || conf.getType() == null) {
            cb.setState(1);
        } else if (conf.isEnable()) {
            cb.setState(2);
        } else {
            cb.setState(3);
        }
    }

    private void initState(CatButton cb, PrtConfiguration conf) {
        if (conf == null) {
            cb.setState(0);
        } else if (conf.getPrtClass() == null || conf.getIppPrtConfiguration() == null && conf.getKkmPrtConfiguration() == null && conf.getPosPrtConfiguration() == null) {
            cb.setState(1);
        } else {
            cb.setState(2);
        }
    }
}

